# EPA Operation ProvideDispensation ERP Input-Parameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Operation ProvideDispensation ERP Input-Parameters**

## Resource Profile: EPA Operation ProvideDispensation ERP Input-Parameters 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAOpProvideDispensationERPInputParameters |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
EPA Operation ProvideDispensation ERP Input-Parameters 

**Usages:**

* Examples for this Profile: [Parameters/example-epa-op-provide-dispensation-erp-input-parameters-1](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-1.md), [Parameters/example-epa-op-provide-dispensation-erp-input-parameters-2](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-2.md) and [Parameters/example-epa-op-provide-dispensation-erp-input-parameters-3](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.csv), [Excel](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.xlsx), [Schematron](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-op-provide-dispensation-erp-input-parameters",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters",
  "version" : "1.3.0",
  "name" : "EPAOpProvideDispensationERPInputParameters",
  "title" : "EPA Operation ProvideDispensation ERP Input-Parameters",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "EPA Operation ProvideDispensation ERP Input-Parameters",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation",
        "path" : "Parameters.parameter",
        "sliceName" : "rxDispensation",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.name",
        "path" : "Parameters.parameter.name",
        "fixedString" : "rxDispensation",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part",
        "path" : "Parameters.parameter.part",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "open"
        },
        "min" : 5,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:prescriptionId",
        "path" : "Parameters.parameter.part",
        "sliceName" : "prescriptionId",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:prescriptionId.name",
        "path" : "Parameters.parameter.part.name",
        "patternString" : "prescriptionId",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:prescriptionId.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/e-prescription-id"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:prescriptionId.resource",
        "path" : "Parameters.parameter.part.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:prescriptionId.part",
        "path" : "Parameters.parameter.part.part",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:authoredOn",
        "path" : "Parameters.parameter.part",
        "sliceName" : "authoredOn",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:authoredOn.name",
        "path" : "Parameters.parameter.part.name",
        "patternString" : "authoredOn",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:authoredOn.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:authoredOn.resource",
        "path" : "Parameters.parameter.part.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:authoredOn.part",
        "path" : "Parameters.parameter.part.part",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medicationDispense",
        "path" : "Parameters.parameter.part",
        "sliceName" : "medicationDispense",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medicationDispense.name",
        "path" : "Parameters.parameter.part.name",
        "patternString" : "medicationDispense",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medicationDispense.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medicationDispense.resource",
        "path" : "Parameters.parameter.part.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationDispense",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medicationDispense.part",
        "path" : "Parameters.parameter.part.part",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medication",
        "path" : "Parameters.parameter.part",
        "sliceName" : "medication",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medication.name",
        "path" : "Parameters.parameter.part.name",
        "patternString" : "medication",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medication.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medication.resource",
        "path" : "Parameters.parameter.part.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Medication",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:medication.part",
        "path" : "Parameters.parameter.part.part",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:organization",
        "path" : "Parameters.parameter.part",
        "sliceName" : "organization",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:organization.name",
        "path" : "Parameters.parameter.part.name",
        "patternString" : "organization",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:organization.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:organization.resource",
        "path" : "Parameters.parameter.part.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:rxDispensation.part:organization.part",
        "path" : "Parameters.parameter.part.part",
        "max" : "0"
      }
    ]
  }
}

```
