# EPA Medication Service Operation Outcome - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Medication Service Operation Outcome**

## Resource Profile: EPA Medication Service Operation Outcome 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome | *Version*:1.0.6-2 |
| Active as of 2025-05-12 | *Computable Name*:EPAMSOperationOutcome |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Das Operation Outcome-Profil für den Medication Service der ePA. 

**Usages:**

* Use this Profile: [EPA Operation RxDispensation ERP Output-Parameters](StructureDefinition-epa-op-rx-dispensation-erp-output-parameters.md) and [EPA Operation RxPrescription ERP Output-Parameters](StructureDefinition-epa-op-rx-prescription-erp-output-parameters.md)
* Examples for this Profile: [OperationOutcome/0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8](OperationOutcome-0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8.md), [OperationOutcome/0b476e35-02d5-4fb0-ad60-79f5eb05e2b4](OperationOutcome-0b476e35-02d5-4fb0-ad60-79f5eb05e2b4.md), [OperationOutcome/0b967346-00bf-412c-8e05-077ed13e873e](OperationOutcome-0b967346-00bf-412c-8e05-077ed13e873e.md), [OperationOutcome/12f5513f-3eef-41ad-baca-826627c890f2](OperationOutcome-12f5513f-3eef-41ad-baca-826627c890f2.md)...Show 24 more,[OperationOutcome/1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5](OperationOutcome-1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5.md),[OperationOutcome/1e5838dd-ec29-4f68-9739-dfa717db515d](OperationOutcome-1e5838dd-ec29-4f68-9739-dfa717db515d.md),[OperationOutcome/24b64018-89f4-4a52-8e9c-c0af279c4e86](OperationOutcome-24b64018-89f4-4a52-8e9c-c0af279c4e86.md),[OperationOutcome/255002c7-aa1b-4163-bdd4-ede482453cca](OperationOutcome-255002c7-aa1b-4163-bdd4-ede482453cca.md),[OperationOutcome/2b34898e-a9d1-4fa6-9959-5ff6033cfcb0](OperationOutcome-2b34898e-a9d1-4fa6-9959-5ff6033cfcb0.md),[OperationOutcome/41d25882-4a02-47e3-a367-f5b5fe8c8015](OperationOutcome-41d25882-4a02-47e3-a367-f5b5fe8c8015.md),[OperationOutcome/446e77ff-9fcb-4232-8de3-74986f78d85f](OperationOutcome-446e77ff-9fcb-4232-8de3-74986f78d85f.md),[OperationOutcome/52c59e99-eba0-4488-b829-39983b9169f5](OperationOutcome-52c59e99-eba0-4488-b829-39983b9169f5.md),[OperationOutcome/912a5e81-6274-439e-9d79-5172c4855a70](OperationOutcome-912a5e81-6274-439e-9d79-5172c4855a70.md),[OperationOutcome/98ca7dff-aa8d-47d0-a074-4055f55cb4db](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4db.md),[OperationOutcome/98ca7dff-aa8d-47d0-a074-4055f55cb4dc](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4dc.md),[OperationOutcome/a1dc2bb2-1776-4ccd-929f-355472077cf6](OperationOutcome-a1dc2bb2-1776-4ccd-929f-355472077cf6.md),[OperationOutcome/a4da96e5-84d6-4883-8789-5df2e1363c40](OperationOutcome-a4da96e5-84d6-4883-8789-5df2e1363c40.md),[OperationOutcome/a94b020a-2f34-4013-83ea-cf1bd0a92cdd](OperationOutcome-a94b020a-2f34-4013-83ea-cf1bd0a92cdd.md),[OperationOutcome/b29880f0-6c99-4fe2-aae2-007e8cb4d9cf](OperationOutcome-b29880f0-6c99-4fe2-aae2-007e8cb4d9cf.md),[OperationOutcome/bef62761-7eea-4daa-a992-36c532232679](OperationOutcome-bef62761-7eea-4daa-a992-36c532232679.md),[OperationOutcome/c03670fe-eaf2-4a38-a333-4dc1470072a2](OperationOutcome-c03670fe-eaf2-4a38-a333-4dc1470072a2.md),[OperationOutcome/c146f801-8f50-4ca4-8578-514d5938e3c3](OperationOutcome-c146f801-8f50-4ca4-8578-514d5938e3c3.md),[OperationOutcome/dc558008-4fbd-4e51-a16a-0cbc382a529f](OperationOutcome-dc558008-4fbd-4e51-a16a-0cbc382a529f.md),[OperationOutcome/e4f1ed42-7741-40f5-a84e-fd688ac74d3e](OperationOutcome-e4f1ed42-7741-40f5-a84e-fd688ac74d3e.md),[OperationOutcome/e69228bf-6f07-4055-8190-e832d2c670dc](OperationOutcome-e69228bf-6f07-4055-8190-e832d2c670dc.md),[OperationOutcome/e730e451-3a44-4842-a8ed-1517a3334465](OperationOutcome-e730e451-3a44-4842-a8ed-1517a3334465.md),[OperationOutcome/ee1e0518-02f2-4d3a-99ae-bae8e91c382d](OperationOutcome-ee1e0518-02f2-4d3a-99ae-bae8e91c382d.md)and[OperationOutcome/fc3e8ea4-41ec-4de2-906e-97871b34adcb](OperationOutcome-fc3e8ea4-41ec-4de2-906e-97871b34adcb.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-ms-operation-outcome)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-ms-operation-outcome.csv), [Excel](StructureDefinition-epa-ms-operation-outcome.xlsx), [Schematron](StructureDefinition-epa-ms-operation-outcome.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-ms-operation-outcome",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome",
  "version" : "1.0.6-2",
  "name" : "EPAMSOperationOutcome",
  "title" : "EPA Medication Service Operation Outcome",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-05-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Das Operation Outcome-Profil für den Medication Service der ePA.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OperationOutcome",
  "baseDefinition" : "https://gematik.de/fhir/ti/StructureDefinition/operation-outcome",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OperationOutcome",
        "path" : "OperationOutcome"
      },
      {
        "id" : "OperationOutcome.issue.details",
        "path" : "OperationOutcome.issue.details",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-ms-operation-outcome-details"
        }
      }
    ]
  }
}

```
