# Medication Type - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Medication Type**

## Extension: Medication Type 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationTypeExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Extension for EPAMedication types

**Context of Use**

This extension may be used on the following element(s):

* Element ID Medication

**Usage info**

**Usages:**

* Use this Extension: [EPA Pharmaceutical Product Medication](StructureDefinition-epa-medication-pharmaceutical-product.md), [EPA Medication PZN Ingredient](StructureDefinition-epa-medication-pzn-ingredient.md) and [EPA Medication](StructureDefinition-epa-medication.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md), [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md)...Show 27 more,[Bundle/example-searchset-medication](Bundle-example-searchset-medication.md),[Medication/1254591a-dd2d-4d17-b8f8-ee3155da0699](Medication-1254591a-dd2d-4d17-b8f8-ee3155da0699.md),[Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md),[Medication/1412aa4f-a9ed-45f2-8916-063fee7eb025](Medication-1412aa4f-a9ed-45f2-8916-063fee7eb025.md),[Medication/19549515-60a8-4e1c-b86a-49518053fe9f](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md),[Medication/2571d29b-e213-40ec-b817-a1490718f491](Medication-2571d29b-e213-40ec-b817-a1490718f491.md),[Medication/312d581c-f5e7-4faa-9de5-c4e1568c6db2](Medication-312d581c-f5e7-4faa-9de5-c4e1568c6db2.md),[Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md),[Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031](Medication-56ca34f1-a3f3-42f7-95a2-f5a6423c2031.md),[Medication/659c0be1-2ec8-4137-9698-dcffee811934](Medication-659c0be1-2ec8-4137-9698-dcffee811934.md),[Medication/83d7ad1c-47d1-4524-829a-5b86ce333bbc](Medication-83d7ad1c-47d1-4524-829a-5b86ce333bbc.md),[Medication/87f08ba2-da7e-467e-86aa-404d9035297c](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md),[Medication/CortisonDexpantenol](Medication-CortisonDexpantenol.md),[Medication/Technical-Exp-EPAMedicationMax](Medication-Technical-Exp-EPAMedicationMax.md),[Medication/a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3](Medication-a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3.md),[Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e](Medication-ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e.md),[Medication/deecd514-235d-41df-a664-e3672208f410](Medication-deecd514-235d-41df-a664-e3672208f410.md),[Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md),[Parameters/example-epa-op-add-eml-entry-input-parameters-1](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md),[Parameters/example-epa-op-add-emp-entry-input-parameters-1](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md),[Parameters/example-epa-op-eml-entry-output-parameters-1](Parameters-example-epa-op-eml-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-1](Parameters-example-epa-op-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-2](Parameters-example-epa-op-emp-entry-output-parameters-2.md),[Parameters/example-epa-op-provide-dispensation-erp-input-parameters-1](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-1.md),[Parameters/example-epa-op-provide-dispensation-erp-input-parameters-2](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-2.md),[Parameters/example-epa-op-provide-prescription-erp-input-parameters-1](Parameters-example-epa-op-provide-prescription-erp-input-parameters-1.md)and[Parameters/example-epa-op-provide-prescription-erp-input-parameters-2](Parameters-example-epa-op-provide-prescription-erp-input-parameters-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-medication-type-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-medication-type-extension.csv), [Excel](StructureDefinition-epa-medication-type-extension.xlsx), [Schematron](StructureDefinition-epa-medication-type-extension.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-medication-type-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
  "version" : "1.3.0",
  "name" : "EPAMedicationTypeExtension",
  "title" : "Medication Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Extension for EPAMedication types",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Medication"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Medication Type",
        "definition" : "Extension for EPAMedication types"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/ti-medication-type-vs"
        }
      }
    ]
  }
}

```
