# EPA MedicationRequest - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MedicationRequest**

## Resource Profile: EPA MedicationRequest 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationRequest |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Defines the medication request resource for the Medication Service in the ePA system. 

**Hinweis**: Bitte die [Ausführungen des Medication IG DE bezüglich des defekten Constraints tim-9](https://build.fhir.org/ig/hl7germany/medication-ig-de-r4/branches/main/StructureDefinition-TimingDgMP.html#hinweise-zur-verwendung) beachten!

**Usages:**

* Use this Profile: [EPA Operation ProvidePrescription ERP Input-Parameters](StructureDefinition-epa-op-provide-prescription-erp-input-parameters.md)
* Refer to this Profile: [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* Examples for this Profile: [MedicationRequest/0435e19e-ed9a-4b5b-a9e9-70924c5922a0](MedicationRequest-0435e19e-ed9a-4b5b-a9e9-70924c5922a0.md), [MedicationRequest/08cb8487-2758-406c-999a-e23a05e63c0b](MedicationRequest-08cb8487-2758-406c-999a-e23a05e63c0b.md), [MedicationRequest/0e7f16e4-d879-4a2c-8292-41c55201bbdd](MedicationRequest-0e7f16e4-d879-4a2c-8292-41c55201bbdd.md), [MedicationRequest/2a794a78-8a72-46ca-bb81-09f702f94e11](MedicationRequest-2a794a78-8a72-46ca-bb81-09f702f94e11.md)...Show 9 more,[MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72](MedicationRequest-3191d752-3adf-4c7f-848d-8d43766fed72.md),[MedicationRequest/3ffb5c34-81e7-45ec-842c-82a2422cb8c8](MedicationRequest-3ffb5c34-81e7-45ec-842c-82a2422cb8c8.md),[MedicationRequest/40df19aa-40e2-4ebc-a11d-9d232dcb0f67](MedicationRequest-40df19aa-40e2-4ebc-a11d-9d232dcb0f67.md),[MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8](MedicationRequest-4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8.md),[MedicationRequest/6461edff-13ec-4dc7-b9f3-aea66bcb0643](MedicationRequest-6461edff-13ec-4dc7-b9f3-aea66bcb0643.md),[MedicationRequest/7efae80a-a4d9-4e26-a1b9-92c72e79cfaa](MedicationRequest-7efae80a-a4d9-4e26-a1b9-92c72e79cfaa.md),[MedicationRequest/ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e](MedicationRequest-ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e.md),[MedicationRequest/f14498f0-4932-490a-91a2-9de8616e133b](MedicationRequest-f14498f0-4932-490a-91a2-9de8616e133b.md)and[MedicationRequest/f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd](MedicationRequest-f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd.md)
* CapabilityStatements using this Profile: [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) and [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-medication-request)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-medication-request.csv), [Excel](StructureDefinition-epa-medication-request.xlsx), [Schematron](StructureDefinition-epa-medication-request.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-medication-request",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request",
  "version" : "1.3.0",
  "name" : "EPAMedicationRequest",
  "title" : "EPA MedicationRequest",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Defines the medication request resource for the Medication Service in the ePA system.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.meta",
        "path" : "MedicationRequest.meta",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.meta.versionId",
        "path" : "MedicationRequest.meta.versionId",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.meta.lastUpdated",
        "path" : "MedicationRequest.meta.lastUpdated",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription",
        "path" : "MedicationRequest.extension",
        "sliceName" : "multiplePrescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:indicator",
        "path" : "MedicationRequest.extension.extension",
        "sliceName" : "indicator"
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:indicator.value[x]",
        "path" : "MedicationRequest.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter",
        "path" : "MedicationRequest.extension.extension",
        "sliceName" : "counter"
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter.value[x]",
        "path" : "MedicationRequest.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter.value[x].numerator",
        "path" : "MedicationRequest.extension.extension.value[x].numerator",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter.value[x].numerator.value",
        "path" : "MedicationRequest.extension.extension.value[x].numerator.value",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter.value[x].denominator",
        "path" : "MedicationRequest.extension.extension.value[x].denominator",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:counter.value[x].denominator.value",
        "path" : "MedicationRequest.extension.extension.value[x].denominator.value",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:period",
        "path" : "MedicationRequest.extension.extension",
        "sliceName" : "period"
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:period.value[x]",
        "path" : "MedicationRequest.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:period.value[x].start",
        "path" : "MedicationRequest.extension.extension.value[x].start",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:period.value[x].end",
        "path" : "MedicationRequest.extension.extension.value[x].end",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:id",
        "path" : "MedicationRequest.extension.extension",
        "sliceName" : "id"
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:id.value[x]",
        "path" : "MedicationRequest.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:id.value[x].system",
        "path" : "MedicationRequest.extension.extension.value[x].system",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:multiplePrescription.extension:id.value[x].value",
        "path" : "MedicationRequest.extension.extension.value[x].value",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:isBvg",
        "path" : "MedicationRequest.extension",
        "sliceName" : "isBvg",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/indicator-bvg-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:isBvg.value[x]",
        "path" : "MedicationRequest.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:isSer",
        "path" : "MedicationRequest.extension",
        "sliceName" : "isSer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/indicator-ser-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:isSer.value[x]",
        "path" : "MedicationRequest.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:prescriberID",
        "path" : "MedicationRequest.extension",
        "sliceName" : "prescriberID",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/prescriber-id-extension"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:prescriberID.value[x]",
        "path" : "MedicationRequest.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:patientID",
        "path" : "MedicationRequest.extension",
        "sliceName" : "patientID",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-id-extension"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:patientID.value[x]",
        "path" : "MedicationRequest.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:narcotics",
        "path" : "MedicationRequest.extension",
        "sliceName" : "narcotics",
        "short" : "Betäubungsmittel (BtM)",
        "definition" : "Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/narcotics-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:narcotics.extension",
        "path" : "MedicationRequest.extension.extension",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:teratogenic",
        "path" : "MedicationRequest.extension",
        "sliceName" : "teratogenic",
        "short" : "T-Rezept",
        "definition" : "Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/teratogenic-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:teratogenic.extension",
        "path" : "MedicationRequest.extension.extension",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:renderedDosageInstruction",
        "path" : "MedicationRequest.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Vollständige Darstellung der Dosierungsanweisungen (generiert aus den Dosage-Elementen).",
        "definition" : "Ein menschenlesbarer, vollständiger Text der Dosierungsanweisungen. Der Text wird aus den strukturierten Dosage-Elementen generiert und dient der patientensicheren Darstellung der Dosierung. Er soll die maschinenlesbaren Angaben konsistent wiedergeben und in einer für Patient:innen verständlichen Form bereitstellen.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationRequest.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.identifier",
        "path" : "MedicationRequest.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "ePrescription identifier and overall transaction identifier",
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationRequest.identifier:RxPrescriptionProcessIdentifier",
        "path" : "MedicationRequest.identifier",
        "sliceName" : "RxPrescriptionProcessIdentifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier"
            ]
          }
        ],
        "patternIdentifier" : {
          "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier"
        }
      },
      {
        "id" : "MedicationRequest.identifier:RxOriginatorProcessIdentifier",
        "path" : "MedicationRequest.identifier",
        "sliceName" : "RxOriginatorProcessIdentifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-originator-process-identifier"
            ]
          }
        ],
        "patternIdentifier" : {
          "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier"
        }
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "short" : "Status of Medication Request",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/ti-medication-request-status-vs"
        }
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "short" : "filler-order",
        "definition" : "e.g. when data is synchronized with the E-Rezept-Fachdienst, the 'filler-order' code should be used here.",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.subject.identifier",
        "path" : "MedicationRequest.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kvid-10"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "short" : "Issue Date",
        "definition" : "Issue Date of the Prescription",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.basedOn",
        "path" : "MedicationRequest.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.basedOn.reference",
        "path" : "MedicationRequest.basedOn.reference",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.basedOn.identifier",
        "path" : "MedicationRequest.basedOn.identifier",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/medication-plan-identifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.note",
        "path" : "MedicationRequest.note",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.note.text",
        "path" : "MedicationRequest.note.text",
        "short" : "Dispensing Note",
        "definition" : "Instructions to the pharmacy that go beyond the dosage information",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "Hier werden Informationen zur Dosierung angegeben.",
        "definition" : "Hier werden Informationen zur Dosierung angegeben.",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.value",
        "path" : "MedicationRequest.dispenseRequest.quantity.value",
        "short" : "Number of Prescribed Packages",
        "definition" : "Number of Prescribed Packages",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.unit",
        "path" : "MedicationRequest.dispenseRequest.quantity.unit",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.system",
        "path" : "MedicationRequest.dispenseRequest.quantity.system",
        "patternUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.code",
        "path" : "MedicationRequest.dispenseRequest.quantity.code",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution",
        "path" : "MedicationRequest.substitution",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
