# EPA MedicationDispense - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MedicationDispense**

## Resource Profile: EPA MedicationDispense 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationDispense |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Defines the medication dispense resource for the Medication Service in the ePA system. 

**Hinweis**: Bitte die [Ausführungen des Medication IG DE bezüglich des defekten Constraints tim-9](https://build.fhir.org/ig/hl7germany/medication-ig-de-r4/branches/main/StructureDefinition-TimingDgMP.html#hinweise-zur-verwendung) beachten!

**Usages:**

* Use this Profile: [EPA Operation ProvideDispensation ERP Input-Parameters](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.md)
* Refer to this Profile: [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* Examples for this Profile: [MedicationDispense/3c10c1ad-1d7a-47e8-abab-00b8299b49b8](MedicationDispense-3c10c1ad-1d7a-47e8-abab-00b8299b49b8.md), [MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43](MedicationDispense-4e6e1623-778e-44a3-b208-8479f5339e43.md), [MedicationDispense/5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad](MedicationDispense-5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad.md), [MedicationDispense/6250569a-3505-4db7-aebc-45dba1f98acc](MedicationDispense-6250569a-3505-4db7-aebc-45dba1f98acc.md)...Show 5 more,[MedicationDispense/b2911d1e-fc63-47bb-8887-63b701bc49c4](MedicationDispense-b2911d1e-fc63-47bb-8887-63b701bc49c4.md),[MedicationDispense/c0b553bd-2542-49d7-b5e1-0a770185e39f](MedicationDispense-c0b553bd-2542-49d7-b5e1-0a770185e39f.md),[MedicationDispense/c3a353f0-c61a-4d6b-affa-daf8c0f6e77c](MedicationDispense-c3a353f0-c61a-4d6b-affa-daf8c0f6e77c.md),[MedicationDispense/f7240e05-01a1-4ce6-a8bb-edb71b6b5104](MedicationDispense-f7240e05-01a1-4ce6-a8bb-edb71b6b5104.md)and[MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c](MedicationDispense-fa0c29e1-c4e7-4f08-91ab-598a2233867c.md)
* CapabilityStatements using this Profile: [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) and [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-medication-dispense)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-medication-dispense.csv), [Excel](StructureDefinition-epa-medication-dispense.xlsx), [Schematron](StructureDefinition-epa-medication-dispense.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-medication-dispense",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense",
  "version" : "1.3.0",
  "name" : "EPAMedicationDispense",
  "title" : "EPA MedicationDispense",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Defines the medication dispense resource for the Medication Service in the ePA system.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.meta",
        "path" : "MedicationDispense.meta",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.meta.versionId",
        "path" : "MedicationDispense.meta.versionId",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.meta.lastUpdated",
        "path" : "MedicationDispense.meta.lastUpdated",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.extension:rxPrescriptionProcessIdentifier",
        "path" : "MedicationDispense.extension",
        "sliceName" : "rxPrescriptionProcessIdentifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension:renderedDosageInstruction",
        "path" : "MedicationDispense.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Vollständige Darstellung der Dosierungsanweisungen (generiert aus den Dosage-Elementen).",
        "definition" : "Ein menschenlesbarer, vollständiger Text der Dosierungsanweisungen. Der Text wird aus den strukturierten Dosage-Elementen generiert und dient der patientensicheren Darstellung der Dosierung. Er soll die maschinenlesbaren Angaben konsistent wiedergeben und in einer für Patient:innen verständlichen Form bereitstellen.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationDispense.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.identifier",
        "path" : "MedicationDispense.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.identifier:RxOriginatorProcessIdentifier",
        "path" : "MedicationDispense.identifier",
        "sliceName" : "RxOriginatorProcessIdentifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-originator-process-identifier"
            ]
          }
        ],
        "patternIdentifier" : {
          "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier"
        }
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "short" : "Status of medication dispense",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/ti-medication-dispense-status-vs"
        }
      },
      {
        "id" : "MedicationDispense.category",
        "path" : "MedicationDispense.category",
        "short" : "Fehlender oder nicht vorhandener Wert weist auf eine Abgabe mit Verschreibung hin.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Definiert den Kontext einer Abgabe: mit oder ohne ärztliche Verschreibung.",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/ti-medication-dispense-category-vs"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.subject.identifier",
        "path" : "MedicationDispense.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kvid-10"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.authorizingPrescription.reference",
        "path" : "MedicationDispense.authorizingPrescription.reference",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "path" : "MedicationDispense.whenHandedOver",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "short" : "Hier werden Informationen zur Dosierung angegeben.",
        "definition" : "Hier werden Informationen zur Dosierung angegeben.",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.substitution",
        "path" : "MedicationDispense.substitution",
        "mustSupport" : true
      }
    ]
  }
}

```
