# ContextExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ContextExtension**

## Extension: ContextExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:ContextExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Extension for indicating the context.

**Context of Use**

This extension may be used on the following element(s):

* Element ID MedicationStatement
* Element ID Medication
* Element ID MedicationRequest

**Usage info**

**Usages:**

* Use this Extension: [eMP MedicationRequest](StructureDefinition-emp-medication-request.md), [eMP Medication](StructureDefinition-emp-medication.md) and [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md), [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md)...Show 30 more,[Bundle/example-searchset-medicationstatement](Bundle-example-searchset-medicationstatement.md),[Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md),[Medication/87f08ba2-da7e-467e-86aa-404d9035297c](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md),[Medication/Technical-Exp-NachtragEmpMedicationEmp](Medication-Technical-Exp-NachtragEmpMedicationEmp.md),[MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md),[MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb](MedicationRequest-71b66f1b-8032-4886-b7bf-e775daee22fb.md),[MedicationRequest/Technical-Exp-NachtragEmpMedicationRequestEmp](MedicationRequest-Technical-Exp-NachtragEmpMedicationRequestEmp.md),[MedicationStatement/0fc1f006-5793-4501-81b6-fe3918fcfa2d](MedicationStatement-0fc1f006-5793-4501-81b6-fe3918fcfa2d.md),[MedicationStatement/133c8159-6398-4937-984a-d741e24556ad](MedicationStatement-133c8159-6398-4937-984a-d741e24556ad.md),[MedicationStatement/1b88713c-64cc-40ad-9665-70ca5f7dfb08](MedicationStatement-1b88713c-64cc-40ad-9665-70ca5f7dfb08.md),[MedicationStatement/1cb0f018-178d-4488-a6b4-2be32dbda784](MedicationStatement-1cb0f018-178d-4488-a6b4-2be32dbda784.md),[MedicationStatement/405ff43e-bc8e-4109-b370-3e31431c5fe0](MedicationStatement-405ff43e-bc8e-4109-b370-3e31431c5fe0.md),[MedicationStatement/71601cdb-8a53-4f26-b5d5-e5457b498e76](MedicationStatement-71601cdb-8a53-4f26-b5d5-e5457b498e76.md),[MedicationStatement/Technical-Exp-NachtragEmlMedicationStatement](MedicationStatement-Technical-Exp-NachtragEmlMedicationStatement.md),[MedicationStatement/Technical-Exp-NachtragEmpMedicationStatementEml](MedicationStatement-Technical-Exp-NachtragEmpMedicationStatementEml.md),[MedicationStatement/ab495b80-c9d2-4ed6-a076-b44b8dfae75a](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md),[MedicationStatement/b87b0908-7765-4ec0-8662-7d3daff08f6e](MedicationStatement-b87b0908-7765-4ec0-8662-7d3daff08f6e.md),[MedicationStatement/cfb84928-15d6-468c-8e17-e77f1ed44904](MedicationStatement-cfb84928-15d6-468c-8e17-e77f1ed44904.md),[MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md),[MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7](MedicationStatement-f3988023-2313-4645-bd6b-f9e37cfb6fc7.md),[Parameters/7ccb2670-7178-4f82-912a-de70f68ecd51](Parameters-7ccb2670-7178-4f82-912a-de70f68ecd51.md),[Parameters/example-epa-op-add-eml-entry-input-parameters-1](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md),[Parameters/example-epa-op-add-emp-entry-input-parameters-1](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md),[Parameters/example-epa-op-add-emp-entry-with-reference-input-parameters-1](Parameters-example-epa-op-add-emp-entry-with-reference-input-parameters-1.md),[Parameters/example-epa-op-eml-entry-output-parameters-1](Parameters-example-epa-op-eml-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-1](Parameters-example-epa-op-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-2](Parameters-example-epa-op-emp-entry-output-parameters-2.md),[Parameters/example-epa-op-link-emp-entry-output-parameters-1](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-unlink-emp-entry-output-parameters-1](Parameters-example-epa-op-unlink-emp-entry-output-parameters-1.md)and[Parameters/example-epa-op-update-emp-entry-input-parameters-1](Parameters-example-epa-op-update-emp-entry-input-parameters-1.md)
* Search Parameters using this Extension: [ContextSP](SearchParameter-context-sp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/context-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-context-extension.csv), [Excel](StructureDefinition-context-extension.xlsx), [Schematron](StructureDefinition-context-extension.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "context-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
  "version" : "1.3.0",
  "name" : "ContextExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Extension for indicating the context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    },
    {
      "type" : "element",
      "expression" : "Medication"
    },
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Extension for indicating the context."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Context of the resource",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/context-code"
        }
      }
    ]
  }
}

```
