# MedicationRequestEffectiveDosePeriodSP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **MedicationRequestEffectiveDosePeriodSP**

## SearchParameter: MedicationRequestEffectiveDosePeriodSP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:MedicationRequestEffectiveDosePeriodSP |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Ermöglicht die Suche anhand des Zeitraums, in dem die Medikation eingenommen werden soll 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "medicationrequest-effective-dose-period-sp",
  "url" : "https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp",
  "version" : "1.3.0",
  "name" : "MedicationRequestEffectiveDosePeriodSP",
  "status" : "active",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Ermöglicht die Suche  anhand des Zeitraums, in dem die Medikation eingenommen werden soll",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "code" : "effective-dose-period",
  "base" : ["MedicationRequest"],
  "type" : "date",
  "expression" : "MedicationRequest.extension('http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod').value.ofType(Period)"
}

```
