# PraxisTI PractitionerRole - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **PraxisTI PractitionerRole**

## Example PractitionerRole: PraxisTI PractitionerRole

**practitioner**: [Dr. Max Manfred Mustermann](Practitioner-498c345f-31f5-4da6-9f04-00fa2bc8af7c.md)

**organization**: [Die Hausarztpraxis](Organization-450a9511-53e5-4af7-be36-a18444bb8dd2.md)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "b9eb9668-b61e-43b5-b3ea-485234836d59",
  "practitioner" : {
    "reference" : "Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c",
    "identifier" : {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PRN",
            "display" : "Provider number"
          }
        ]
      },
      "system" : "https://gematik.de/fhir/sid/telematik-id",
      "value" : "1-1.58.00000056"
    },
    "display" : "Dr. Max Manfred Mustermann"
  },
  "organization" : {
    "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
    "identifier" : {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PRN",
            "display" : "Provider number"
          }
        ]
      },
      "system" : "https://gematik.de/fhir/sid/telematik-id",
      "value" : "9-2.58.00000089"
    },
    "display" : "Die Hausarztpraxis"
  }
}

```
