# ExampleEpaOpProvidePrescriptionERPInputParameters1 - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleEpaOpProvidePrescriptionERPInputParameters1**

## Example Parameters: ExampleEpaOpProvidePrescriptionERPInputParameters1

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "example-epa-op-provide-prescription-erp-input-parameters-1",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-prescription-erp-input-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "rxPrescription",
      "part" : [
        {
          "name" : "prescriptionId",
          "valueIdentifier" : {
            "system" : "https://gematik.de/fhir/erp/NamingSystem/GEM_ERP_NS_PrescriptionId",
            "value" : "160.100.000.000.011.09"
          }
        },
        {
          "name" : "authoredOn",
          "valueDate" : "2025-09-06"
        },
        {
          "name" : "medicationRequest",
          "resource" : {
            "resourceType" : "MedicationRequest",
            "id" : "59b9fa64-4ca1-4bd2-8388-652d0fec32b2",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
              ]
            },
            "extension" : [
              {
                "extension" : [
                  {
                    "url" : "indicator",
                    "valueBoolean" : false
                  }
                ],
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
              },
              {
                "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
                "valueMarkdown" : "1-0-0-0 Stück"
              },
              {
                "extension" : [
                  {
                    "url" : "algorithmVersion",
                    "valueString" : "1.0.1"
                  },
                  {
                    "url" : "language",
                    "valueCode" : "de-DE"
                  }
                ],
                "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
              }
            ],
            "status" : "active",
            "intent" : "filler-order",
            "medicationReference" : {
              "reference" : "Medication/9fae333f-92b1-4f03-b838-cd5c5d2285b5"
            },
            "subject" : {
              "identifier" : {
                "system" : "http://fhir.de/sid/gkv/kvid-10",
                "value" : "X110411319"
              }
            },
            "authoredOn" : "2025-09-06",
            "dosageInstruction" : [
              {
                "timing" : {
                  "repeat" : {
                    "frequency" : 1,
                    "period" : 1,
                    "periodUnit" : "d",
                    "when" : ["MORN"]
                  }
                },
                "doseAndRate" : [
                  {
                    "doseQuantity" : {
                      "value" : 1,
                      "unit" : "Stück",
                      "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                      "code" : "1"
                    }
                  }
                ]
              }
            ],
            "dispenseRequest" : {
              "quantity" : {
                "value" : 1,
                "unit" : "Packung"
              }
            },
            "substitution" : {
              "allowedBoolean" : true
            }
          }
        },
        {
          "name" : "medication",
          "resource" : {
            "resourceType" : "Medication",
            "id" : "9fae333f-92b1-4f03-b838-cd5c5d2285b5",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
              ]
            },
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
                "valueCoding" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "763158003",
                  "display" : "Medicinal product (product)"
                }
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
                "valueCoding" : {
                  "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
                  "code" : "00"
                }
              },
              {
                "url" : "http://fhir.de/StructureDefinition/normgroesse",
                "valueCode" : "N1"
              },
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
                "valueBoolean" : false
              }
            ],
            "code" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ifa/pzn",
                  "code" : "04773414"
                }
              ],
              "text" : "Doxycyclin AL 200 T, 10 Tabletten N1"
            },
            "status" : "active",
            "form" : {
              "coding" : [
                {
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                  "code" : "TAB"
                }
              ]
            },
            "amount" : {
              "numerator" : {
                "extension" : [
                  {
                    "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                    "valueString" : "10"
                  }
                ],
                "unit" : "Tabletten"
              },
              "denominator" : {
                "value" : 1
              }
            },
            "ingredient" : [
              {
                "itemCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://fhir.de/CodeSystem/ask",
                      "code" : "03876"
                    }
                  ],
                  "text" : "Doxycyclin"
                },
                "strength" : {
                  "numerator" : {
                    "value" : 200,
                    "unit" : "mg"
                  },
                  "denominator" : {
                    "value" : 1,
                    "unit" : "Tbl."
                  }
                }
              }
            ]
          }
        },
        {
          "name" : "organization",
          "resource" : {
            "resourceType" : "Organization",
            "id" : "2a61f8e5-806c-4b4e-b6be-73546cc1de3d",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
              ],
              "tag" : [
                {
                  "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
                  "code" : "ldap"
                }
              ]
            },
            "identifier" : [
              {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000045"
              },
              {
                "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR",
                "value" : "012300004"
              }
            ],
            "active" : true,
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                    "code" : "1.2.276.0.76.4.50",
                    "display" : "Betriebsstätte Arzt"
                  }
                ]
              }
            ],
            "name" : "Praxis Dr. med. Max Mustermann",
            "address" : [
              {
                "type" : "both",
                "line" : ["Musterstr. 1", "Mitte"],
                "city" : "Darmstadt",
                "postalCode" : "64283",
                "country" : "DE"
              },
              {
                "type" : "postal",
                "line" : ["45678"],
                "city" : "Darmstadt",
                "country" : "DE"
              }
            ]
          }
        },
        {
          "name" : "practitioner",
          "resource" : {
            "resourceType" : "Practitioner",
            "id" : "d444db71-e932-4c4c-a5cb-1844b2173cef",
            "meta" : {
              "profile" : [
                "https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory|1.0.0"
              ],
              "tag" : [
                {
                  "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
                  "code" : "ldap"
                }
              ]
            },
            "identifier" : [
              {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "1-1.58.00000056"
              },
              {
                "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR",
                "value" : "123456789"
              }
            ],
            "active" : true,
            "name" : [
              {
                "text" : "Dr. Max Manfred Mustermann",
                "family" : "Musterman",
                "given" : ["Max", "Manfred"],
                "prefix" : ["Dr."]
              }
            ]
          }
        }
      ]
    }
  ]
}

```
