# ExpEPAOpUpdateEMPEntryInputParameters_Batch - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExpEPAOpUpdateEMPEntryInputParameters_Batch**

## Example Parameters: ExpEPAOpUpdateEMPEntryInputParameters_Batch



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "7ccb2670-7178-4f82-912a-de70f68ecd51",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-update-emp-entry-input-parameters|1.3.0"
    ]
  },
  "parameter" : [
    {
      "name" : "medicationPlanIdentifier",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/sid/emp-identifier",
        "value" : "266620a9-2c26-41c1-b0cb-a10947b867f5"
      }
    },
    {
      "name" : "empEntry",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "266620a9-2c26-41c1-b0cb-a10947b867f5",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "akuten Behandlung von Migräneanfällen mit und ohne Aura"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Bitte schützen Sie das Arzneimittel vor hohen Temperaturen und direkter Sonneneinstrahlung."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01",
              "end" : "2027-02-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          },
          {
            "extension" : [
              {
                "url" : "reference",
                "valueReference" : {
                  "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c"
                }
              },
              {
                "url" : "addedOn",
                "valueDateTime" : "2026-11-01T15:43:33.244Z"
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/emp-identifier",
            "value" : "266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    }
  ]
}

```
