# GematikOrganization - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **GematikOrganization**

## Example Organization: GematikOrganization

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.

Profile: [Organization in gematik Directoryversion: null1.0.0)](https://simplifier.net/resolve?scope=de.gematik.fhir.directory@1.0.0&canonical=https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory)

Tag: Synchronized from LDAP Directory (Details: Origin code ldap = 'Synchronized from LDAP Directory')

**identifier**: `https://gematik.de/fhir/sid/telematik-id`/9-2.58.00000040

**active**: true

**type**: Betriebsstätte gematik

**name**: gematik GmbH

**alias**: gematik

**address**: gematik GmbH
Friedrichstr. 136,
10117 Berlin

### Contacts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Purpose** | **Name** | **Telecom** |
| * | Administrative | gematik ITSM | [betrieb@gematik.de](mailto:betrieb@gematik.de) |



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "be51e0d2-783d-4e21-b16b-1a4cd7403515",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
    ],
    "tag" : [
      {
        "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
        "code" : "ldap"
      }
    ]
  },
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/sid/telematik-id",
      "value" : "9-2.58.00000040"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
          "code" : "1.2.276.0.76.4.58",
          "display" : "Betriebsstätte gematik"
        }
      ]
    }
  ],
  "name" : "gematik GmbH",
  "alias" : ["gematik"],
  "address" : [
    {
      "text" : "gematik GmbH\nFriedrichstr. 136,\n10117 Berlin",
      "line" : ["Friedrichstr. 136"],
      "city" : "Berlin",
      "district" : "Mitte",
      "state" : "Berlin",
      "postalCode" : "10117",
      "country" : "DE"
    }
  ],
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
            "code" : "ADMIN"
          }
        ]
      },
      "name" : {
        "text" : "gematik ITSM"
      },
      "telecom" : [
        {
          "system" : "email",
          "value" : "betrieb@gematik.de"
        }
      ]
    }
  ]
}

```
