# PraxisTIOrganization - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **PraxisTIOrganization**

## Example Organization: PraxisTIOrganization

Profile: [TI Organizationversion: null1.1.1)](https://gematik.de/fhir/ti/1.2.0/StructureDefinition-ti-organization.html)

**identifier**: `https://gematik.de/fhir/sid/telematik-id`/9-2.58.00000089, `https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR`/721111100

**active**: true

**type**: Betriebsstätte Arzt

**name**: Die Hausarztpraxis

**address**: Friedrichstr. 136,
10117 Berlin

> **contact****telecom**: ph: 0301234567, fax: 030123456789,[hausarztpraxis@example.com](mailto:hausarztpraxis@example.com)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "450a9511-53e5-4af7-be36-a18444bb8dd2",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-organization|1.1.1"
    ]
  },
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/sid/telematik-id",
      "value" : "9-2.58.00000089"
    },
    {
      "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR",
      "value" : "721111100"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
          "code" : "1.2.276.0.76.4.50",
          "display" : "Betriebsstätte Arzt"
        }
      ]
    }
  ],
  "name" : "Die Hausarztpraxis",
  "address" : [
    {
      "text" : "Friedrichstr. 136,\n10117 Berlin",
      "line" : ["Friedrichstr. 136"],
      "city" : "Berlin",
      "district" : "Mitte",
      "state" : "Berlin",
      "postalCode" : "10117",
      "country" : "DE"
    }
  ],
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "phone",
          "value" : "0301234567"
        },
        {
          "system" : "fax",
          "value" : "030123456789"
        },
        {
          "system" : "email",
          "value" : "hausarztpraxis@example.com"
        }
      ]
    }
  ]
}

```
