# Provide Dispensation eRP - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Provide Dispensation eRP**

## OperationDefinition: Provide Dispensation eRP 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:provideDispensation_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
The Provide Dispensation eRP operation in the ePA Medication Service is used to record information about the dispensing of medications based on an electronic prescription in the patient’s record. This operation comes into play when a patient receives their medication from a pharmacy. It documents that the medication has been dispensed as per the prescription, including details like the quantity, date of dispensing, and pharmacy information. This helps maintain a comprehensive overview of the patient’s medication history. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "provide-dispensation-erp-OP",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP",
  "version" : "1.3.0",
  "name" : "provideDispensation_MedicationSvc",
  "title" : "Provide Dispensation eRP",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "The Provide Dispensation eRP operation in the ePA Medication Service is used to record information about the dispensing of medications based on an electronic prescription in the patient's record. This operation comes into play when a patient receives their medication from a pharmacy. It documents that the medication has been dispensed as per the prescription, including details like the quantity, date of dispensing, and pharmacy information. This helps maintain a comprehensive overview of the patient's medication history.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "provide-dispensation-erp",
  "system" : true,
  "type" : false,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-dispensation-erp-output-parameters"
}

```
