# Medication Plan Chronology Log - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Medication Plan Chronology Log**

## OperationDefinition: Medication Plan Chronology Log 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:getMedicationPlanChronologyLog_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Operation liefert die chronologische Historie aller gespeicherten Versionen des elektronischen Medikationsplans (eMP) in Form von Provenance-Ressourcen. Jede Provenance-Instanz beschreibt dabei einen dokumentierten Zustand des eMP zu einem bestimmten Zeitpunkt. Die Operation ermöglicht es, gezielt die Versionshistorie des Medikationsplans abzufragen - etwa um Änderungen nachzuvollziehen oder frühere Zustände einzusehen. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "medication-plan-log-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "GET"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op",
  "version" : "1.3.0",
  "name" : "getMedicationPlanChronologyLog_MedicationSvc",
  "title" : "Medication Plan Chronology Log",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Operation liefert die chronologische Historie aller gespeicherten Versionen des elektronischen Medikationsplans (eMP) in Form von Provenance-Ressourcen. Jede Provenance-Instanz beschreibt dabei einen dokumentierten Zustand des eMP zu einem bestimmten Zeitpunkt. Die Operation ermöglicht es, gezielt die Versionshistorie des Medikationsplans abzufragen - etwa um Änderungen nachzuvollziehen oder frühere Zustände einzusehen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "medication-plan-log",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "_count",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Limit the result bundle to this many entries. To get more entries request the next page.",
      "type" : "integer"
    },
    {
      "name" : "_offset",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Defines the offset of the first entry in the collection.",
      "type" : "integer"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Searchset bundle containing the requested entities.",
      "type" : "Bundle"
    }
  ]
}

```
