# Get Medication Plan (eMP) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Get Medication Plan (eMP)**

## OperationDefinition: Get Medication Plan (eMP) 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:getMedicationPlan_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Operation ermöglicht den gezielten Abruf eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene Medikationsplan besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (Patient) aus dem Patient Service. Die Operation akzeptiert optional eine Provenance-Referenz.id als Eingabeparameter. Wird diese übergeben, liefert die Operation exakt den Zustand des Medikationsplans, wie er durch diese Provenance-Version beschrieben ist. So kann auch ein vergangener Stand des eMP nachvollziehbar wiedergegeben werden. Wird keine Provenance angegeben, gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "get-medication-plan-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "GET"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op",
  "version" : "1.3.0",
  "name" : "getMedicationPlan_MedicationSvc",
  "title" : "Get Medication Plan (eMP)",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Operation ermöglicht den gezielten Abruf eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene Medikationsplan besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (Patient) aus dem Patient Service. Die Operation akzeptiert optional eine Provenance-Referenz.id als Eingabeparameter. Wird diese übergeben, liefert die Operation exakt den Zustand des Medikationsplans, wie er durch diese Provenance-Version beschrieben ist. So kann auch ein vergangener Stand des eMP nachvollziehbar wiedergegeben werden. Wird keine Provenance angegeben, gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "medication-plan",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "provenance",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Die UUID der Provenance-Instanz, die eine bestimmte Version des elektronischen Medikationsplans (eMP) identifiziert. Diese Provenance-Instanz repräsentiert den Zustand zu einem bestimmten Zeitpunkt und bündelt die zu diesem Zeitpunkt aktiven eMP-Elemente. Wird kein provenance-Parameter angegeben, liefert die Operation den aktuellsten bekannten Zustand des eMP zurück.",
      "type" : "uuid"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Ein Bundle vom Typ collection, das alle relevanten Ressourceninstanzen enthält, die zum angegebenen eMP-Zustand gehören. Diese Ressourcen stammen aus dem Datenraum des Medication Service und bilden gemeinsam den logischen Medikationsplan zum gewünschten Stand ab.",
      "type" : "Bundle"
    }
  ]
}

```
