# Add Medication List Entry - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Add Medication List Entry**

## OperationDefinition: Add Medication List Entry 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:addEMLEntry_MedicationSvc |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Diese Operation ermöglicht das gezielte Hinzufügen einer neuen Medikation zur elektronischen Medikationsliste (eML). 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "add-eml-entry-op",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
      "valueCode" : "POST"
    }
  ],
  "url" : "https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op",
  "version" : "1.3.0",
  "name" : "addEMLEntry_MedicationSvc",
  "title" : "Add Medication List Entry",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Operation ermöglicht das gezielte Hinzufügen einer neuen Medikation zur elektronischen Medikationsliste (eML).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "add-eml-entry",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "inputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-eml-entry-input-parameters",
  "outputProfile" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-eml-entry-output-parameters"
}

```
