# JanuviaFilmtabletten_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **JanuviaFilmtabletten_Information**

## Example MedicationStatement: JanuviaFilmtabletten_Information

version: 2; Last updated: 2025-05-22 14:43:34+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.006.24_20250520

**ContextExtension**: PRESCRIPTION

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

1-0-1-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Unknown

**medication**: [Medication 00814665](Medication-bb91cde8-0426-4f4b-a766-5d818d0605bd.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-05-22 --> (ongoing)

**dateAsserted**: 2025-05-22

**derivedFrom**: 

* [MedicationRequest: extension = ,1-0-1-0 Stück,; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.006.24_20250520,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#bb91cde8-0426-4f4b-a766-5d818d0605bd_160.100.000.000.006.24; status = active; intent = filler-order; medication[x] = ->Medication 00814665; authoredOn = 2025-05-20](MedicationRequest-3191d752-3adf-4c7f-848d-8d43766fed72.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.006.24_20250520; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#5d8fbf7c-bdb0-44c2-95fe-423ae0404ccd_160.100.000.000.006.24; status = completed; medication[x] = ->Medication 00814665; whenHandedOver = 2025-05-22](MedicationDispense-4e6e1623-778e-44a3-b208-8479f5339e43.md)

> **dosage****timing**: Morning, Evening, 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "f3988023-2313-4645-bd6b-f9e37cfb6fc7",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-05-22T14:43:34.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.006.24_20250520"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "1-0-1-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-05-22"
  },
  "dateAsserted" : "2025-05-22",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72"
    },
    {
      "reference" : "MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN", "EVE"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
