# Aciclovir_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Aciclovir_Information**

## Example MedicationStatement: Aciclovir_Information

version: 2; Last updated: 2025-08-22 14:44:00+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.014.97_20250821

**ContextExtension**: PRESCRIPTION

**status**: Unknown

**medication**: [Medication 08671219](Medication-312d581c-f5e7-4faa-9de5-c4e1568c6db2.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-08-22 --> (ongoing)

**dateAsserted**: 2025-08-21

**derivedFrom**: 

* [MedicationRequest: extension = ; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.014.97_20250821,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#daf6b2a0-ae87-460c-9b4a-99aa6da48453_160.100.000.000.014.97; status = completed; intent = filler-order; medication[x] = ->Medication 08671219; authoredOn = 2025-08-21](MedicationRequest-6461edff-13ec-4dc7-b9f3-aea66bcb0643.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.014.97_20250821; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#af53f96d-9084-4c99-ae67-b2be27fdcc2a_160.100.000.000.014.9; status = completed; medication[x] = ->Medication 08671219; whenHandedOver = 2025-08-22](MedicationDispense-b2911d1e-fc63-47bb-8887-63b701bc49c4.md)



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "cfb84928-15d6-468c-8e17-e77f1ed44904",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-08-22T14:44:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.014.97_20250821"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/312d581c-f5e7-4faa-9de5-c4e1568c6db2"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-08-22"
  },
  "dateAsserted" : "2025-08-21",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/6461edff-13ec-4dc7-b9f3-aea66bcb0643"
    },
    {
      "reference" : "MedicationDispense/b2911d1e-fc63-47bb-8887-63b701bc49c4"
    }
  ]
}

```
