# Venlafaxin_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Venlafaxin_Information**

## Example MedicationStatement: Venlafaxin_Information

version: 2; Last updated: 2025-02-27 14:43:33+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.001.39_20250227

**ContextExtension**: PRESCRIPTION

**status**: Unknown

**medication**: [Medication 05392039](Medication-56ca34f1-a3f3-42f7-95a2-f5a6423c2031.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-02-27 --> (ongoing)

**dateAsserted**: 2025-02-27

**derivedFrom**: 

* [MedicationRequest: extension = ; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.001.39_20250227,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#5e36a398-8baa-43a7-8c93-4815b8fc4211_160.100.000.000.001.39; status = completed; intent = filler-order; medication[x] = ->Medication 05392039; authoredOn = 2025-02-27](MedicationRequest-7efae80a-a4d9-4e26-a1b9-92c72e79cfaa.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.001.39_20250227; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#9475102b-7677-4ab8-9449-91b91c6aeaa3_160.100.000.000.001.39; status = completed; medication[x] = ->Medication 05392039; whenHandedOver = 2025-02-27](MedicationDispense-c0b553bd-2542-49d7-b5e1-0a770185e39f.md)



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "b87b0908-7765-4ec0-8662-7d3daff08f6e",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-02-27T14:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.001.39_20250227"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-02-27"
  },
  "dateAsserted" : "2025-02-27",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/7efae80a-a4d9-4e26-a1b9-92c72e79cfaa"
    },
    {
      "reference" : "MedicationDispense/c0b553bd-2542-49d7-b5e1-0a770185e39f"
    }
  ]
}

```
