# Diclo_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Diclo_Information**

## Example MedicationStatement: Diclo_Information

version: 1; Last updated: 2026-02-22 14:43:33+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**ContextExtension**: MANUAL

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

1-0-1-0 Stück

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Unknown

**medication**: [Medication Diclo-ratiopharm® bei Schmerzen und Fieber 25 mg Filmtabletten](Medication-2571d29b-e213-40ec-b817-a1490718f491.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2026-02-10 --> (ongoing)

**dateAsserted**: 2026-02-22

> **dosage****timing**: Morning, Evening, 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "71601cdb-8a53-4f26-b5d5-e5457b498e76",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2026-02-22T14:43:33.444Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "MANUAL"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "1-0-1-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/2571d29b-e213-40ec-b817-a1490718f491"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2026-02-10"
  },
  "dateAsserted" : "2026-02-22",
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN", "EVE"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
