# Prospan_Information - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Prospan_Information**

## Example MedicationStatement: Prospan_Information

version: 2; Last updated: 2025-11-27 14:43:42+0000

Profile: [EPA MedicationStatementversion: null1.3.0)](StructureDefinition-epa-medication-statement.md)

**RxPrescriptionProcessIdentifierExtension**: `https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier`/160.100.000.000.002.36_20251127

**ContextExtension**: PRESCRIPTION

**Extension Definition for MedicationStatement.renderedDosageInstruction for Version 5.0**: 

2mal tägl. 5ml

> **Generated Dosage Instructions Meta**
* algorithmVersion: 1.0.1
* language: de-DE

**status**: Unknown

**medication**: [Medication 08585997](Medication-ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e.md)

**subject**: Identifier: NamingSystemKVID/X110411319

**effective**: 2025-11-22 --> (ongoing)

**dateAsserted**: 2025-11-27

**derivedFrom**: 

* [MedicationRequest: extension = ,2mal tägl. 5ml,; identifier = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.002.36_20251127,https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#f4f341f8-56b2-475b-914b-b8533c34f849_160.100.000.000.002.36; status = completed; intent = filler-order; medication[x] = ->Medication 08585997; authoredOn = 2025-11-27](MedicationRequest-40df19aa-40e2-4ebc-a11d-9d232dcb0f67.md)
* [MedicationDispense: extension = https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier#160.100.000.000.002.36_20251127; identifier = https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier#6c94dbcb-e8b0-41cc-b45e-cd00c3495cad_160.100.000.000.002.36; status = completed; medication[x] = ->Medication 08585997; whenHandedOver = 2025-02-27](MedicationDispense-3c10c1ad-1d7a-47e8-abab-00b8299b49b8.md)

### Dosages

| | |
| :--- | :--- |
| - | **Text** |
| * | 2mal tägl. 5ml |



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "1b88713c-64cc-40ad-9665-70ca5f7dfb08",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-11-27T14:43:42.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.002.36_20251127"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode" : "PRESCRIPTION"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
      "valueMarkdown" : "2mal tägl. 5ml"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "status" : "unknown",
  "medicationReference" : {
    "reference" : "Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "effectivePeriod" : {
    "start" : "2025-11-22"
  },
  "dateAsserted" : "2025-11-27",
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/40df19aa-40e2-4ebc-a11d-9d232dcb0f67"
    },
    {
      "reference" : "MedicationDispense/3c10c1ad-1d7a-47e8-abab-00b8299b49b8"
    }
  ],
  "dosage" : [
    {
      "text" : "2mal tägl. 5ml"
    }
  ]
}

```
