# L-Thyroxin_Request_MV_4 - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **L-Thyroxin_Request_MV_4**

## Example MedicationRequest: L-Thyroxin_Request_MV_4



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "3ffb5c34-81e7-45ec-842c-82a2422cb8c8",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-10-27T12:00:06.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "indicator",
          "valueBoolean" : true
        },
        {
          "url" : "counter",
          "valueRatio" : {
            "numerator" : {
              "value" : 4
            },
            "denominator" : {
              "value" : 4
            }
          }
        },
        {
          "url" : "period",
          "valuePeriod" : {
            "start" : "2026-04-01",
            "end" : "2026-06-30"
          }
        },
        {
          "url" : "id",
          "valueIdentifier" : {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:uuid:24e2e10d-e962-4d1c-be4f-8760e690a5f0"
          }
        }
      ],
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
      "value" : "160.100.000.000.017.88_20251027"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "68794d6d-2b05-4d5e-aaf1-49b4b6430104_160.100.000.000.017.88"
    }
  ],
  "status" : "active",
  "intent" : "filler-order",
  "medicationReference" : {
    "reference" : "Medication/659c0be1-2ec8-4137-9698-dcffee811934"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "authoredOn" : "2025-10-27",
  "requester" : {
    "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
  },
  "dispenseRequest" : {
    "quantity" : {
      "value" : 1,
      "unit" : "Packung"
    }
  },
  "substitution" : {
    "allowedBoolean" : false
  }
}

```
