# Ramipril_Request - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Ramipril_Request**

## Example MedicationRequest: Ramipril_Request



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "0e7f16e4-d879-4a2c-8292-41c55201bbdd",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-12-03T14:00:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "indicator",
          "valueBoolean" : false
        }
      ],
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
      "valueMarkdown" : "1-0-0-0 Stück"
    },
    {
      "extension" : [
        {
          "url" : "algorithmVersion",
          "valueString" : "1.0.1"
        },
        {
          "url" : "language",
          "valueCode" : "de-DE"
        }
      ],
      "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
      "value" : "160.100.000.000.019.82_20251202"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "b7791120-8913-47d4-acd0-9ae633f6d6c0_160.100.000.000.019.82"
    }
  ],
  "status" : "completed",
  "intent" : "filler-order",
  "medicationReference" : {
    "reference" : "Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "authoredOn" : "2025-12-02",
  "requester" : {
    "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "quantity" : {
      "value" : 1,
      "unit" : "Packung"
    }
  },
  "substitution" : {
    "allowedBoolean" : true
  }
}

```
