# Sumatriptan_Dispense - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Sumatriptan_Dispense**

## Example MedicationDispense: Sumatriptan_Dispense



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "fa0c29e1-c4e7-4f08-91ab-598a2233867c",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2026-11-01T15:43:33.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.007.24_20261101"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "1da91bd3-d5cb-459b-a270-32fad7d5d5d5_160.100.000.000.007.24"
    }
  ],
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
  },
  "subject" : {
    "identifier" : {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "X110411319"
    }
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "PRN",
                "display" : "Provider number"
              }
            ]
          },
          "system" : "https://gematik.de/fhir/sid/telematik-id",
          "value" : "9-2.58.00000023"
        },
        "display" : "gematik Apotheke"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
    }
  ],
  "whenHandedOver" : "2026-11-01",
  "substitution" : {
    "wasSubstituted" : false
  }
}

```
