# L-Thyroxin_MV_4 - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **L-Thyroxin_MV_4**

## Example Medication: L-Thyroxin_MV_4



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "659c0be1-2ec8-4137-9698-dcffee811934",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-10-27T12:00:05.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.017.88_20251027"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "763158003",
        "display" : "Medicinal product (product)"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
      "valueCoding" : {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
        "code" : "00"
      }
    },
    {
      "url" : "http://fhir.de/StructureDefinition/normgroesse",
      "valueCode" : "N3"
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
      "valueBoolean" : false
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "04634188758173B936C49DD0952A21B9B94544548FFDAFB347F12E710F62EEB4"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "94f9bf5d-1c15-469f-8db6-c6e3d973467f_160.100.000.000.017.88"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "02532741"
      }
    ],
    "text" : "L-Thyroxin Henning 75 100 Tbl. N3"
  },
  "status" : "inactive",
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "TAB"
      }
    ]
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "07511"
          }
        ],
        "text" : "Levothyroxin natrium"
      },
      "strength" : {
        "numerator" : {
          "value" : 0.075,
          "unit" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "Tbl."
        }
      }
    }
  ]
}

```
