# Aciclovir - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Aciclovir**

## Example Medication: Aciclovir



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "312d581c-f5e7-4faa-9de5-c4e1568c6db2",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-08-22T14:45:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.014.97_20250821"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "763158003",
        "display" : "Medicinal product (product)"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
      "valueCoding" : {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
        "code" : "00"
      }
    },
    {
      "url" : "http://fhir.de/StructureDefinition/normgroesse",
      "valueCode" : "N1"
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
      "valueBoolean" : false
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "87AF94E0D43C291C57F286BD7EE360E305CA117B580BC7C153418AF0C83A7666"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "6c05f9f7-9722-40e2-a314-4d45b4da8b12_160.100.000.000.014.97"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "08671219"
      }
    ],
    "text" : "Aciclovir 800 - 1 A Pharma® 35 Tbl. N1"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "TAB"
      }
    ]
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "21906"
          }
        ],
        "text" : "Aciclovir"
      },
      "strength" : {
        "numerator" : {
          "value" : 800,
          "unit" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "Tbl."
        }
      }
    }
  ]
}

```
