# Doxycyclin - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Doxycyclin**

## Example Medication: Doxycyclin



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "19549515-60a8-4e1c-b86a-49518053fe9f",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2025-09-08T14:50:00.244Z",
    "profile" : [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
    ]
  },
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.100.000.000.011.09_20250906"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "763158003",
        "display" : "Medicinal product (product)"
      }
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
      "valueCoding" : {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
        "code" : "00"
      }
    },
    {
      "url" : "http://fhir.de/StructureDefinition/normgroesse",
      "valueCode" : "N1"
    },
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
      "valueBoolean" : false
    }
  ],
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "57A2CD0E021EDE4D8840548BC0F296D54F6D346E123F8279CB25F3D004434EA9"
    },
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "9fae333f-92b1-4f03-b838-cd5c5d2285b5_160.100.000.000.011.09"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://fhir.de/CodeSystem/ifa/pzn",
        "code" : "04773414"
      }
    ],
    "text" : "Doxycyclin AL 200 T, 10 Tabletten N1"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code" : "TAB"
      }
    ]
  },
  "amount" : {
    "numerator" : {
      "extension" : [
        {
          "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
          "valueString" : "10"
        }
      ],
      "unit" : "Tabletten"
    },
    "denominator" : {
      "value" : 1
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://fhir.de/CodeSystem/ask",
            "code" : "03876"
          }
        ],
        "text" : "Doxycyclin"
      },
      "strength" : {
        "numerator" : {
          "value" : 200,
          "unit" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "Tbl."
        }
      }
    }
  ]
}

```
