# EPA Medication Service OperationOutcome Code System - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Medication Service OperationOutcome Code System**

## CodeSystem: EPA Medication Service OperationOutcome Code System 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/CodeSystem/epa-ms-operation-outcome-details | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMSOperationOutcomeDetailsCS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
EPA Medication Service Operation Outcome Code System 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EPAMSOperationOutcomeDetailsVS](ValueSet-epa-ms-operation-outcome-details.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "epa-ms-operation-outcome-details",
  "url" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-ms-operation-outcome-details",
  "version" : "1.3.0",
  "name" : "EPAMSOperationOutcomeDetailsCS",
  "title" : "EPA Medication Service OperationOutcome Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "EPA Medication Service Operation Outcome Code System",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 17,
  "concept" : [
    {
      "code" : "MEDSVC_NO_VALID_STRUCTURE",
      "display" : "Invalid Data Structure in Medication Service"
    },
    {
      "code" : "MEDSVC_PRESCRIPTION_NO_EXIST",
      "display" : "Prescription Not Found in Medication Service"
    },
    {
      "code" : "MEDSVC_PRESCRIPTION_DUPLICATE",
      "display" : "Duplicate Prescription Detected in Medication Service"
    },
    {
      "code" : "MEDSVC_PRESCRIPTION_STATUS",
      "display" : "Operation Not Permitted on Current Prescription Status"
    },
    {
      "code" : "MEDSVC_DISPENSATION_NO_EXIST",
      "display" : "Dispensation Not Found in Medication Service"
    },
    {
      "code" : "MEDSVC_DISPENSATION_STATUS",
      "display" : "Operation Not Permitted on Current Dispensation Status"
    },
    {
      "code" : "MEDSVC_OPERATION_SUCCESS",
      "display" : "Operation Successfully Completed in Medication Service"
    },
    {
      "code" : "MEDSVC_PARAMETERS_REFERENCE_NO_EXIST",
      "display" : "Unresolved Reference in Parameters"
    },
    {
      "code" : "MEDSVC_STATUS_INVALID",
      "display" : "Invalid Status in Parameters"
    },
    {
      "code" : "MEDSVC_STATEMENT_NO_EXIST",
      "display" : "MedicationStatement Not Found"
    },
    {
      "code" : "MEDSVC_PARAMETERS_INVALID_CONTENT",
      "display" : "Provided content not allowed"
    },
    {
      "code" : "MEDSVC_DOSAGE_INVALID",
      "display" : "Invalid dosage structure or content"
    },
    {
      "code" : "MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH",
      "display" : "Mismatch between acknowledged and current eMP chronology ID"
    },
    {
      "code" : "MEDSVC_OPERATION_OUTSIDE_BATCH",
      "display" : "The operation can only be executed within a batch context"
    },
    {
      "code" : "MEDSVC_ALREADY_LINKED",
      "display" : "Already linked to another instance"
    },
    {
      "code" : "MEDSVC_EMP_ENTRY_ALREADY_EXISTS",
      "display" : "eMP entry already exists"
    },
    {
      "code" : "MEDSVC_EMP_NO_EXIST",
      "display" : "eMP does not exist"
    }
  ]
}

```
