# MedicationPlanChronologyLogBundle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **MedicationPlanChronologyLogBundle**

## Example Bundle: MedicationPlanChronologyLogBundle

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "medication-plan-chronology-log-bundle",
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:e83d33d2-5dfe-4e23-a9fc-557c10a02f5e"
  },
  "type" : "searchset",
  "timestamp" : "2026-08-03T14:10:00+01:00",
  "total" : 3,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://epa4all/epa/medication/api/v1/fhir/$medication-plan-log&_count=10&_offset=0"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/283ea1a2-abbe-4404-b412-d27d45e8a845",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "283ea1a2-abbe-4404-b412-d27d45e8a845",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-08-03T14:00:00+01:00",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/29d46448-b585-4501-9660-a1236436560f/_history/1"
          },
          {
            "reference" : "MedicationRequest/9f5200a9-deaf-4c11-ab68-fc4d1c9db92b/_history/2"
          },
          {
            "reference" : "MedicationRequest/f9a249c2-8304-45d9-8b8f-b2865351b17b/_history/1"
          },
          {
            "reference" : "MedicationRequest/da4009cc-ee0d-40a4-92fc-402fd6b0c129/_history/1"
          }
        ],
        "occurredDateTime" : "2026-08-03T14:00:00+01:00",
        "recorded" : "2026-08-03T14:00:00+01:00",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE",
              "display" : "revise"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000040"
              },
              "display" : "gematik Apotheke"
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/75f7a1f9-5bc8-4ff8-884e-120caf30dde5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "75f7a1f9-5bc8-4ff8-884e-120caf30dde5",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-07-11T14:20:00+01:00",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/29d46448-b585-4501-9660-a1236436560f/_history/1"
          },
          {
            "reference" : "MedicationRequest/9f5200a9-deaf-4c11-ab68-fc4d1c9db92b/_history/2"
          },
          {
            "reference" : "MedicationRequest/f9a249c2-8304-45d9-8b8f-b2865351b17b/_history/1"
          }
        ],
        "occurredDateTime" : "2026-07-11T14:20:00+01:00",
        "recorded" : "2026-07-11T14:20:00+01:00",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE",
              "display" : "revise"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000040"
              },
              "display" : "gematik Apotheke"
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/afacd2a0-f3e8-4cc1-ac47-be7a44fe01a3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "afacd2a0-f3e8-4cc1-ac47-be7a44fe01a3",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-07-11T11:15:00+01:00",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/29d46448-b585-4501-9660-a1236436560f/_history/1"
          },
          {
            "reference" : "MedicationRequest/9f5200a9-deaf-4c11-ab68-fc4d1c9db92b/_history/1"
          },
          {
            "reference" : "MedicationRequest/f9a249c2-8304-45d9-8b8f-b2865351b17b/_history/1"
          }
        ],
        "occurredDateTime" : "2026-07-11T11:15:00+01:00",
        "recorded" : "2026-07-11T11:15:00+01:00",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE",
              "display" : "revise"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5",
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000040"
              },
              "display" : "gematik Apotheke"
            }
          }
        ]
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
