# ExampleEpaGetMedicationPlanBundle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **ExampleEpaGetMedicationPlanBundle**

## Example Bundle: ExampleEpaGetMedicationPlanBundle

Das bereitgestellte Beispiel dient ausschließlich als technische Illustration und soll darstellen, wie Elemente befüllt werden könnten oder wie verschiedene Instanzen zusammenhängen und hat keinen Anspruch daran, fachlich korrekt oder sinnvoll zu sein.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-get-medication-plan-bundle-1",
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:6da4d89d-09f9-4c9a-9117-10c7e7948566"
  },
  "type" : "collection",
  "timestamp" : "2027-01-10T10:10:00Z",
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Patient/641f4cf5-e54b-406c-b8a8-1d3292fd5087",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "641f4cf5-e54b-406c-b8a8-1d3292fd5087",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-patient|1.3.0"
          ]
        },
        "identifier" : [
          {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Mustermann",
            "given" : ["Max"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1976-02-01"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenanc/63e6938b-18a3-4b0f-9423-084d53edba7b",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "63e6938b-18a3-4b0f-9423-084d53edba7b",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
            "valueBoolean" : true
          }
        ],
        "target" : [
          {
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/2"
          },
          {
            "reference" : "MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb/_history/1"
          }
        ],
        "occurredDateTime" : "2026-11-01T15:43:33.244Z",
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "71b66f1b-8032-4886-b7bf-e775daee22fb",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-12-01T14:00:00.400Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "Bluthochdruck"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Benazepril kann anfangs Schwindel verursachen - daher zuerst in Ruhe einnehmen und Autofahren vermeiden."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-1-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/emp-identifier",
            "value" : "71b66f1b-8032-4886-b7bf-e775daee22fb"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-12-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN", "EVE"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "13c66845-d0ce-43e1-9b0b-884cbbe8df7f",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-12-01T14:00:00.200Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "763158003",
              "display" : "Medicinal product (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N3"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "D15E4956F59A13CD3BB365799857D6FA9757C62D36DBDB9578D018CA4B6D969F"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "04351736",
              "display" : "Benazepril AL 20mg 98 Filmtabletten N3"
            }
          ],
          "text" : "Benazepril AL 20mg 98 Filmtabletten N3"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "FTA"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "98"
              }
            ],
            "unit" : "Stück"
          },
          "denominator" : {
            "value" : 1
          }
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fhir.de/CodeSystem/ask",
                  "code" : "23413"
                }
              ],
              "text" : "Benazepril hydrochlorid"
            },
            "strength" : {
              "numerator" : {
                "value" : 20,
                "unit" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Filmtbl."
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/8faa45dd-b2dc-4a80-8956-94aeab1db04b",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "8faa45dd-b2dc-4a80-8956-94aeab1db04b",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb/_history/1"
          }
        ],
        "recorded" : "2026-12-01T14:00:00.600Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "266620a9-2c26-41c1-b0cb-a10947b867f5",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/reason-patient-instruction-extension",
            "valueString" : "akuten Behandlung von Migräneanfällen mit und ohne Aura"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
            "valueAnnotation" : {
              "text" : "Bitte schützen Sie das Arzneimittel vor hohen Temperaturen und direkter Sonneneinstrahlung."
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod",
            "valuePeriod" : {
              "start" : "2026-12-01",
              "end" : "2027-02-01"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-origin-medication-extension",
            "valueReference" : {
              "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
            }
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          },
          {
            "extension" : [
              {
                "url" : "reference",
                "valueReference" : {
                  "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c"
                }
              },
              {
                "url" : "addedOn",
                "valueDateTime" : "2026-11-01T15:43:33.244Z"
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/emp-identifier",
            "value" : "266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "note" : [
          {
            "text" : "Hinweis für den LE"
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/87f08ba2-da7e-467e-86aa-404d9035297c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "87f08ba2-da7e-467e-86aa-404d9035297c",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-11-01T14:00:00.200Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "EMP"
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "781405001",
              "display" : "Medicinal product package (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "5CA9B89A31D81FFF6869E6A93B192C03C7F715FC4A568FB060630DD639F94EF1"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "06313728"
            }
          ],
          "text" : "Sumatriptan-1a Pharma 100 mg Tabletten"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "TAB",
              "display" : "Tabletten"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "20 St."
              }
            ],
            "value" : 20,
            "unit" : "St"
          },
          "denominator" : {
            "value" : 1
          }
        }
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/9090b28c-e165-4823-b82b-15bb63012123",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "9090b28c-e165-4823-b82b-15bb63012123",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5/_history/1"
          }
        ],
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000089"
              },
              "display" : "Die Hausarztpraxis"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f29f1d0c-be05-4b0d-a335-3e508da39c0c",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
            "valueCode" : "PRESCRIPTION"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "basedOn" : [
          {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension",
                "valueBoolean" : true
              }
            ],
            "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5"
          }
        ],
        "status" : "unknown",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "effectivePeriod" : {
          "start" : "2025-11-01"
        },
        "dateAsserted" : "2026-11-01",
        "derivedFrom" : [
          {
            "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
          },
          {
            "reference" : "MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c"
          }
        ],
        "dosage" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Provenance/176eec9c-8d5a-46a7-96e3-7af3f68c49ed",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "176eec9c-8d5a-46a7-96e3-7af3f68c49ed",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance|1.3.0"
          ]
        },
        "target" : [
          {
            "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c/_history/2"
          }
        ],
        "recorded" : "2026-11-01T15:43:33.244Z",
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "identifier" : {
                "system" : "https://gematik.de/fhir/sid/epa-fhir-data-service",
                "value" : "MEDICATIONSVC"
              },
              "display" : "ePA Medication Service"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fc7b28e8-05ac-4ac8-86d7-7677d9c6134e",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
            "valueCoding" : {
              "system" : "http://snomed.info/sct",
              "code" : "781405001",
              "display" : "Medicinal product package (product)"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/drug-category-extension",
            "valueCoding" : {
              "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-drug-category-cs",
              "code" : "00"
            }
          },
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-id-vaccine-extension",
            "valueBoolean" : false
          },
          {
            "url" : "http://fhir.de/StructureDefinition/normgroesse",
            "valueCode" : "N1"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
            "value" : "5CA9B89A31D81FFF6869E6A93B192C03C7F715FC4A568FB060630DD639F94EF1"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "a3197c39-d03c-45fa-bcb7-b32578143c56_160.100.000.000.007.24"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://fhir.de/CodeSystem/ifa/pzn",
              "code" : "06313728"
            }
          ],
          "text" : "Sumatriptan-1a Pharma 100 mg Tabletten"
        },
        "status" : "active",
        "form" : {
          "coding" : [
            {
              "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
              "code" : "TAB",
              "display" : "Tabletten"
            }
          ]
        },
        "amount" : {
          "numerator" : {
            "extension" : [
              {
                "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
                "valueString" : "20 St."
              }
            ],
            "value" : 20,
            "unit" : "St"
          },
          "denominator" : {
            "value" : 1
          }
        }
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8",
        "meta" : {
          "versionId" : "2",
          "lastUpdated" : "2026-11-01T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request|1.3.0"
          ]
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "indicator",
                "valueBoolean" : false
              }
            ],
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.renderedDosageInstruction",
            "valueMarkdown" : "1-0-0-0 Stück"
          },
          {
            "extension" : [
              {
                "url" : "algorithmVersion",
                "valueString" : "1.0.1"
              },
              {
                "url" : "language",
                "valueCode" : "de-DE"
              }
            ],
            "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
            "value" : "160.100.000.000.007.24_20250425"
          },
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "5f4bc41c-480e-4ee4-b58e-a99268c1a1d0_160.100.000.000.007.24"
          }
        ],
        "status" : "active",
        "intent" : "filler-order",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "authoredOn" : "2026-11-01",
        "requester" : {
          "reference" : "PractitionerRole/b9eb9668-b61e-43b5-b3ea-485234836d59"
        },
        "basedOn" : [
          {
            "identifier" : {
              "system" : "https://gematik.de/fhir/sid/emp-identifier",
              "value" : "4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
            }
          }
        ],
        "dosageInstruction" : [
          {
            "timing" : {
              "repeat" : {
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d",
                "when" : ["MORN"]
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1,
                  "unit" : "Stück",
                  "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
                  "code" : "1"
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 1,
            "system" : "http://unitsofmeasure.org",
            "code" : "{Package}"
          }
        },
        "substitution" : {
          "allowedBoolean" : true
        }
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "fa0c29e1-c4e7-4f08-91ab-598a2233867c",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2026-11-01T15:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense|1.3.0"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "160.100.000.000.007.24_20261101"
            }
          }
        ],
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
            "value" : "1da91bd3-d5cb-459b-a270-32fad7d5d5d5_160.100.000.000.007.24"
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8",
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "PRN",
                      "display" : "Provider number"
                    }
                  ]
                },
                "system" : "https://gematik.de/fhir/sid/telematik-id",
                "value" : "9-2.58.00000023"
              },
              "display" : "gematik Apotheke"
            }
          }
        ],
        "authorizingPrescription" : [
          {
            "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
          }
        ],
        "whenHandedOver" : "2026-11-01",
        "substitution" : {
          "wasSubstituted" : false
        }
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/PractitionerRole/b9eb9668-b61e-43b5-b3ea-485234836d59",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "b9eb9668-b61e-43b5-b3ea-485234836d59",
        "practitioner" : {
          "reference" : "Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c",
          "identifier" : {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN",
                  "display" : "Provider number"
                }
              ]
            },
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "1-1.58.00000056"
          },
          "display" : "Dr. Max Manfred Mustermann"
        },
        "organization" : {
          "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
          "identifier" : {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN",
                  "display" : "Provider number"
                }
              ]
            },
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000089"
          },
          "display" : "Die Hausarztpraxis"
        }
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Organization/450a9511-53e5-4af7-be36-a18444bb8dd2",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "450a9511-53e5-4af7-be36-a18444bb8dd2",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/ti/StructureDefinition/ti-organization|1.1.1"
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000089"
          },
          {
            "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR",
            "value" : "721111100"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                "code" : "1.2.276.0.76.4.50",
                "display" : "Betriebsstätte Arzt"
              }
            ]
          }
        ],
        "name" : "Die Hausarztpraxis",
        "address" : [
          {
            "text" : "Friedrichstr. 136,\n10117 Berlin",
            "line" : ["Friedrichstr. 136"],
            "city" : "Berlin",
            "district" : "Mitte",
            "state" : "Berlin",
            "postalCode" : "10117",
            "country" : "DE"
          }
        ],
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "0301234567"
              },
              {
                "system" : "fax",
                "value" : "030123456789"
              },
              {
                "system" : "email",
                "value" : "hausarztpraxis@example.com"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "498c345f-31f5-4da6-9f04-00fa2bc8af7c",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory|1.0.0"
          ],
          "tag" : [
            {
              "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
              "code" : "ldap"
            }
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "1-1.58.00000056"
          },
          {
            "system" : "https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR",
            "value" : "123456789"
          }
        ],
        "active" : true,
        "name" : [
          {
            "text" : "Dr. Max Manfred Mustermann",
            "family" : "Musterman",
            "given" : ["Max", "Manfred"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/Organization/151f1697-7512-4e21-9466-1b75207475d8",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "151f1697-7512-4e21-9466-1b75207475d8",
        "meta" : {
          "profile" : [
            "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory|1.0.0"
          ],
          "tag" : [
            {
              "system" : "https://gematik.de/fhir/directory/CodeSystem/Origin",
              "code" : "ldap"
            }
          ]
        },
        "identifier" : [
          {
            "system" : "https://gematik.de/fhir/sid/telematik-id",
            "value" : "9-2.58.00000023"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "https://gematik.de/fhir/directory/CodeSystem/OrganizationProfessionOID",
                "code" : "1.2.276.0.76.4.54",
                "display" : "Öffentliche Apotheke"
              }
            ]
          }
        ],
        "name" : "gematik Apotheke",
        "alias" : ["Apotheke"],
        "address" : [
          {
            "text" : "gematik Apotheke\nFriedrichstr. 136,\n10117 Berlin",
            "line" : ["Friedrichstr. 136"],
            "city" : "Berlin",
            "district" : "Mitte",
            "state" : "Berlin",
            "postalCode" : "10117",
            "country" : "DE"
          }
        ],
        "contact" : [
          {
            "purpose" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/contactentity-type",
                  "code" : "ADMIN"
                }
              ]
            },
            "name" : {
              "text" : "gematik ITSM"
            },
            "telecom" : [
              {
                "system" : "email",
                "value" : "betrieb@gematik.de"
              }
            ]
          }
        ]
      }
    }
  ]
}

```
