# Referenzen - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Referenzen**

## Referenzen

Die nachfolgenden Tabellen enthalten die Bezeichnung der in diesem Implementation Guide referenzierten Dokumente oder externe Quellen.

### Dokumente & Verweise der gematik

| | |
| :--- | :--- |
| [Anfragenportal] | gematik: ePA-Anfragenportal der gematik.https://service.gematik.de/servicedesk/customer/portal/13 |
| [Aktensystemschnittstelle] | gematik: ePA-Aktensystemschnittstelle.https://github.com/gematik/ePA-Basic/blob/ePA-3.1.3/src/openapi/I_Consent_Decision_Management.yaml |
| [gemSpec_Aktensystem_ePAfueralle] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0 |
| [gemSpec_Aktensystem_ePAfueralle#Legal Policy] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Legal Policy gemäß § 341 Absatz 2 SGB V.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#3.10 |
| [gemSpec_Aktensystem_ePAfueralle#A_26406] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: Consent Decision Management - Policy für berechtigte Nutzergruppen und Nutzer.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_26406-01 |
| [gemIG_TI_Common#Medication] | gematik: FHIR IG TI Common - Anforderungen an den Medication Service.https://gematik.de/fhir/ti/1.2.0/actor-epa-medication.html |
| [gemIG_ePA_Basic#IG-EPA74597GNF] | gematik: FHIR IG EPA Basisfunktionalitäten - Anforderung: IG-EPA74597GNF - Speichern der Profilversion.https://gemspec.gematik.de/ig/fhir/epa/1.3.0/general-principles.html#IG-EPA74597GNF |
| [gemIG_TI_Common#MedicationPlanIdentifier] | gematik: FHIR IG TI Common - MedicationPlanIdentifier.https://gemspec.gematik.de/ig/fhir/ti/1.2.0/StructureDefinition-medication-plan-identifier.html |
| [gemIG_ePA_Basic#Medication] | gematik: FHIR IG EPA Basisfunktionalitäten - Anforderungen an den Medication Service.https://gematik.de/fhir/epa/1.3.0/actor-medication.html |
| [OpenAPI JSON des ePA Medication Service Servers] | gematik: OpenAPI JSON des ePA Medication Service Servers.epa-medication-service-server.openapi.json |
| [OpenAPI YAML des ePA Medication Service Servers] | gematik: OpenAPI YAML des ePA Medication Service Servers.epa-medication-service-server.openapi.yaml |
| [OpenAPI JSON des ePA Medication Service Clients] | gematik: OpenAPI JSON des ePA Medication Service Clients.epa-medication-service-client.openapi.json |
| [OpenAPI YAML des ePA Medication Service Clients] | gematik: OpenAPI YAML des ePA Medication Service Clients.epa-medication-service-client.openapi.yaml |
| [gemILF_PS_ePA] | gematik: Implementierungsleitfaden Primärsysteme ePA für alle.https://gemspec.gematik.de/docs/gemILF/gemILF_PS_ePA/latest/ |
| [gemSpec_Krypt] | gematik: Verwendung kryptographischer Algorithmen in der Telematikinfrastruktur.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Krypt/latest/#7 |
| [Medication_Unique_Identifier_Tool] | gematik: Beispielimplementierung für die Generierung eines SHA-256-basierten Hash-Werts für den EPAMedicationUniqueIdentifier.https://github.com/gematik/ePA-Medication/tree/ePA-3.1.3/tools/epamedicationuniqueidentifier |
| [EPAPatient] | gematik: Das Patient-Profil für die ePA.https://gemspec.gematik.de/ig/fhir/epa/1.3.0/StructureDefinition-epa-patient.html |
| [OrganizationDirectory] | gematik: Das OrganizationDirectory-Profil des gematik FHIR Directory.https://simplifier.net/packages/de.gematik.fhir.directory/1.0.0/files/2970166 |
| [PractitionerDirectory] | gematik: Das PractitionerDirectory-Profil des gematik FHIR Directory.https://simplifier.net/packages/de.gematik.fhir.directory/1.0.0/files/2970193 |
| [TIOrganization] | gematik: Das TI Organization-Profil des TI Common IG.https://gemspec.gematik.de/ig/fhir/ti/1.2.0/StructureDefinition-ti-organization.html |
| [EPAActivityProvenance] | gematik: Das Änderungseintrags-Profil für die ePA.https://gemspec.gematik.de/ig/fhir/epa/1.3.0/StructureDefinition-epa-activity-provenance.html |
| [E-Rezept-Anwendungsfälle] | gematik: Anwendungsfälle im E-Rezept.https://github.com/gematik/api-erp/tree/master?tab=readme-ov-file#anwendungsf%C3%A4lle-im-e-rezept |
| [gemIG_ePA_Basic#IG-EPA50964Z2A] | gematik: FHIR IG EPA Basisfunktionalitäten - Anforderung: FHIR Data Service - Durchführung von Datenmigrationen.https://gemspec.gematik.de/ig/fhir/epa/1.3.0/privacy-security.html#IG-EPA50964Z2A |

**Tabelle:**Dokumente & Verweise der gematik

### Weitere Dokumente & Verweise

| | |
| :--- | :--- |
| [FHIR-Spezifikation] | HL7: FHIR R4 Spezifikation.http://hl7.org/fhir/R4/index.html |
| [MIO eMP AMTS-rZI] | mio42: MIO eMP und AMTS-rZI 1.0.0.https://mio.kbv.de/display/EMP1X0X0 |
| [CodeableConcept] | HL7: FHIR R4 Spezifikation CodeableConcept.https://hl7.org/fhir/R4/datatypes.html#CodeableConcept |
| [Medication_IG_DE] | HL7 Deutschland e.V.: Medication IG DE.http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication |
| [DosageDgMP] | HL7 Deutschland e.V.: Dosierangaben im dgMP.http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP |
| [TimingDgMP] | HL7 Deutschland e.V.: Zeitmuster für Dosierangaben im dgMP.http://ig.fhir.de/igs/medication/StructureDefinition/TimingDgMP |
| [NGP] | Bundesministerium für Gesundheit: Schnittstelle des Nationalen Gesundheitsportals gesund.bund.de.https://search.gesund.bund.de/documentation/gematik/ |
| [RFC 2119] | Network Working Group: Key words for use in RFCs to Indicate Requirement Levels.https://datatracker.ietf.org/doc/html/rfc2119 |
| [Multimedikation] | Deutsche Gesellschaft für Allgemeinmedizin und Familienmedizin (DEGAM), Leitliniengruppe Hessen, Hausärztliche Pharmakotherapie: Hausärztliche Leitlinie „Multimedikation“ - Kurzversion (Juli 2021), Abruf 07/2025.https://www.degam.de/files/Inhalte/Leitlinien-Inhalte/Dokumente/DEGAM-S3-Leitlinien/053-043_Multimedikation/oeffentlich/053-043k_Multimedikation_27-07-2021.pdf |
| [Medikationsfehler] | Arzneimittelkommission der Deutschen Ärzteschaft: Nebenwirkungen durch Medikationsfehler (Aus der UAW-Datenbank), 28. Oktober 2016, Abruf 07/2025.https://www.akdae.de/arzneimittelsicherheit/bekanntgaben/newsdetail/nebenwirkungen-durch-medikationsfehler-aus-der-uaw-datenbank |
| [Interop Council] | Jedamzik, S., Degner, R., Schug, S., Heidner, F., Helmer, S., Krieg, S., Pardo Lopez, M. A., Neidhold, B., Ramm, F., Schreiweis, B., Schulte, F., Strunz, A. K., Müller, U., Werner, P., Lange, D., Hilgarth, H., Vogt, W., Fahrenkrog-Petersen, J., Heintges, A., ... Boldt, K.: Positionspapier Digital gestützte Medikationsprozesse, 10. November 2023, Abruf 07/2025.https://www.ina.gematik.de/fileadmin/Arbeitskreisdokumente/Ergebnisdokumente/Analyse_der_Medikationsprozesse/Positionspapier_Analyse_der_Medikationsprozesse.pdf |
| [BMP_Vereinbarungen] | Kassenärztliche Bundesvereinigung K. d. ö. R., Bundesärztekammer Arbeitsgemeinschaft der Deutschen Ärztekammern & Deutschen Apothekerverband e. V.: Vereinbarung eines bundeseinheitlichen Medikationsplans nach § 31a Abs. 4 Satz 1 SGB V, 2016, Abruf 07/2025.https://www.kbv.de/media/sp/Medikationsplan.pdf |
| [ARMIN_Studienergebnisse] | Deutsches Ärzteblatt, Ärzteblatt, D. Ä. G. R. D.: Mortalität und Hospitalisierungen von Patienten mit interprofessionellem Medikationsmanagement, 2023, Abruf 07/2025.https://www.aerzteblatt.de/archiv/mortalitaet-und-hospitalisierungen-von-patienten-mit-interprofessionellem-medikationsmanagement |
| [BMP_Studienergebnisse] | Eickhoff, C., Müller, U., Thomas, S., Schmidt, C., Hartling, L. S., Michael, S., Schulz, M. & Bertsche, T.: Patients Use of a Standardized Medication List - A Mixed Methods Study. Patient Preference And Adherence, Volume 17, 2655-2666, 2023, Abruf 07/2025.https://doi.org/10.2147/ppa.s427192 |
| [MTX_Ueberdosierung] | Stief, L.: MTX-Überdosierung durch Software-Fehler. MMW - Fortschritte der Medizin 167(2), 11., 2025, Abruf 07/2025.https://doi.org/10.1007/s15006-025-4689-x |
| [FHIR_RESTful_API:batch/transaction] | HL7: FHIR R4 - RESTful API: batch/transaction.https://hl7.org/fhir/R4/http.html#transaction |
| [hl7.fhir.uv.xver-r5.r4] | HL7: Offizielle Cross-Version-Paket.https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/ |

**Tabelle:**Weitere Dokumente & Verweise

