# Datenschutz und Sicherheit - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Datenschutz und Sicherheit**

## Datenschutz und Sicherheit

Das ePA-Aktensystem muss nachstehende Anforderungen umsetzen, um Zugriffe auf den Medication Service zu legitimieren.

Dem Medication Service MÜSSEN zur Auswertung in Operationen für jede Aktivität die folgenden Informationen bereitstehen:

* Name des Nutzers
* Nutzergruppe/Rolle (ProfessionOID)
* Kennung (Telematik-ID / KVNR)
* Hinweis auf eine gültige Befugnis des aktuellen Benutzers (requestor)

Der Medication Service MUSS die gesetzlich verbindlichen Regelungen der Zugriffsrechte bezüglich der Berufsgruppen und Datenkategorien aus der [gemSpec_Aktensystem_ePAfueralle#Legal Policy] berücksichtigen. Die generelle Ausführung des Medication Service ist ausschließlich für ePA-Client-Systeme und Fachdienste mit einer Nutzgruppe aus der nachstehenden Liste durchzuführen.

| | |
| :--- | :--- |
| providePrescription_MedicationSvc | * *oid_erp-vau*
 |
| cancelPrescription_MedicationSvc | * *oid_erp-vau*
 |
| provideDispensation_MedicationSvc | * *oid_erp-vau*
 |
| cancelDispensation_MedicationSvc | * *oid_erp-vau*
 |
| listMedications_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getMedicationById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listMedicationDispenses_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listMedicationDispenses_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listMedicationRequests_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getMedicationRequestById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listMedicationStatements_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getMedicationStatementById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listOrganizations_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getOrganizationById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listPractitioners_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getPractitionerById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listPractitionerRoles_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getPractitionerRoleById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| listProvenances_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getProvenanceById_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getMedicationList_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| addEMLEntry_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| cancelEMLEntry_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| getMedicationPlan_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| getMedicationPlanChronologyLog_MedicationSvc | * *oid_institution-arbeitsmedizin*
* *oid_institution-geburtshilfe*
* *oid_institution-oegd*
* *oid_institution-pflege*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-ergotherapeut*
* *oid_praxis-ernaehrungstherapeut*
* *oid_praxis-logopaede*
* *oid_praxis-physiotherapeut*
* *oid_praxis-podologe*
* *oid_praxis_psychotherapeut*
* *oid_versicherter*
* *oid_zahnarztpraxis*
 |
| addEMPEntry_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| updateEMPEntry_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| eMPCommit_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| linkEMP_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| unlinkEMP_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |
| batchEMPEntries_MedicationSvc | * *oid_institution-oegd*
* *oid_institution-vorsorge-reha*
* *oid_krankenhaus*
* *oid_öffentliche_apotheke*
* *oid_praxis_arzt*
* *oid_praxis-physiotherapeut*
* *oid_zahnarztpraxis*
 |

**Tabelle:**Befugbare Nutzergruppen mit Ausführungsrecht für Verarbeitung von Daten des Medication Service

Der Medication Service MUSS für die Generierung der Medikationsliste im XHTML-Format nach [XHTML] sicherstellen, dass kein ausführbarer Code im Export enthalten ist.

Der Medication Service MUSS jeden HTTP Request von Clients mit professionOID != oid_erp-vau, oid_versicherter mit dem HTTP Status Code 423 (LOCKED) abbrechen, sofern im Consent Decision Management in der Funktionsklasse ("healthCareProcess") mit der Funktion ("medication") die Entscheidung ("deny") gesetzt ist.

Der Medication Service MUSS jeden HTTP Request von Clients mit professionOID == oid_erp-vau mit dem HTTP Status Code 423 (LOCKED) abbrechen, sofern im Consent Decision Management in der Funktionsklasse ("healthCareProcess") mit der Funktion ("erp-submission") die Entscheidung ("deny") gesetzt ist.

Der Medication Service MUSS alle vorhandenen fachlichen Daten des Medication Service löschen, wenn im Consent Decision Management in der Funktionsklasse ("healthCareProcess") mit der Funktion ("erp-submission") die Entscheidung ("deny") gesetzt wird.

Der Medication Service MUSS jeden HTTP Request von Clients mit professionOID gemäß [gemSpec_Aktensystem_ePAfueralle#A_26406] mit dem HTTP Status Code 423 (LOCKED) abbrechen, sofern im Consent Decision Management die LEI der User Session in der User Specific Deny Policy des Medication Service enthalten ist.

Der Medication Service MUSS im Body der HTTP POST-Operation die übertragenen Parameter auf Schadcode prüfen und fachfremde Daten (d.h. Schemavalidierung) prüfen und im Fehlerfall das Ausführen der Operation mit dem HTTP Status Code 400 abbrechen.

Der Medication Service MUSS sicherstellen, dass die folgenden FHIR-Operationen ausschließlich durch den E-Rezept-Fachdienst mit der professionOID oid_erp-vau genutzt werden dürfen:
* providePrescription_MedicationSvc
* cancelPrescription_MedicationSvc
* provideDispensation_MedicationSvc
* cancelDispensation_MedicationSvc

### Protokollierung per Audit Event Service

Die Protokollierung erfolgt über den Audit Event Service. Weitere Anforderungen sind [gemIG_ePA_Basic#Medication] zu entnehmen.

