# Operation API: Medikationsplan abrufen (eMP) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**Operation API**](operation-api.md)
* **Operation API: Medikationsplan abrufen (eMP)**

## Operation API: Medikationsplan abrufen (eMP)

Die Operation *[Medikationsplan abrufen (eMP)](./OperationDefinition-get-medication-plan-op.md)* ermöglicht den gezielten Zugriff auf eine konsolidierte FHIR-Darstellung eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene eMP umfasst eine Sammlung relevanter Ressourceninstanzen (z.B. **MedicationRequest** (eMP), **MedicationStatement** (eML) oder **Medication** (eMP), die zu einem definierten Zeitpunkt gemeinsam gültig waren, ergänzt um die zugehörige **Patient**-Ressource aus dem Patient Service.

Als optionaler Eingabeparameter kann eine **Provenance.id** des Profils **EMPChronologyProvenance** übergeben werden. Diese ID verweist auf einen eMP-Chronologieeintrag des Medikationsplans und referenziert eine spezifische Version des eMP, wie sie durch die **Provenance**-Instanz dokumentiert ist. Bei Angabe dieses Parameters liefert die Operation exakt den durch die angegebene **Provenance** beschriebenen Zustand des Medikationsplans, gegebenenfalls ergänzt durch aktuelle, zugehörige Verschreibungsdaten. Dadurch wird eine Abfrage vergangener Planstände ermöglicht. Wird keine **Provenance.id** übermittelt, gibt die Operation den aktuellen Zustand des eMP zurück – also die zur Abfragezeit gültige Kombination aus aktiven, vorgesehenen und pausierten Medikationsdaten, wie sie systemseitig als letzte Version ermittelt wurde. Das Operationsergebnis ist ein FHIR **Bundle** vom Typ **collection**, das sämtliche zum angegebenen Stand gehörenden Ressourcen enthält.

### Nachricht

Die Nachricht zum Abruf der FHIR-Instanzen des eMP wird als HTTP GET-Anfrage an den Medication Service gesendet.

#### Auslösung

Wenn das ePA-Client-System den eMP als strukturierte FHIR-Daten abrufen möchte, sendet es eine **Operation API: Medikationsplan abrufen (eMP)**-Anfrage an den Medication Service. Der Medication Service verarbeitet die Anfrage und stellt den Medikationsplan zur Verfügung, damit dieser im ePA-Client-System verarbeitet werden kann.

Das ePA-FdV MUSS es dem Versicherten ermöglichen, einen ICD-10-Code eines eMP-Eintrags mit Informationen des Nationalen Gesundheitsportals [NGP] zu verknüpfen, um eine patientenverständliche Erläuterung des Codes zur Anzeige zu bringen, sodass das Feld
*reasonCode*für den Versicherten nachvollziehbar wird.

Das ePA-Client-System MUSS bei der lokalen Darstellung der abgerufenen eMP-Einträge diese nach den Statuswerten aktiv (
*active*) und pausiert (
*on-hold*) gruppieren und den jeweiligen Status für den Benutzer eindeutig sichtbar darstellen.

Das Primärsystem MUSS eine lokale Volltextsuche über die abgerufenen eMP-Einträge implementieren. Weitere Filter- und Suchfunktionen SOLL das Primärsystem ebenso umsetzen.

Das ePA-FdV KANN eine lokale Volltextsuche über die abgerufenen eMP-Einträge implementieren. Weitere Filter- und Suchfunktionen KANN das ePA-FdV ebenso umsetzen.

Das ePA-Client-System MUSS mindestens die nachfolgenden Elemente eines eMP-Eintrags zur Anzeige bringen:

* Präfix Versichertennamens - `Patient.name:Name.prefix`
* Vorname des Versicherten - `Patient.name:Name.given`
* Nachname des Versicherten - `Patient.name:Name.family`
* Geburtsdatum - `Patient.birthDate`
* Versichertennummer - `Patient.identifier:KVNR`
* Verfassungsdatum - `MedicationRequest.authoredOn`
* Wirkstoff - `Medication.ingredient.item[x]:itemCodeableConcept.text`
* Handelsname - `Medication.code.text` in `MedicationRequest.medicationReference`
* Wirkstärke (Numerator, Denominator, Text) - `Medication.ingredient.strength.numerator` in `MedicationRequest.medicationReference`
* Form - `Medication.form.coding`
* Hinweise für Versicherte - `MedicationRequest.extension:patientNote.valueAnnotation.text`
* Grund (ICD-10 Code) - `MedicationRequest.reasonCode.coding:icd-10-gm`
* Grund / Versicherter - `MedicationRequest.extension:reasonPatientInstruction.valueString`
* Anwendungszeitraum Start/Ende - `MedicationRequest.extension:effectiveDosePeriod`
* Dosierangabe - `MedicationRequest.extension:renderedDosageInstruction.valueMarkdown`, sonst falls vorhanden: `MedicationRequest.dosageInstruction.text`
* Tabellendosierung morgens/mittags/abends/Nacht - `MedicationRequest.dosageInstruction.timing.repeat.when`
* Hinweis für Mitbehandelnde - `MedicationRequest.note`

#### FHIR Operation API

Das Primärsystem MUSS die Operation
*Medikationsplan abrufen (eMP)*implementieren, um einer Leistungserbringerinstitution die Anzeige des eMP zu ermöglichen.

Das ePA-FdV KANN die Operation
*Medikationsplan abrufen (eMP)*implementieren, um dem Nutzer die Anzeige des eMP zu ermöglichen.

Der Medication Service MUSS die Operation
*Medikationsplan abrufen (eMP)*gemäß der FHIR OperationDefinition
[Get Medication Plan (eMP)](./OperationDefinition-get-medication-plan-op.md)ausführen.

```

      {"resourceType":"CapabilityStatement","id":"epa-medication-service-server","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/medication/api/v1/fhir"},{"extension":[{"url":"statusCode","valueString":"423"},{"url":"description","valueString":"If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked."},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"locked"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"url":"https://gematik.de/fhir/epa-medication/CapabilityStatement/epa-medication-service-server","version":"1.3.0","name":"EPAMedicationServiceServer","title":"EPA CapabilityStatement für den Medication Service","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"EPA CapabilityStatement für den Medication Service","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Medication","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pharmaceutical-product","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationRequest:medication","MedicationDispense:medication","MedicationStatement:medication"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Medication.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"code","definition":"http://hl7.org/fhir/SearchParameter/clinical-code","type":"token","documentation":"Medication.code"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/Medication-status","type":"token","documentation":"Medication.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"ingredient-code","definition":"http://hl7.org/fhir/SearchParameter/Medication-ingredient-code","type":"token","documentation":"Medication.ingredient.item as CodeableConcept"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"Medication.extension:context"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationRequest","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationRequest:medication","MedicationRequest:requester","MedicationRequest:activity"],"searchRevInclude":["MedicationDispense:prescription","MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationRequest.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"authoredon","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-authoredon","type":"date","documentation":"MedicationRequest.authoredOn"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"intent","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-intent","type":"token","documentation":"MedicationRequest.intent"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationRequest.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"requester","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-requester","type":"reference","documentation":"MedicationRequest.requester"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationRequest.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationRequest.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"activity","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medication-statement-activity-sp","type":"reference","documentation":"MedicationRequest.extension:activity"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective-dose-period","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp","type":"date","documentation":"MedicationRequest.extension:effectiveDosePeriod"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationDispense","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationDispense:medication","MedicationDispense:performer","MedicationDispense:prescription"],"searchRevInclude":["MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationDispense.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"whenhandedover","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-whenhandedover","type":"date","documentation":"MedicationDispense.whenHandedOver"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"prescription","definition":"http://hl7.org/fhir/SearchParameter/medications-prescription","type":"reference","documentation":"MedicationDispense.authorizingPrescription"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"performer","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-performer","type":"reference","documentation":"MedicationDispense.performer.actor"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationDispense.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationDispense.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"MedicationDispense.extension"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationStatement","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationStatement:medication","MedicationStatement:derived-from","MedicationStatement:based-on-emp"],"searchRevInclude":["Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationStatement.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationStatement.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective","definition":"http://hl7.org/fhir/SearchParameter/MedicationStatement-effective","type":"date","documentation":"MedicationStatement.effective"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"derived-from","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp","type":"reference","documentation":"MedicationStatement.derivedFrom as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationStatement.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"based-on-emp","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp","type":"reference","documentation":"MedicationStatement.basedOn mit Extension:is-emp = true"}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be linked to an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"LINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Already linked to another instance"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_ALREADY_LINKED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"link-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be unlinked from an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"UNLINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"unlink-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/unlink-emp-op"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Organization","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-organization"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationDispense:performer","PractitionerRole:organization","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Organization-identifier","type":"token","documentation":"Organization.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Organization-name","type":"string","documentation":"Organization.name | Organization.alias"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Practitioner","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-practitioner"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["PractitionerRole:practitioner","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-identifier","type":"token","documentation":"Practitioner.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-name","type":"string","documentation":"Practitioner.name"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"PractitionerRole","interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["PractitionerRole:practitioner","PractitionerRole:organization"],"searchRevInclude":["MedicationDispense:performer","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier","type":"token","documentation":"PractitionerRole.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"practitioner","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner","type":"reference","documentation":"PractitionerRole.practitioner"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"organization","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-organization","type":"reference","documentation":"PractitionerRole.organization"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Provenance","supportedProfile":["https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["Provenance:agent","Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent","definition":"http://hl7.org/fhir/SearchParameter/Provenance-agent","type":"reference","documentation":"Who participated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent-identifier","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/provenance-agent-identifier-sp","type":"token","documentation":"Provenance.agent.who.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"target","definition":"http://hl7.org/fhir/SearchParameter/Provenance-target","type":"reference","documentation":"Target References - usually version specific"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"recorded","definition":"http://hl7.org/fhir/SearchParameter/Provenance-recorded","type":"date","documentation":"When the activity was recorded / updated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"when","definition":"http://hl7.org/fhir/SearchParameter/Provenance-when","type":"date","documentation":"Provenance.occurred as dateTime"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"is-emp-chronology","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/is-emp-chronology-sp","type":"token","documentation":"Provenance.extension:isEMPChronology"}]}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-list","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"eMP does not exist"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_NO_EXIST"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan-log","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"eMP entry already exists"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_ENTRY_ALREADY_EXISTS"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"update-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/update-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"batch-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"The operation can only be executed within a batch context"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_OPERATION_OUTSIDE_BATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"emp-commit","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op"}]}]}
    
```

```

      {"resourceType":"OperationDefinition","id":"get-medication-plan-op","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"]},"text":{"status":"generated","div":"<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\">Generated Narrative: OperationDefinition get-medication-plan-op</p><a name=\"get-medication-plan-op\"> </a><a name=\"hcget-medication-plan-op\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://gematik.de/fhir/ti/1.2.0/StructureDefinition-ti-operationdefinition.html\">OperationDefinition Profil für TI FHIR Data Service</a></p></div>URL: [base]/$medication-planParameters<table class=\"grid\">UseNameScopeCardinalityTypeBindingDocumentationINprovenance0..1<a href=\"http://hl7.org/fhir/R4/datatypes.html#uuid\">uuid</a>Die UUID der Provenance-Instanz, die eine bestimmte Version des elektronischen Medikationsplans (eMP) identifiziert. Diese Provenance-Instanz repräsentiert den Zustand zu einem bestimmten Zeitpunkt und bündelt die zu diesem Zeitpunkt aktiven eMP-Elemente. Wird kein provenance-Parameter angegeben, liefert die Operation den aktuellsten bekannten Zustand des eMP zurück.\nOUTreturn1..1<a href=\"http://hl7.org/fhir/R4/bundle.html\">Bundle</a>Ein Bundle vom Typ collection, das alle relevanten Ressourceninstanzen enthält, die zum angegebenen eMP-Zustand gehören. Diese Ressourcen stammen aus dem Datenraum des Medication Service und bilden gemeinsam den logischen Medikationsplan zum gewünschten Stand ab.\n</table></div>"},"extension":[{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-method","valueCode":"GET"}],"url":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op","version":"1.3.0","name":"getMedicationPlan_MedicationSvc","title":"Get Medication Plan (eMP)","status":"active","kind":"operation","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"name":"gematik GmbH","telecom":[{"system":"url","value":"https://www.gematik.de"},{"system":"email","value":"patientteam [ at ] gematik.de"}]}],"description":"Diese Operation ermöglicht den gezielten Abruf eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene Medikationsplan besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (Patient) aus dem Patient Service. Die Operation akzeptiert optional eine Provenance-Referenz.id als Eingabeparameter. Wird diese übergeben, liefert die Operation exakt den Zustand des Medikationsplans, wie er durch diese Provenance-Version beschrieben ist. So kann auch ein vergangener Stand des eMP nachvollziehbar wiedergegeben werden. Wird keine Provenance angegeben, gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält.","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"affectsState":false,"code":"medication-plan","system":true,"type":false,"instance":false,"parameter":[{"name":"provenance","use":"in","min":0,"max":"1","documentation":"Die UUID der Provenance-Instanz, die eine bestimmte Version des elektronischen Medikationsplans (eMP) identifiziert. Diese Provenance-Instanz repräsentiert den Zustand zu einem bestimmten Zeitpunkt und bündelt die zu diesem Zeitpunkt aktiven eMP-Elemente. Wird kein provenance-Parameter angegeben, liefert die Operation den aktuellsten bekannten Zustand des eMP zurück.","type":"uuid"},{"name":"return","use":"out","min":1,"max":"1","documentation":"Ein Bundle vom Typ collection, das alle relevanten Ressourceninstanzen enthält, die zum angegebenen eMP-Zustand gehören. Diese Ressourcen stammen aus dem Datenraum des Medication Service und bilden gemeinsam den logischen Medikationsplan zum gewünschten Stand ab.","type":"Bundle"}]}
    
```

**Beispiel für den Abruf der aktuellen Version des eMP**

```
GET [base] /epa/medication/api/v1/fhir/$medication-plan

```

**Beispiel für den Abruf einer äteren Version des eMP**

```
GET [base] /epa/medication/api/v1/fhir/$medication-plan?provenance=F530632C-7CE9-4369-B99B-2DE68B0C9F25

```

**Beispiel für den Abruf eines Medikationsplans in XML**

```
GET [base] /epa/medication/api/v1/fhir/$medication-plan?_format=application/fhir+xml

```

Der Medication Service MUSS in der Operation
*Medikationsplan abrufen (eMP)*das Ergebnis als FHIR
*Bundle*mit dem
*type*"collection" zurückgeben.

Der Medication Service MUSS sicherstellen, dass das Ergebnis der Operation
*Medikationsplan abrufen (eMP)*ausschließlich relevante Instanzen des adressierten eMP-Chronologieeintrags enthält.

Das zurückgegebene FHIR Collection Bundle MUSS folgende Instanzen enthalten:

* Instanz des Profils *EPAPatient* aus dem Patient Service,
* die adressierte Provenance Instanz des Profils *EMPChronologyProvenance*,
* alle Versionen von Instanzen des Profils *EMPMedicationRequest*, die in *Provenance.target* (*EMPChronologyProvenance)* referenziert sind,
* alle Instanzen des Profils *EMPMedication*, die in *MedicationRequest.medicationReference (EMPMedicationRequest)* referenziert sind (eMP-Medikation),
* alle Instanzen des Profils *EPAActivityProvenance*, die in *Provenance.target (EPAActivityProvenance)* auf die relevanten Versionen von *MedicationRequest (EMPMedicationRequest)* verweisen,
* alle Instanzen des ResourceType *Organization*, die in *Provenance.agent.who (EPAActivityProvenance)* referenziert werden,
* falls vorhanden: 
* jeweils die in *MedicationRequest.activity (EMPMedicationRequest)* referenzierte Instanz des Profils *EPAMedicationStatement* (erlaubter Status: *unknown*). Werden mehrere Instanzen des Profils *EPAMedicationStatement* referenziert, wird die gemäß *MedicationStatement.effective* jeweils jüngste Instanz verwendet.
* alle durch die relevanten Instanzen des Profils *EPAMedicationStatement* in *MedicationStatement.derivedFrom* referenzierten Instanzen des Profils *EPAMedicationDispense*,
* alle durch die relevanten Instanzen des Profils *EPAMedicationStatement* in *MedicationStatement.derivedFrom* referenzierten Instanzen des Profils *EPAMedicationRequest*,
* alle durch die relevanten Instanzen des Profils *EPAMedicationRequest* und *EPAMedicationDispense* in *medicationReference* referenzierten Instanzen des Profils *EPAMedication*,
* alle Instanzen des ResourceType *Organization*, die in *MedicationDispense.performer.actor (EPAMedicationDispense)* referenziert werden,
* alle Instanzen des ResourceType *PractitionerRole*, die in *MedicationRequest.requester (EPAMedicationRequest)* referenziert werden, sowie deren in *PractitionerRole.practitioner* referenzierte Instanzen des ResourceType *Practitioner* und in *PractitionerRole.organization* referenzierte Instanzen des ResourceType *Organization*.
 

Der Medication Service MUSS die eMP-Einträge im Suchergebnis der Operation
*Medikationsplan abrufen (eMP)*entsprechend des Elements
*MedicationRequest.extension[effectiveDosePeriod]*oder sofern nicht vorhanden
*MedicationRequest.meta.lastUpdated*der Instanzen des Profils
*EMPMedicationRequest*auflisten (neueste zuerst) und bei gleichem
*MedicationRequest.extension[effectiveDosePeriod]*bzw.
*MedicationRequest.meta.lastUpdated*alphabetisch aufsteigend entsprechend
*Medication.ingredient.item[x]:itemCodeableConcept.text*(Wirkstoff) sortieren.
Falls die relevante *EMPChronologyProvenance* auf keinen eMP-Eintrag (*EMPMedicationRequest*) verweist, wird trotzdem ein FHIR Collection Bundle mit der entsprechenden *EMPChronologyProvenance*-Instanz und falls vorhanden referenzierten *Organization*-Instanz und anderen Instanzen zurück geliefert.

Der Medication Service MUSS die Operation
*Medikationsplan abrufen (eMP)*abbrechen und mit einer
*OperationOutcome*-Ressource und Wert
*MSG_RESOURCE_ID_FAIL*antworten, wenn die durch den Parameter
*Provenance-ID*adressierte
*EMPChronologyProvenance*nicht vorhanden ist.
**Beispielantwort bei nicht existierender Version des eMP**

Der Medication Service MUSS die Operation
*Medikationsplan abrufen (eMP)*abbrechen und mit einer
*OperationOutcome*-Ressource und Wert
*MEDSVC_EMP_NO_EXIST*antworten, wenn bei Abruf des aktuellen eMP keine
*EMPChronologyProvenance*existiert.
**Beispielantwort bei nicht existierendem eMP**

### Sicherheitsanforderungen

Generelle Sicherheitsanforderungen werden [hier](./privacy-security.md) festgehalten.

