# Operation API: Medikationsliste abrufen (eML) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**Operation API**](operation-api.md)
* **Operation API: Medikationsliste abrufen (eML)**

## Operation API: Medikationsliste abrufen (eML)

Die Operation *[Medikationsliste abrufen (eML)](./OperationDefinition-get-medication-list-op.md)* liefert die elektronische Medikationsliste (eML) in Form eines FHIR **searchSet**-Bundle. In der eML werden ausschließlich nicht-stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, Nachträge von Medikationen sowie die zugehörige Versicherteninformation (**Patient**) aus dem Patient Service angezeigt.

Für eine vollständige historische Einsicht, einschließlich stornierter Einträge, können die entsprechenden Query APIs genutzt werden. Zusätzlich ermöglicht die optionale Eingabe eines Datumsbereichs eine verlaufsbasierte Ansicht auf relevante Medikationen.

### Nachricht

Die Nachricht zum Abruf der FHIR-Instanzen der elektronischen Medikationsliste (eML) wird als HTTP GET-Anfrage an den Medication Service gesendet.

#### Auslösung

Wenn das ePA-Client-System die elektronische Medikationsliste (eML) als strukturierte FHIR-Daten abrufen möchte, sendet es eine **Operation API: Medikationsliste abrufen (eML)**-Anfrage an den Medication Service. Der Medication Service verarbeitet die Anfrage und stellt die Medikationsliste zur Verfügung, damit sie im ePA-Client-System angezeigt werden kann.

#### FHIR Operation API

Das Primärsystem MUSS die Operation
*Medikationsliste abrufen (eML)*implementieren, um einer Leistungserbringerinstitution die Anzeige der eML zu ermöglichen.

Das ePA-FdV KANN die Operation
*Medikationsliste abrufen (eML)*implementieren, um dem Nutzer die Anzeige der eML zu ermöglichen.

Der Medication Service MUSS die Operation
*Medikationsliste abrufen (eML)*gemäß der FHIR OperationDefinition
[Get Medication List](./OperationDefinition-get-medication-list-op.md)ausführen.

```

      {"resourceType":"CapabilityStatement","id":"epa-medication-service-server","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/medication/api/v1/fhir"},{"extension":[{"url":"statusCode","valueString":"423"},{"url":"description","valueString":"If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked."},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"locked"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"url":"https://gematik.de/fhir/epa-medication/CapabilityStatement/epa-medication-service-server","version":"1.3.0","name":"EPAMedicationServiceServer","title":"EPA CapabilityStatement für den Medication Service","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"EPA CapabilityStatement für den Medication Service","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Medication","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pharmaceutical-product","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationRequest:medication","MedicationDispense:medication","MedicationStatement:medication"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Medication.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"code","definition":"http://hl7.org/fhir/SearchParameter/clinical-code","type":"token","documentation":"Medication.code"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/Medication-status","type":"token","documentation":"Medication.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"ingredient-code","definition":"http://hl7.org/fhir/SearchParameter/Medication-ingredient-code","type":"token","documentation":"Medication.ingredient.item as CodeableConcept"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"Medication.extension:context"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationRequest","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationRequest:medication","MedicationRequest:requester","MedicationRequest:activity"],"searchRevInclude":["MedicationDispense:prescription","MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationRequest.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"authoredon","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-authoredon","type":"date","documentation":"MedicationRequest.authoredOn"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"intent","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-intent","type":"token","documentation":"MedicationRequest.intent"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationRequest.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"requester","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-requester","type":"reference","documentation":"MedicationRequest.requester"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationRequest.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationRequest.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"activity","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medication-statement-activity-sp","type":"reference","documentation":"MedicationRequest.extension:activity"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective-dose-period","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp","type":"date","documentation":"MedicationRequest.extension:effectiveDosePeriod"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationDispense","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationDispense:medication","MedicationDispense:performer","MedicationDispense:prescription"],"searchRevInclude":["MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationDispense.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"whenhandedover","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-whenhandedover","type":"date","documentation":"MedicationDispense.whenHandedOver"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"prescription","definition":"http://hl7.org/fhir/SearchParameter/medications-prescription","type":"reference","documentation":"MedicationDispense.authorizingPrescription"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"performer","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-performer","type":"reference","documentation":"MedicationDispense.performer.actor"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationDispense.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationDispense.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"MedicationDispense.extension"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationStatement","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationStatement:medication","MedicationStatement:derived-from","MedicationStatement:based-on-emp"],"searchRevInclude":["Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationStatement.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationStatement.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective","definition":"http://hl7.org/fhir/SearchParameter/MedicationStatement-effective","type":"date","documentation":"MedicationStatement.effective"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"derived-from","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp","type":"reference","documentation":"MedicationStatement.derivedFrom as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationStatement.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"based-on-emp","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp","type":"reference","documentation":"MedicationStatement.basedOn mit Extension:is-emp = true"}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be linked to an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"LINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Already linked to another instance"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_ALREADY_LINKED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"link-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be unlinked from an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"UNLINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"unlink-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/unlink-emp-op"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Organization","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-organization"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationDispense:performer","PractitionerRole:organization","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Organization-identifier","type":"token","documentation":"Organization.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Organization-name","type":"string","documentation":"Organization.name | Organization.alias"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Practitioner","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-practitioner"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["PractitionerRole:practitioner","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-identifier","type":"token","documentation":"Practitioner.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-name","type":"string","documentation":"Practitioner.name"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"PractitionerRole","interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["PractitionerRole:practitioner","PractitionerRole:organization"],"searchRevInclude":["MedicationDispense:performer","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier","type":"token","documentation":"PractitionerRole.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"practitioner","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner","type":"reference","documentation":"PractitionerRole.practitioner"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"organization","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-organization","type":"reference","documentation":"PractitionerRole.organization"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Provenance","supportedProfile":["https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["Provenance:agent","Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent","definition":"http://hl7.org/fhir/SearchParameter/Provenance-agent","type":"reference","documentation":"Who participated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent-identifier","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/provenance-agent-identifier-sp","type":"token","documentation":"Provenance.agent.who.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"target","definition":"http://hl7.org/fhir/SearchParameter/Provenance-target","type":"reference","documentation":"Target References - usually version specific"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"recorded","definition":"http://hl7.org/fhir/SearchParameter/Provenance-recorded","type":"date","documentation":"When the activity was recorded / updated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"when","definition":"http://hl7.org/fhir/SearchParameter/Provenance-when","type":"date","documentation":"Provenance.occurred as dateTime"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"is-emp-chronology","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/is-emp-chronology-sp","type":"token","documentation":"Provenance.extension:isEMPChronology"}]}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-list","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"eMP does not exist"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_NO_EXIST"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan-log","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"eMP entry already exists"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_ENTRY_ALREADY_EXISTS"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"update-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/update-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"batch-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"The operation can only be executed within a batch context"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_OPERATION_OUTSIDE_BATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"emp-commit","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op"}]}]}
    
```

```

      {"resourceType":"OperationDefinition","id":"get-medication-list-op","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"]},"text":{"status":"generated","div":"<div xmlns=\"http://www.w3.org/1999/xhtml\"><p class=\"res-header-id\">Generated Narrative: OperationDefinition get-medication-list-op</p><a name=\"get-medication-list-op\"> </a><a name=\"hcget-medication-list-op\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://gematik.de/fhir/ti/1.2.0/StructureDefinition-ti-operationdefinition.html\">OperationDefinition Profil für TI FHIR Data Service</a></p></div>URL: [base]/$medication-listParameters<table class=\"grid\">UseNameScopeCardinalityTypeBindingDocumentationINdate0..2<a href=\"http://hl7.org/fhir/R4/datatypes.html#string\">string</a>(<a href=\"https://hl7.org/fhir/R4/search.html#date\">date</a>)Limit the search to this date. Can specify upper or lower limits and periods by providing an upper and a lower limit.\nIN_count0..1<a href=\"http://hl7.org/fhir/R4/datatypes.html#string\">string</a>(<a href=\"https://hl7.org/fhir/R4/search.html#number\">number</a>)Limit the result bundle to this many entries. To get more entries request the next page.\nIN_offset0..1<a href=\"http://hl7.org/fhir/R4/datatypes.html#string\">string</a>(<a href=\"https://hl7.org/fhir/R4/search.html#number\">number</a>)Defines the offset of the first entry in the collection.\nOUTreturn1..1<a href=\"http://hl7.org/fhir/R4/bundle.html\">Bundle</a>Searchset bundle containing the requested entities.\n</table></div>"},"extension":[{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-method","valueCode":"GET"}],"url":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op","version":"1.3.0","name":"getMedicationList_MedicationSvc","title":"Get Medication List","status":"active","kind":"operation","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"name":"gematik GmbH","telecom":[{"system":"url","value":"https://www.gematik.de"},{"system":"email","value":"patientteam [ at ] gematik.de"}]}],"description":"Die Operation liefert die elektronische Medikationsliste (eML) in Form eines FHIR searchSet-Bundles. In der eML werden ausschließlich nicht stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, nachgetragenen Medikamenten sowie die zugehörige Versicherteninformation aus dem Patient Service angezeigt.","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"affectsState":false,"code":"medication-list","system":true,"type":false,"instance":false,"parameter":[{"name":"date","use":"in","min":0,"max":"2","documentation":"Limit the search to this date. Can specify upper or lower limits and periods by providing an upper and a lower limit.","type":"string","searchType":"date"},{"name":"_count","use":"in","min":0,"max":"1","documentation":"Limit the result bundle to this many entries. To get more entries request the next page.","type":"string","searchType":"number"},{"name":"_offset","use":"in","min":0,"max":"1","documentation":"Defines the offset of the first entry in the collection.","type":"string","searchType":"number"},{"name":"return","use":"out","min":1,"max":"1","documentation":"Searchset bundle containing the requested entities.","type":"Bundle"}]}
    
```

Zusätzlich ermöglicht der Parameter *date* die Eingrenzung eines Datumsbereichs, indem obere und untere Grenzen definiert werden. So können gezielt Medikations-, Verschreibungs- und Dispensierdaten innerhalb eines bestimmten Zeitraums abgerufen werden.

**Beispiel für eine Datumsfilterung**

```
GET [base]/epa/medication/api/v1/fhir/$medication-list?date=le2025-12-24&date=ge2025-01-01

```

**Beispiel für eine Medikationsliste (eML) in XML**

```
GET [base]/epa/medication/api/v1/fhir/$medication-list?_format=application/fhir+xml

```

Der Medication Service MUSS in der Operation
*Medikationsliste abrufen (eML)*das Ergebnis als FHIR
*Bundle*mit dem
*type*
**searchset**zurückgeben.

Der Medication Service MUSS sicherstellen, dass das Suchergebnis der Operation
*Medikationsliste abrufen (eML)*auf
*MedicationStatement*-Instanzen basiert und ausschließlich relevante Instanzen enthält.

Das zurückgegebene FHIR Search Set Bundle enthält:

* Alle relevanten *MedicationStatement*-Instanzen des Profils *EPAMedicationStatement*. Diese sind die zentrale Grundlage der Medikationsliste.
* Alle *Medication*-Instanzen, die in der *medicationReference* des *MedicationStatement* oder in den über *derivedFrom* referenzierten *MedicationRequest*- und *MedicationDispense*-Instanzen verwendet werden.
* Alle *MedicationRequest*-Instanzen, die über *MedicationStatement.derivedFrom* referenziert sind.
* Alle *MedicationDispense*-Instanzen, die über *MedicationStatement.derivedFrom* referenziert sind.
* Alle *PractitionerRole*- und *Organization*-Instanzen, die in *MedicationRequest* oder *MedicationDispense* referenziert werden.
* Alle *Practitioner*- und *Organization*-Instanzen, die von den jeweiligen *PractitionerRole*-Instanzen referenziert werden.
* Alle relevanten *Provenance*-Instanzen des Profils *EPAActivityProvenance*, die als *target* auf die jeweilige Version der *MedicationStatement*-Instanz zeigen.
* Alle *Organization*-Instanzen, die in den *Provenance.agent.who*-Referenzen enthalten sind.

Der Medication Service MUSS sicherstellen, dass alle in den
*Provenance.agent.who*-Angaben referenzierten
*Organization*-Instanzen korrekt im Ergebnis der Operation
*Medikationsliste abrufen (eML)*enthalten sind.

Dabei sind sowohl

* literal Referenzen (d.h. *Provenance.agent.who.reference* mit relativen oder absoluten Referenz-URLs auf eine *Organization*-Ressource) und
* logische Referenzen (d.h. *Provenance.agent.who.identifier* mit einer eindeutigen Identifier-Angabe der *Organization*)
zu berücksichtigen und korrekt aufzulösen.

Der Medication Service MUSS in der Operation
*Medikationsliste abrufen (eML)*sicherstellen, dass
*MedicationStatement*-Instanzen mit dem Status
*entered-in-error*sowie die davon abhängigen Instanzen nicht in das Suchergebnis aufgenommen werden.

Dabei gelten folgende Ausschlusskriterien:

* *MedicationStatement*-Instanzen mit dem Status *entered-in-error* werden ausgeschlossen.
* *MedicationRequest*- und *MedicationDispense*-Instanzen werden ausgeschlossen, wenn sie ausschließlich von ausgeschlossenen *MedicationStatement*-Instanzen über *derivedFrom* referenziert werden.
* *Medication*-Instanzen werden ausgeschlossen, wenn sie ausschließlich von ausgeschlossenen *MedicationStatement*-Instanzen referenziert werden.
* *MedicationDispense*-Instanzen werden ausgeschlossen, wenn ihr Status entweder auf *cancelled* oder *declined* gesetzt ist.
* *Medication*-Instanzen werden ausgeschlossen, wenn sie ausschließlich von stornierten *MedicationRequest*- oder *MedicationDispense*-Instanzen referenziert wird. Falls eine *Medication*-Instanz sowohl von einer stornierten als auch von einer nicht-stornierten Instanz referenziert wird, muss sie im Suchergebnis enthalten bleiben.

Der Medication Service MUSS das Suchergebnis der Operation
*Medikationsliste abrufen (eML)*absteigend (
*desc*) nach dem Datum der Medikationsinformation sortieren. Grundlage der Sortierung ist das Element
*MedicationStatement.effective*, das sowohl das ursprüngliche Verordnungsdatum als auch ein Nachtragsdatum abbilden kann. Bei mehreren
*MedicationStatement*-Instanzen mit demselben
*effective*-Wert ist zusätzlich das Element
*MedicationStatement.meta.lastUpdated*in absteigender Reihenfolge zu berücksichtigen. Bei Nicht-Angabe von
*MedicationStatement.effective*wird nach dem Element
*MedicationStatement.meta.lastUpdated*sortiert.

Der Medication Service MUSS in der Operation
*Medikationsliste abrufen (eML)*die Paginierung unterstützen, um eine Verarbeitung und Navigation großer Datenmengen zu ermöglichen. Die Implementierung der Paginierung erfolgt gemäß den allgemeinen Paginierungsanforderungen des FHIR Data Service.
In der Operation **Medikationsliste abrufen (eML)** können neben den Standardpaginierungsparametern wie *_count* und *_offset* weitere Parameter enthalten sein, die die Paginierung erleichtern. Ein Beispiel hierfür ist der Parameter *stateid*, der den aktuellen Zustand der Ergebnisliste repräsentiert. Dies ermöglicht es dem Medication Service, die Navigation durch die Ergebnisse effizient zu verwalten, indem der Kontext oder Zustand der Suche erhalten bleibt.

Der Medication Service MUSS sicherstellen, dass alle referenzierten Instanzen innerhalb einer einzelnen Ergebnisseite der Paginierung enthalten sind. Eine referenzierte Instanz MUSS in derselben Seite wie die Instanz enthalten sein, die auf sie verweist. Dies gilt für die folgenden Ressourcen:
*MedicationStatement*,
*Medication*,
*MedicationRequest*,
*MedicationDispense*,
*PractitionerRole*,
*Practitioner*,
*Organization*und
*Provenance*.

Der Medication Service MUSS sicherstellen, dass die zugehörige
*Patient*-Instanz aus dem Patient Service in das Suchergebnis der Operation
*Medikationsliste abrufen (eML)*eingebunden wird.

Der Medication Service MUSS sicherstellen, dass die
*Patient*-Instanz innerhalb des Suchergebnisses der Operation
*Medikationsliste abrufen (eML)*immer als erstes Element der ersten Ergebnisseite zurückgegeben wird.

Der Medication Service MUSS bei Angabe eines Datumparameters (
*date*) alle
*MedicationStatement*-Instanzen mit
*effective*im angegebenen Datumsbereich für die Ergebnismenge der Operation berücksichtigen.

Der Medication Service MUSS, wenn kein Datumparameter (
*date*) angegeben ist, alle
*MedicationStatement*-Instanzen für die Ergebnismenge der Operation berücksichtigen.

Der Medication Service MUSS bei Berechnung der Anzahl von Elementen auf einer Suchergebnisseite per
*_count*ausschließlich die
*MedicationStatement*-Instanzen berücksichtigen (d.h. sich nicht auf die Gesamtanzahl der Einträge im FHIR Bundle beziehen). Die
*MedicationStatement*-Instanzen sollen im FHIR Bundle mit
*entry.search.mode = "match"*gekennzeichnet werden. Zugehörig referenzierte Ressourcen (d.h.
*Medication*,
*MedicationRequest*,
*MedicationDispense*,
*Practitioner*,
*PractitionerRole*,
*Organization*,
*Provenance*und
*Patient*) müssen zusätzlich in das FHIR Bundle aufgenommen und mit
*entry.search.mode = "include"*markiert werden.

Der Medication Service MUSS mit dem HTTP Status Code 404 und einer
*OperationOutcome*-Ressource antworten, wenn die Ergebnismenge der Operation
*Medikationsliste abrufen (eML)*leer ist. Die
*OperationOutcome*-Ressource enthält im Element
*issue.details.coding.code*den Wert
*MSG_NO_MATCH*.
Das folgende Beispiel zeigt die erwartete Antwort bei einer leeren eML.

```
{
  "resourceType": "OperationOutcome",
  "issue": [
    {
      "severity": "error",
      "code": "processing",
      "details": {
        "coding": [
          {
            "code": "MSG_NO_MATCH",
            "system": "http://terminology.hl7.org/CodeSystem/operation-outcome"
          }
        ]
        "diagnostics": "No Resource found matching the query"
      }
    }
  ]
}

```

### Sicherheitsanforderungen

Generelle Sicherheitsanforderungen werden [hier](./privacy-security.md) festgehalten.

