# Migrationsvorgaben - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Migrationsvorgaben**

## Migrationsvorgaben

An dieser Stelle finden sich Vorgaben zur Datenmigration zwischen verschiedenen Versionen dieses Implemenation Guide, die durch den Medication Service durchgeführt werden müssen. Eine Migration besteht pro Version ggf. aus mehreren Migrationsschritten. Es kann Versionen dieses Guide geben, für die keine Migrationsschritte festgelegt wurden.

Der Medication Service MUSS gemäß [gemIG_ePA_Basic#IG-EPA50964Z2A] alle Migrationen in aufsteigender Versionsabfolge des Medication Service durchführen, angefangen bei der kleinsten Version, für die noch keine Migration durchgeführt wurde.

Der Medication Service MUSS alle nicht durchgeführten Migrationen zum frühestmöglichen Zeitpunkt durchführen.
Das ist der Moment, in dem das erste mal nach Aktivsetzen einer neuen Version mit Migrationsvorgaben das Aktenkonto geöffnet wird.

### Migration von 1.1.x auf Version 1.3.0

In der Version 1.3.0 erfolgt die Einführung des elektronischen Medikationsplans. In diesem Zusammenhang wird beim Einstellen einer **MedicationRequest**-Instanz des Profils **EPAMedicationRequest** ab Version 1.3.0 vom Medication Service automatisch eine **MedicationStatement**-Instanz (**EPAMedicationStatement**) erzeugt und mit dem eingegangen **MedicationRequest** verbunden. Da alte **EPAMedicationRequest**-Instanzen (vor Version 1.3.0) noch nicht über dieses zusätzliche **MedicationStatement** verfügen, wird es der Konsistenz halber im Rahmen dieser Migration auch für Altdaten angelegt.

Der Medication Service MUSS bei der Migration auf die Version 1.3.0 die folgenden Schritte ausführen (oder gleichwertige Schritte, die zum selben Ergebnis führen):
1. Für jede bestehende*MedicationRequest*-Instanz des Profils*EPAMedicationRequest*mit Status*active*oder*completed*:
Für alle im Rahmen der Migration erzeugten
*MedicationStatement*- und
*Provenance*-Ressourceninstanzen ist die
*meta.versionId*auf
*1*zu setzen und
*meta.lastUpdated*auf den Zeitpunkt der Durchführung der Migration zu setzen. Die
*Provenance*-Instanz hat dabei konkret über eine versionierte Referenz auf die neu erstellte
*MedicationStatement*-Instanz zu verweisen.

Der Medication Service MUSS einmalig bei seiner Ausführung in allen
*Practitioner*-Instanzen, die von
*MedicationRequest*-Instanzen mit
*MedicationRequest.intent*ungleich
*plan*referenziert werden, den Wert des Elements
*Practitioner.qualification*entfernen.

Für die Korrektur der Berufsbezeichnungen in den betroffenen
*Practitioner*-Instanzen ist ausschließlich der Wert des Elements
*Practitioner.qualification*anzupassen, ohne eine neue Ressourcenversion zu erzeugen. Die bestehenden
*meta.versionId*und
*meta.lastUpdated*Werte der
*Practitioner*-Instanzen dürfen im Rahmen dieser Migration nicht verändert werden.
Dies korrigiert eine in der Vergangenheit fehlerhafte Befüllung durch den E-Rezept-Fachdienst. Es werden nur diejenigen *Practitioner*-Instanzen korrigiert, die nicht über eine *MedicationRequest*-Instanz mit **eMP-relevant** referenziert sind.

Der Medication Service MUSS einmalig bei seiner Ausführung in allen
*Medication*-Instanzen sicherstellen, dass bei Nichtbelegung von
*Medication.code.coding:atc-de.version*der Wert "2025" nachgetragen wird.

Bei der Nachtragung des Werts "2025" ist ausschließlich das Element selbst zu ergänzen, ohne eine neue Ressourceninstanzversion anzulegen. Die bestehenden Werte von
*meta.versionId*und
*meta.lastUpdated*der betroffenen
*Medication*-Instanzen dürfen im Rahmen dieser Migration nicht verändert werden.
Die o.g. Nachtragung der Version mit dem Wert “2025” ist bei der amtlichen ATC-Klassifikation möglich, da die Business-Version 2025 erstmalig in der ePA 3.0 verwendet wurde.

