# Home - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/ImplementationGuide/de.gematik.epa.medication | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:gemIG_ePA_Medication |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Die **ePA für alle** stärkt den **digital gestützten Medikationsprozess (dgMP)** in dem sie an den Versorgungsschnittstellen Medikationsinformationen für Medikationsanalyse und -management bereitstellt. Dies wird vornehmlich durch

* die automatische Befüllung der **elektronischen Medikationsliste (eML)** mit verordneten und abgegebenen Arzneimitteln,
* die Möglichkeit der Dokumentation von geplanten Arzneimittelanwendungen inkl. Dosierinformation,
* die Bereitstellung einer Übersicht über aktuelle und zukünftig einzunehmende Arzneimittel auf dem **elektronischen Medikationsplan (eMP)**,
* die Bearbeitung von Statuswerten zu geplanten Arzneimittelanwendungen auf dem eMP sowie
* das Ändern von Dosierangaben zu eMP-Medikationen

erreicht. Der **ePA Medication Service** (kurz Medication Service) des dgMP unterstützt diese Funktionalitäten über eine HL7 FHIR-basierte Verarbeitung.

### Organisation dieses Implementation Guide

Dieser Implementation Guide sollte “von links nach rechts” gelesen werden. Ausgehend von der Fachlichkeit wird anschließend die dazugehörige FHIR-Modellierung über technische Anwendungsfälle beschrieben, die schließlich in FHIR-Ressourcen und -APIs aufgehen:

* Fachlichkeit: Technische Umsetzung
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Die technische Umsetzung der Prozessunterstützung wird anhand[technischer Anwendungsfälle](./technical-use-cases.md)erläutert. Diese sind:* Verordnung, Verschreibung und Dispensierung (inkl. Arzneimittelsubstitution bei Abgabe) mit dem eMP
* Nachtrag in der eML
* Nachtrag im eMP
* Aktualisierung eines eMP-Eintrags
* Hinzufügen und Entfernen einer eML-eMP-Verknüpfung
* Lesezugriffe für eML und eMP
Diesen Beschreibungen schließen sich[Verarbeitungsregeln](./processing-rules.md)zum FHIR-basierten Auslesen und der folgenden Anzeige in Benutzungsoberflächen für die eML als auch den eMP an. Zuletzt wird die[Datenmigration](./migration.md)beschrieben, die beim Aktualisieren des Medication Service auf eine neue Version durchgeführt werden müssen.
* Fachlichkeit: Schnittstellen
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Die Schnittstellen des Medication Service setzen sich aus[Query API](./query-api.md),[Operation API](./operation-api.md)sowie[Render API](./render-api.md)zusammen. Allgemeingültige und ePA-spezifische[Anforderungen](./general-principles.md)an FHIR Data Services als auch[Datenschutz- und Datensicherheitsaspekte](./privacy-security.md)werden in diesem Abschnitt dargelegt.
* Fachlichkeit: FHIR-Artefakte
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Hier findet sich eine tabellarische Übersicht aller in diesem Implementation Guide verwendeten[FHIR-Artefakte](./artifacts.md)zu Schnittstellen und Inhaltsdaten für Abruf und Verwaltung von Medikationsdaten.
* Fachlichkeit: Anhänge
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Diesem Implementation Guide werden[Download-Artefakte](./downloads.md)(u.a. Paketdatei, Beispiele, Schematron-Dateien, dieser Guide im ZIP-Format),[OpenAPI-Spezifikationen](./medication-openapi.md),[Release Notes](./release-notes.md)sowie[Steckbriefe](./spec-sheet.md)angehängt.

**Tabelle:**Organisation dieses Implementation Guide

### Vorgehensweise bei FHIR-Profil-Spezifikation

Der Medication Service ist Teil des FHIR-basierten Datenraums des ePA-Aktensystems. Grundsätzlich sollen die FHIR-Profile größtmöglich wiederverwendet und damit so wenig wie möglich eingeschränkt werden. Anforderungen an eine FHIR-basierte Verarbeitung werden auf unterschiedlichen Ebenen festgehalten:

* auf Ebene der Telematikinfrastruktur (TI),
* auf Ebene des Datenraums des ePA-Aktensystems sowie
* auf Ebene des spezifischen Dienstes zur Unterstütztung einer Funktionalität oder eines Versorgungsprozesses.

Hierfür wurden die dedizierten FHIR Implemenation Guides (IGs) **TI Common**, **ePA Basic** sowie in diesem Fall **Medication Service** geschrieben. Die ersten beiden FHIR IGs ermöglichen die Nachnutzung wiederkehrerender Anforderungen auf Ebene anderer, zukünftiger Produkttypen der TI und anderen FHIR Data Services des ePA-Aktensystems, um letztlich ein gleichartiges Verhalten gegenüber Client-Implementierungen, wie Primärsystemen, zu gewährleisten. Übergreifende Terminologien werden separat als FHIR Package Dependency verwaltet.

Die Auswahl geeigneter FHIR-Ressourcen für die Verarbeitung strukturierter Daten und die inhaltlichen Festlegungen der Profile orientieren sich vornehmlich an den Deutschen Basisprofilen von HL7 Deutschland e.V. sowie dem HL7 FHIR-Standard selbst. Aber auch die enge Kombatibilität zum E-Rezept als auch die teilweise inhaltlich verwandten FHIR-Profile von ISiK (Abk. für **Informationstechnische Systeme in Krankenhäusern**) waren ausschlaggebend für die Profilierung dieser FHIR-Ressourcen. Die Gewährleistung einer clientseitigen Weiterverarbeitung (auch Ableitung) ist ebenso Bestreben bei der FHIR-Profilierung. In der Regel wurden daher Kardinalitäten nicht eingeschränkt, das **Must Support**-Konzept wo notwendig platziert. Begründungen für die Auswahl und inhaltliche Belegung von FHIR-Elementen erfolgen prosaisch nur in Ausnahmefällen. Hier sei auf die inhaltlichen Beschreibungen und Definition des FHIR-Standards verwiesen. Sämtliche FHIR-Elemente wurden in englischer Sprache, Erklärungen und Kommentare innerhalb eines Profils in deutscher Sprache definiert.

Zu den Prinzipien der integren Datenverarbeitung im Medication Service gehört u.a. die vollständige Kontrolle über die gespeicherten FHIR-Daten. Das bedeutet, dass jedwede übergebene FHIR-Instanz von außen niemals direkt gespeichert wird, sondern lediglich als Data Transfer Object (DTO) dient. Nach entsprechenden Prüfungen in den Geschäftslogiken (Validierung, Einhaltung von Regeln etc.) werden jeweils ausschließlich mit **Must Support** gekennzeichnete Elemente in eine neu erzeugte oder zu aktualisierende FHIR-Instanz übernommen. Auch Referenzen werden intern erzeugt. Somit obliegt diesem FHIR Data Service auch die Vergabe von **Resource.id** und Versionsnummer innerhalb einer Transaktion. Die Nachweisbarkeit von Änderungen in Schreibvorgängen wird über intern erzeugte **Provenance**-Instanzen sichergestellt. Sämtliche Zugriffsaktiviäten werden darüber hinaus über **AuditEvent**-Instanzen festgehalten, welche dem oder der Versicherten über das ePA-FdV oder über die Ombudsstelle seiner/ihrer Krankenkasse zu Verfügung gestellt werden.

Bestandteil jeder FHIR Data-Service-Spezifikation des ePA-Aktensystems ist das **Capability Statement**. FHIR-Ressourcentypen und -profile, Interaktionen (CRUD), Suchparameter und Operations werden darüber definiert und können programmatisch weiterverarbeitet werden. Zu den FHIR IGs der ePA gehören zudem beigestellte **OpenAPI**-Spezifikationen, welche allerdings im Vergleich zu den besagten Statements aufgrund der nicht deckungsgleichen Repräsentation aller FHIR-Konzepte (u.a. Constraints) nicht verbindlich im Sinne einer Zulassung der gematik sind. Ferner stellt ein FHIR IG der ePA Beispiele zum Download zur Verfügung.

### Abhängigkeiten








### Sprachliche Konventionen

* Zur besseren Lesbarkeit wird in diesem Implementation Guide das generische Maskulinum verwendet. Die hier verwendeten Personenbezeichnungen beziehen sich stets auf alle Geschlechter.
* Der Begriff “Arzt” wird in diesem Implementation Guide sowohl für Human- als auch für Zahnmediziner verwendet.

### Weitere Hinweise

* Bitte die [Ausführungen des Medication IG DE bezüglich des defekten Constraints tim-9](https://build.fhir.org/ig/hl7germany/medication-ig-de-r4/branches/main/StructureDefinition-TimingDgMP.html#hinweise-zur-verwendung) beachten!

### Kontakt

Allgemeine Fragen und Kommentare zum Implementation Guide können Sie über das [Anfragenportal] der gematik einreichen. Falls kein Zugang besteht, senden Sie bitte eine E-Mail an “patientteam [ at ] gematik [ dot ] de” mit dem Betreff “Anfragenportal Zugang”.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "de.gematik.epa.medication",
  "url" : "https://gematik.de/fhir/epa-medication/ImplementationGuide/de.gematik.epa.medication",
  "version" : "1.3.0",
  "name" : "gemIG_ePA_Medication",
  "title" : "Implementation Guide ePA Medication Service",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "packageId" : "de.gematik.epa.medication",
  "license" : "Apache-2.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "de_basisprofil_r4",
      "uri" : "http://fhir.org/packages/de.basisprofil.r4/ImplementationGuide/de.basisprofil.r4",
      "packageId" : "de.basisprofil.r4",
      "version" : "1.5.4"
    },
    {
      "id" : "de_fhir_medication",
      "uri" : "http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication",
      "packageId" : "de.fhir.medication",
      "version" : "1.0.3"
    },
    {
      "id" : "de_gematik_terminology",
      "uri" : "https://gematik.de/fhir/terminology/ImplementationGuide/de.gematik.terminology",
      "packageId" : "de.gematik.terminology",
      "version" : "1.0.8"
    },
    {
      "id" : "de_gematik_ti",
      "uri" : "https://gematik.de/fhir/ti/ImplementationGuide/de.gematik.ti",
      "packageId" : "de.gematik.ti",
      "version" : "1.2.0"
    },
    {
      "id" : "de_gematik_epa",
      "uri" : "https://gematik.de/fhir/epa/ImplementationGuide/de.gematik.epa",
      "packageId" : "de.gematik.epa",
      "version" : "1.3.0"
    },
    {
      "id" : "de_gematik_fhir_directory",
      "uri" : "http://fhir.org/packages/de.gematik.fhir.directory/ImplementationGuide/de.gematik.fhir.directory",
      "packageId" : "de.gematik.fhir.directory",
      "version" : "1.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-usage-check"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.6-2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.2.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "bundle-references-resolve"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "OperationOutcome/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Medication/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "MedicationRequest/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "MedicationDispense/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "CapabilityStatement/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-epa-batch-emp-request-bundle"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-epa-batch-emp-response-bundle"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-get-medication-list-bundle1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-get-medication-plan-bundle-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-searchset-medication"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-searchset-medicationrequest"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-add-emp-entry-input-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-emp-entry-output-parameters-2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-link-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-unlink-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-eml-entry-cancelled-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/0b383501-f078-464b-b984-9fdb6751601b"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/2e1ba746-1aef-4eef-b741-2dfc771c7001"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/b467ce05-e0e5-4d71-9a0b-d824dbb492ef"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/39475183-3444-4b63-bfed-ae0741f4496b"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://gematik.de/fhir/epa-medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "release"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-usage-check"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.0.6-2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison"
          },
          {
            "url" : "value",
            "valueString" : "1.2.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "bundle-references-resolve"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "OperationOutcome/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Medication/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "MedicationRequest/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "MedicationDispense/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "CapabilityStatement/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-narrative"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/*"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-epa-batch-emp-request-bundle"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-epa-batch-emp-response-bundle"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-get-medication-list-bundle1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-get-medication-plan-bundle-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-searchset-medication"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Bundle/example-searchset-medicationrequest"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-add-emp-entry-input-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-emp-entry-output-parameters-2"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-link-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-unlink-emp-entry-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Parameters/example-epa-op-eml-entry-cancelled-output-parameters-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/0b383501-f078-464b-b984-9fdb6751601b"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/2e1ba746-1aef-4eef-b741-2dfc771c7001"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/b467ce05-e0e5-4d71-9a0b-d824dbb492ef"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "no-validate"
          },
          {
            "url" : "value",
            "valueString" : "Provenance/39475183-3444-4b63-bfed-ae0741f4496b"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://gematik.de/fhir/epa-medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/1412aa4f-a9ed-45f2-8916-063fee7eb025"
        },
        "name" : "1412aa4f-a9ed-45f2-8916-063fee7eb025",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/312d581c-f5e7-4faa-9de5-c4e1568c6db2"
        },
        "name" : "Aciclovir",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/b2911d1e-fc63-47bb-8887-63b701bc49c4"
        },
        "name" : "Aciclovir_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/cfb84928-15d6-468c-8e17-e77f1ed44904"
        },
        "name" : "Aciclovir_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/f2e5c91f-4aed-484f-b313-7332ac2677c8"
        },
        "name" : "Aciclovir_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/6461edff-13ec-4dc7-b9f3-aea66bcb0643"
        },
        "name" : "Aciclovir_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/add-eml-entry-op"
        },
        "name" : "Add Medication List Entry",
        "description" : "Diese Operation ermöglicht das gezielte Hinzufügen einer neuen Medikation zur elektronischen Medikationsliste (eML).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/8B421590-9F7F-46BE-BD1E-C987063AC4F5"
        },
        "name" : "ApothekeTIOrganization",
        "description" : "Example of an Organization",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/498c345f-31f5-4da6-9f04-00fa2bc8af7c"
        },
        "name" : "Arzt",
        "description" : "Example of a Practitioner as to be found in gematik FHIR Directory",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/73a551f8-d8cd-4b44-823d-ab5f8aeab1aa"
        },
        "name" : "Arzt PractitionerRole",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/based-on-emp-sp"
        },
        "name" : "BasedOnEMPSP",
        "description" : "Liefert alle Referencen, die einen eMP bezug haben",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-batch-emp-request-bundle"
        },
        "name" : "Batch API eMP-Einträge - Request-Bundle",
        "description" : "Request-Bundle für die Batch-Operation zur Verarbeitung von eMP-Einträgen.\nErlaubt sind ausschließlich FHIR-Operationen (POST) für den eMP. $emp-commit MUSS genau einmal\nvorkommen. Es sind keine direkten Ressourcen-CRUDs zulässig.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/batch-emp-entries-op"
        },
        "name" : "Batch eMP Einträge",
        "description" : "Mit der Batch Operation $batch-emp können Primärsysteme mehrere fachliche Änderungen am eMP in einem Aufruf\nan den Medication Service übergeben. Innerhalb des Request-Bundles werden ausschließlich FHIR-Operationen\nausgeführt (keine direkten Resource-CRUDs). Als letzte Operation ein $emp-commit ausgeführt, der eine neue\nPlan-Version (Provenance) erzeugt. Die Operation antwortet mit einem Bundle vom Typ transaction-response.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ad7dc0e7-cb44-4740-ba67-cb573e29d596"
        },
        "name" : "BetriebsstaetteArzt",
        "description" : "Example of an Organization as to be found in gematik FHIR Directory",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/cancel-dispensation-erp-OP"
        },
        "name" : "Cancel Dispensation eRP",
        "description" : "The Cancel Dispensation eRP operation, used by the E-Rezept-Fachdienst, in the context of the ePA Medication Service, is applied to cancel or reverse information regarding the dispensation of a medication. This operation is necessary when a medication dispensation is cancelled by a pharmacist or when there is a return of the medication by the insurant. After the E-Rezept-Fachdienst performs this operation, the corresponding dispensation entry for the medication in the patient's ePA is marked as cancelled, which the goal in ensuring an accurate and up-to-date record of the patient's medication data.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/cancel-eml-entry-op"
        },
        "name" : "Cancel Medication List Entry",
        "description" : "Diese Operation dient dem gezielten Widerruf/Abbruch eines bestehenden Eintrags der elektronischen Medikationsliste (eML) auf Instanzebene.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/cancel-prescription-erp-OP"
        },
        "name" : "Cancel Prescription eRP",
        "description" : "The Cancel Prescription eRP operation is used by the E-Rezept-Fachdienst to cancel an already issued electronic prescription. This function is applied when a prescription is no longer needed for various reasons, such as changes in medication or errors in the initial issuance. After cancellation by the E-Rezept-Fachdienst, this information is transmitted to the ePA Medication Service, where the prescription is calculations. It can then no longer be used for dispensing medication. This process ensures accuracy and safety in the management of medications.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/39475183-3444-4b63-bfed-ae0741f4496b"
        },
        "name" : "Cancelled_Diclo_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/context-code"
        },
        "name" : "Context Codes",
        "description" : "Codes that define the context of a resource instance in the ePA context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/context-code"
        },
        "name" : "Context Codes",
        "description" : "Codes that define the context of a resource instance in the ePA context",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/context-extension"
        },
        "name" : "ContextExtension",
        "description" : "Extension for indicating the context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/context-sp"
        },
        "name" : "ContextSP",
        "description" : "Liefert alle Resourcen mit diesem Context Code",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/CortisonDexpantenol"
        },
        "name" : "Cortison Dexpantenol Medication",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/1254591a-dd2d-4d17-b8f8-ee3155da0699"
        },
        "name" : "COTRIM",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/6250569a-3505-4db7-aebc-45dba1f98acc"
        },
        "name" : "COTRIM_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/b5ad3b05-1174-415f-8f43-555160862b25"
        },
        "name" : "COTRIM_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/ab495b80-c9d2-4ed6-a076-b44b8dfae75a"
        },
        "name" : "COTRIM_LINKING_NOT_SUCCESSFUL_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/f14498f0-4932-490a-91a2-9de8616e133b"
        },
        "name" : "COTRIM_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/derived-from-sp"
        },
        "name" : "DerivedFromSP",
        "description" : "Search by resources from which the medication statement is derived",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/2571d29b-e213-40ec-b817-a1490718f491"
        },
        "name" : "Diclo",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/71601cdb-8a53-4f26-b5d5-e5457b498e76"
        },
        "name" : "Diclo_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/a36b3ae8-1c1d-4dbb-b209-ee2ee9fc31e6"
        },
        "name" : "Diclo_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/19549515-60a8-4e1c-b86a-49518053fe9f"
        },
        "name" : "Doxycyclin",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/c3a353f0-c61a-4d6b-affa-daf8c0f6e77c"
        },
        "name" : "Doxycyclin_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/405ff43e-bc8e-4109-b370-3e31431c5fe0"
        },
        "name" : "Doxycyclin_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/cf988182-fd13-4f1f-a35c-d045c57c28d0"
        },
        "name" : "Doxycyclin_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/08cb8487-2758-406c-999a-e23a05e63c0b"
        },
        "name" : "Doxycyclin_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/drug-category-extension"
        },
        "name" : "DrugCategoryExtension",
        "description" : "Extension for indicating the medication category.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/emp-chronology-provenance"
        },
        "name" : "eMP Chronology Provenance",
        "description" : "Dieses Profil beschreibt die Verwendung der FHIR-Resource Provenance zur Abbildung eines eMP-Chronologieeintrags. Die Provenance-Instanz dokumentiert, welche eMP-Einträge (MedicationRequest-Instanzen) zu einem bestimmten Zeitpunkt als Teil des elektronischen Medikationsplans (eMP) gültig waren. Ein eMP-Chronologieeintrag wird immer dann erzeugt, wenn sich die eMP-relevanten Instanzen geändert haben oder neue eMP-Einträge hinzugekommen sind. Er referenziert sämtliche zum Erstellungszeitpunkt aktiven eMP-MedicationRequest-Instanzen, d.h. alle Ressourcen mit dem Status active oder on-hold. Dadurch wird der Zustand des Medikationsplans zu diesem Zeitpunkt nachvollziehbar. Der eMP-Chronologieeintrag ermöglicht somit eine eindeutige und versionssichere Rückverfolgung der Zusammensetzung des eMP über verschiedene Zeitpunkte hinweg.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/emp-commit-op"
        },
        "name" : "eMP Commit Operation",
        "description" : "Die eMP Commit Operation dient zum Abschluss einer Batch-Verarbeitung von eMP-Einträgen.  \nSie erzeugt eine neue Version des elektronischen Medikationsplans (eMP), indem eine aktualisierte  \nInstanz von EMPChronologyProvenance erstellt wird, die auf alle relevanten EMPMedicationRequest  \nverweist. Diese Operation wird in der Regel nur einmal am Ende eines Batch-Kontextes aufgerufen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/emp-medication"
        },
        "name" : "eMP Medication",
        "description" : "Defines the medication resource for the Medication Service in the ePA system in the eMP context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/emp-medication-request"
        },
        "name" : "eMP MedicationRequest",
        "description" : "eMP-Eintrag: Hält die Medikationsinformationen eines Eintrags für den elektronischen MedikationsPlan (eMP) vor und stellt das zentrale Element dar. Es stellt die Verbindung zwischen der Planung und einem oder mehrerer Verschreibungsprozesse oder Nachträge.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/emp-medicationrequest-status-vs"
        },
        "name" : "eMP MedicationRequest Status Value Set",
        "description" : "eMP MedicationRequest Status Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/update-emp-entry-op"
        },
        "name" : "eMP-Eintrag aktualisieren",
        "description" : "Diese Operation dient der gezielten Aktualisierung eines bestehenden Medikations-Eintrags im elektronischen Medikationsplan (eMP).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/add-emp-entry-op"
        },
        "name" : "eMP-Eintrag hinzufügen",
        "description" : "Diese Operation ermöglicht das Hinzufügen eines neuen Medikations-Eintrags zum elektronischen Medikationsplan (eMP). Der Eintrag wird als EMPMedicationRequest erzeugt, wobei die angegebene Medication sowohl in medicationReference als auch in extension[originMedication] referenziert wird.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/link-emp-op"
        },
        "name" : "eMP-Eintrag verknüpfen",
        "description" : "Diese Instanz-Operation dient der Verknüpfung eines bestehenden eML-Eintrags (MedicationStatement) mit einem bereits dokumentierten Eintrag im elektronischen Medikationsplan (eMP).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/unlink-emp-op"
        },
        "name" : "eMP-Verknüpfung entfernen",
        "description" : "Diese Operation des Medication Service dient dazu, eine Verknüpfung zwischen einem bestehenden eML-Eintrag und einem dokumentierten eMP-Eintrag aufzuheben.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/emp-medicationrequest-activity-extension"
        },
        "name" : "EMPMedicationRequestActitvityExtension",
        "description" : "Bildet eine Aktivität in bezug auf ein EMPMedicationRequest ab",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f"
        },
        "name" : "eMP_Benazepril",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/8faa45dd-b2dc-4a80-8956-94aeab1db04b"
        },
        "name" : "eMP_Benazepril_Activity_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/0b383501-f078-464b-b984-9fdb6751601b"
        },
        "name" : "eMP_Benazepril_Chronology_Provenance_1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/b467ce05-e0e5-4d71-9a0b-d824dbb492ef"
        },
        "name" : "eMP_Benazepril_Chronology_Provenance_2",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb"
        },
        "name" : "eMP_Benazepril_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/2e1ba746-1aef-4eef-b741-2dfc771c7001"
        },
        "name" : "eMP_Chronology_Provenance",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/319fcc6e-049d-4eb1-9a5c-82c33438cf94"
        },
        "name" : "eMP_Chronology_Provenance_Batch",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/87f08ba2-da7e-467e-86aa-404d9035297c"
        },
        "name" : "eMP_Sumatriptan",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/20335453-d103-4957-a370-03c9007db2f6"
        },
        "name" : "eMP_Sumatriptan_Activity_Provenance_Batch_Response",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5"
        },
        "name" : "eMP_Sumatriptan_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/9090b28c-e165-4823-b82b-15bb63012123"
        },
        "name" : "eMP_Sumatripta_Activity_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/2e112cb5-3b9f-4434-848e-26e27756cd30"
        },
        "name" : "eMP_Sumatripta_Chronology_Provenance",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/epa-medication-service-client"
        },
        "name" : "EPA Capability Statement für Clients des ePA Medication Service",
        "description" : "Dieses Capability Statement legt die Anforderungen an ePA Clients fest, die den Medication Service der verwenden. Es definiert die unterstützten Interaktionen, erforderliche HTTP Header sowie erwartete Status Codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/epa-medication-service-server"
        },
        "name" : "EPA CapabilityStatement für den Medication Service",
        "description" : "EPA CapabilityStatement für den Medication Service",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-rmp-commit-input-parameters"
        },
        "name" : "EPA eMP Commit Operation Input-Parameters",
        "description" : "EPA eMP Commit Operation Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication"
        },
        "name" : "EPA Medication",
        "description" : "Defines the medication resource for the Medication Service in the ePA system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-pzn-ingredient"
        },
        "name" : "EPA Medication PZN Ingredient",
        "description" : "Defines the medication resource for a PZN ingredient of a compounding medication for the Medication Service in the ePA system. These profiles are intended to inherit from EPAMedication, but due to tooling issues, this inheritance cannot currently be implemented.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-ms-operation-outcome"
        },
        "name" : "EPA Medication Service Operation Outcome",
        "description" : "Das Operation Outcome-Profil für den Medication Service der ePA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/epa-ms-operation-outcome-details"
        },
        "name" : "EPA Medication Service Operation Outcome ValueSet",
        "description" : "Enthält alle Codes für das Operation Outcome des Medication Service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/epa-ms-operation-outcome-details"
        },
        "name" : "EPA Medication Service OperationOutcome Code System",
        "description" : "EPA Medication Service Operation Outcome Code System",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-dispense"
        },
        "name" : "EPA MedicationDispense",
        "description" : "Defines the medication dispense resource for the Medication Service in the ePA system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-request"
        },
        "name" : "EPA MedicationRequest",
        "description" : "Defines the medication request resource for the Medication Service in the ePA system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-statement"
        },
        "name" : "EPA MedicationStatement",
        "description" : "Hält die Medikationsinformationen eines Eintrags in der elektronischen Medikationsliste (eML) vor und stellt das zentrale Element dar. Es wird zu Verschreibungs- und Dispensierinformationen als auch Nachträgen in der eML genutzt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/epa-medicationstatement-context-code"
        },
        "name" : "ePA MedicationStatement Context Codes",
        "description" : "Codes that define the context of an EPAMedicationStatement",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/epa-medicationstatement-processing-event-code"
        },
        "name" : "EPA MedicationStatement Processing Codes",
        "description" : "Codes that define events that occur during processing of an EMPMedicationStatement",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/epa-medicationstatement-processing-event-code"
        },
        "name" : "EPA MedicationStatement Processing Codes",
        "description" : "Codes that define events that occur during processing of an EMPMedicationStatement",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/epa-medication-statement-status-vs"
        },
        "name" : "ePA MedicationStatement Status Value Set",
        "description" : "ePA MedicationStatement Status Value Set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-add-eml-entry-input-parameters"
        },
        "name" : "EPA Operation addEMLEntry Input-Parameters",
        "description" : "EPA Operation addEMLEntry Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-add-emp-entry-input-parameters"
        },
        "name" : "EPA Operation addEMPEntry Input-Parameters",
        "description" : "EPA Operation addEMPEntry Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-cancel-dispensation-erp-input-parameters"
        },
        "name" : "EPA Operation CancelDispensation ERP Input-Parameters",
        "description" : "EPA Operation CancelDispensation ERP Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-cancel-prescription-erp-input-parameters"
        },
        "name" : "EPA Operation CancelPrescription ERP Input-Parameters",
        "description" : "EPA Operation CancelPrescription ERP Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-eml-entry-output-parameters"
        },
        "name" : "EPA Operation EMLEntry Output-Parameters",
        "description" : "EPA Operation EMLEntry Output-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-emp-entry-output-parameters"
        },
        "name" : "EPA Operation EMPEntry Output-Parameters",
        "description" : "EPA Operation EMPEntry Output-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-link-emp-entry-output-parameters"
        },
        "name" : "EPA Operation Link eMP Output Parameters",
        "description" : "EPA Operation Link eMP Output Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-link-emp-entry-parameters"
        },
        "name" : "EPA Operation Link eMP Parameters",
        "description" : "EPA Operation Link eMP Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-provide-dispensation-erp-input-parameters"
        },
        "name" : "EPA Operation ProvideDispensation ERP Input-Parameters",
        "description" : "EPA Operation ProvideDispensation ERP Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-provide-prescription-erp-input-parameters"
        },
        "name" : "EPA Operation ProvidePrescription ERP Input-Parameters",
        "description" : "EPA Operation ProvidePrescription ERP Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-rx-dispensation-erp-output-parameters"
        },
        "name" : "EPA Operation RxDispensation ERP Output-Parameters",
        "description" : "EPA Operation RxDispensation ERP Output-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-rx-prescription-erp-output-parameters"
        },
        "name" : "EPA Operation RxPrescription ERP Output-Parameters",
        "description" : "EPA Operation RxPrescription ERP Output-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-op-update-emp-entry-input-parameters"
        },
        "name" : "EPA Operation UpdateEMPEntry Input-Parameters",
        "description" : "EPA Operation UpdateEMPEntry Input-Parameters",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-pharmaceutical-product"
        },
        "name" : "EPA Pharmaceutical Product Medication",
        "description" : "Defines the medication resource for a component of a 'Kombipackung' for the Medication Service in the ePA system. These profiles are intended to inherit from EPAMedication, but due to tooling issues, this inheritance cannot currently be implemented.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/epa-provide-dispensation-status-vs"
        },
        "name" : "EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst)",
        "description" : "Dieses ValueSet definiert die möglichen ePA Statuswerte für die FHIR-Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst). Es bestimmt, ob eine vorläufige oder abgeschlossene Dispensierung vorliegt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medicationstatement-processing-event-extension"
        },
        "name" : "EPAMedicationStatementProcessingEventExtension",
        "description" : "Bildet ein Ereignis ab, das wärend der Verarbeitung auftritt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-epa-batch-emp-request-bundle"
        },
        "name" : "ExampleEPABatchEmpRequestBundle",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-batch-emp-request-bundle"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-epa-batch-emp-response-bundle"
        },
        "name" : "ExampleEPABatchEmpResponseBundle",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-get-medication-list-bundle1"
        },
        "name" : "ExampleEpaGetMedicationListBundle",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-get-medication-plan-bundle-1"
        },
        "name" : "ExampleEpaGetMedicationPlanBundle",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-cancel-dispensation-erp-input-parameters-1"
        },
        "name" : "ExampleEpaOpCancelDispensationERPInputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-cancel-dispensation-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-cancel-prescription-erp-input-parameters-1"
        },
        "name" : "ExampleEpaOpCancelPrescriptionERPInputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-cancel-prescription-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-provide-dispensation-erp-input-parameters-1"
        },
        "name" : "ExampleEpaOpProvideDispensationERPInputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-provide-dispensation-erp-input-parameters-2"
        },
        "name" : "ExampleEpaOpProvideDispensationERPInputParameters2",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-provide-dispensation-erp-input-parameters-3"
        },
        "name" : "ExampleEpaOpProvideDispensationERPInputParametersInProgress",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-dispensation-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-provide-prescription-erp-input-parameters-1"
        },
        "name" : "ExampleEpaOpProvidePrescriptionERPInputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-prescription-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-provide-prescription-erp-input-parameters-2"
        },
        "name" : "ExampleEpaOpProvidePrescriptionERPInputParameters2",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-provide-prescription-erp-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-rx-dispensation-erp-output-parameters-1"
        },
        "name" : "ExampleEpaOpRxDispensationOutputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-dispensation-erp-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-rx-prescription-erp-output-parameters-1"
        },
        "name" : "ExampleEpaOpRxPrescriptionERPOutputParameters1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rx-prescription-erp-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-searchset-medication"
        },
        "name" : "ExampleSearchsetBundleEPAMedication",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-searchset-medicationdispense"
        },
        "name" : "ExampleSearchsetBundleEPAMedicationDispense",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-searchset-medicationrequest"
        },
        "name" : "ExampleSearchsetBundleEPAMedicationRequest",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/example-searchset-medicationstatement"
        },
        "name" : "ExampleSearchsetBundleEPAMedicationStatement",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-add-eml-entry-input-parameters-1"
        },
        "name" : "ExpEPAOpAddEmlEntryInputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-eml-entry-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-add-emp-entry-input-parameters-1"
        },
        "name" : "ExpEPAOpAddEMPEntryInputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-add-emp-entry-with-reference-input-parameters-1"
        },
        "name" : "ExpEPAOpAddEMPEntryWithReferenceInputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-eml-entry-cancelled-output-parameters-1"
        },
        "name" : "ExpEPAOpEmlEntryCancelledOutputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-eml-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-eml-entry-output-parameters-1"
        },
        "name" : "ExpEPAOpEmlEntryOutputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-eml-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-rmp-commit-input-parameters-1"
        },
        "name" : "ExpEPAOpEMPCommitInputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rmp-commit-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-emp-entry-output-parameters-1"
        },
        "name" : "ExpEPAOpEMPEntryOutputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-emp-entry-output-parameters-2"
        },
        "name" : "ExpEPAOpEMPEntryOutputParametersUpdate",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-emp-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/a1dc2bb2-1776-4ccd-929f-355472077cf6"
        },
        "name" : "ExpEPAOperationOutcomeOrgHeaderToLarge",
        "description" : "Requesting Organization Header exceeds maximum size",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-link-emp-entry-output-parameters-1"
        },
        "name" : "ExpEPAOpLinkEMPEntryOutputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-link-emp-entry-parameters-1"
        },
        "name" : "ExpEPAOpLinkEMPEntryParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-unlink-emp-entry-output-parameters-1"
        },
        "name" : "ExpEPAOpUnlinkEMPEntryOutputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-output-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-unlink-emp-entry-parameters-1"
        },
        "name" : "ExpEPAOpUnlinkEMPEntryParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/example-epa-op-update-emp-entry-input-parameters-1"
        },
        "name" : "ExpEPAOpUpdateEMPEntryInputParameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-update-emp-entry-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/7ccb2670-7178-4f82-912a-de70f68ecd51"
        },
        "name" : "ExpEPAOpUpdateEMPEntryInputParameters_Batch",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-update-emp-entry-input-parameters"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/12f5513f-3eef-41ad-baca-826627c890f2"
        },
        "name" : "ExpOperationOutcomeAlreadyLinked",
        "description" : "Already linked to another instance",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/0b967346-00bf-412c-8e05-077ed13e873e"
        },
        "name" : "ExpOperationOutcomeDeleted",
        "description" : "This resource has been deleted",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5"
        },
        "name" : "ExpOperationOutcomeDosageInvalid",
        "description" : "Invalid dosage structure or content",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/ee1e0518-02f2-4d3a-99ae-bae8e91c382d"
        },
        "name" : "ExpOperationOutcomeDuplicatePrescriptionDetected",
        "description" : "Duplicate Prescription Detected in Medication Service",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/1e5838dd-ec29-4f68-9739-dfa717db515d"
        },
        "name" : "ExpOperationOutcomeEMPAlreadyExists",
        "description" : "eMP entry already exists",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/0b476e35-02d5-4fb0-ad60-79f5eb05e2b4"
        },
        "name" : "ExpOperationOutcomeEMPChronologyIdMismatch",
        "description" : "Mismatch between acknowledged and current eMP chronology ID",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/24b64018-89f4-4a52-8e9c-c0af279c4e86"
        },
        "name" : "ExpOperationOutcomeEMPLinkingNotSuccessful",
        "description" : "eMP linking not successful",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/c146f801-8f50-4ca4-8578-514d5938e3c3"
        },
        "name" : "ExpOperationOutcomeEMPUnlinkingNotSuccessful",
        "description" : "eMP linking not successful",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/bef62761-7eea-4daa-a992-36c532232679"
        },
        "name" : "ExpOperationOutcomeNotPermittedCurrentPrescriptionStatus",
        "description" : "Operation Not Permitted on Current Prescription Status",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/a94b020a-2f34-4013-83ea-cf1bd0a92cdd"
        },
        "name" : "ExpOperationOutcomeNotPermittedonCurrentDispensationStatus",
        "description" : "Operation Not Permitted on Current Dispensation Status",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/2b34898e-a9d1-4fa6-9959-5ff6033cfcb0"
        },
        "name" : "ExpOperationOutcomeNoValidStructure",
        "description" : "Invalid Data Structure in Medication Service",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8"
        },
        "name" : "ExpOperationOutcomeNoValidStructureWithDiagnostics",
        "description" : "Invalid Data Structure in Medication Service",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/c03670fe-eaf2-4a38-a333-4dc1470072a2"
        },
        "name" : "ExpOperationOutcomeOperationDispensationNotFound",
        "description" : "Dispensation Not Found in Medication Service",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/912a5e81-6274-439e-9d79-5172c4855a70"
        },
        "name" : "ExpOperationOutcomeOperationOutsideBatch",
        "description" : "eMP linking not successful",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/e69228bf-6f07-4055-8190-e832d2c670dc"
        },
        "name" : "ExpOperationOutcomeOpNotAllowed",
        "description" : "Operation $update-eml-entry not allowed for resource MedicationStatement",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/41d25882-4a02-47e3-a367-f5b5fe8c8015"
        },
        "name" : "ExpOperationOutcomeOrgHeaderProfileMismatch",
        "description" : "Profile mismatch in header Organization",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/fc3e8ea4-41ec-4de2-906e-97871b34adcb"
        },
        "name" : "ExpOperationOutcomePrescriptionNotFound",
        "description" : "Prescription Not Found in Medication Service",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/255002c7-aa1b-4163-bdd4-ede482453cca"
        },
        "name" : "ExpOperationOutcomeSuccess",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/e730e451-3a44-4842-a8ed-1517a3334465"
        },
        "name" : "ExpOperationOutcomeUnresolvedReferenceinParameters",
        "description" : "Unresolved Reference in Parameters",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/e4f1ed42-7741-40f5-a84e-fd688ac74d3e"
        },
        "name" : "ExpOperationOutcomeVersionAwareConflict",
        "description" : "Update Conflict",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/151f1697-7512-4e21-9466-1b75207475d8"
        },
        "name" : "GematikApotheke",
        "description" : "Example of an Organization as to be found in gematik FHIR Directory",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/be51e0d2-783d-4e21-b16b-1a4cd7403515"
        },
        "name" : "GematikOrganization",
        "description" : "Example of an Organization as to be found in gematik FHIR Directory",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/get-medication-list-op"
        },
        "name" : "Get Medication List",
        "description" : "Die Operation liefert die elektronische Medikationsliste (eML) in Form eines FHIR searchSet-Bundles. In der eML werden ausschließlich nicht stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, nachgetragenen Medikamenten sowie die zugehörige Versicherteninformation aus dem Patient Service angezeigt.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/get-medication-plan-op"
        },
        "name" : "Get Medication Plan (eMP)",
        "description" : "Diese Operation ermöglicht den gezielten Abruf eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene Medikationsplan besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (Patient) aus dem Patient Service. Die Operation akzeptiert optional eine Provenance-Referenz.id als Eingabeparameter. Wird diese übergeben, liefert die Operation exakt den Zustand des Medikationsplans, wie er durch diese Provenance-Version beschrieben ist. So kann auch ein vergangener Stand des eMP nachvollziehbar wiedergegeben werden. Wird keine Provenance angegeben, gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/ef5d5baf-0c42-4240-9604-7fba9cea926d"
        },
        "name" : "IBU",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/1cb0f018-178d-4488-a6b4-2be32dbda784"
        },
        "name" : "IBU_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/f35a13e2-d82c-4826-97d7-b7e32721c4af"
        },
        "name" : "IBU_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/indicator-bvg-extension"
        },
        "name" : "IndicatorBVGExtension",
        "description" : "Indicator of whether this regulation is made in reference to the 'Bundesentschädigungsgesetz' or the 'Bundesversorgungsgesetz'.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/indicator-ser-extension"
        },
        "name" : "IndicatorSERExtension",
        "description" : "Kennzeichnung, ob diese Verordnung mit Bezug zum Sozialen Entschädigungsrecht nach SGB XIV (SER) erfolgt",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/is-emp-chronology-extension"
        },
        "name" : "IsEMPChronologyExtension",
        "description" : "Definiert, ob die Provenance ein eMP-Chronologieeintrag ist.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/is-emp-chronology-sp"
        },
        "name" : "IsEMPChronologySP",
        "description" : "Liefert alle Resourcen die eMP bezug haben (oder nicht)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/is-emp-extension"
        },
        "name" : "IsEMPExtension",
        "description" : "Definiert ob etwas einen Bezug zum eMP hat",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd"
        },
        "name" : "JanuviaFilmtabletten",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43"
        },
        "name" : "JanuviaFilmtabletten_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7"
        },
        "name" : "JanuviaFilmtabletten_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/de42aa65-f84e-4e96-acfb-b9fd5e104b2d"
        },
        "name" : "JanuviaFilmtabletten_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72"
        },
        "name" : "JanuviaFilmtabletten_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/f7240e05-01a1-4ce6-a8bb-edb71b6b5104"
        },
        "name" : "L-Thyroxin_Dispense_MV_1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/133c8159-6398-4937-984a-d741e24556ad"
        },
        "name" : "L-Thyroxin_Information_MV_1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/850ef590-34ff-469a-8c0d-13b6751a029b"
        },
        "name" : "L-Thyroxin_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/deecd514-235d-41df-a664-e3672208f410"
        },
        "name" : "L-Thyroxin_MV_1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3"
        },
        "name" : "L-Thyroxin_MV_2",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/83d7ad1c-47d1-4524-829a-5b86ce333bbc"
        },
        "name" : "L-Thyroxin_MV_3",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/659c0be1-2ec8-4137-9698-dcffee811934"
        },
        "name" : "L-Thyroxin_MV_4",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e"
        },
        "name" : "L-Thyroxin_Request_MV_1",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/2a794a78-8a72-46ca-bb81-09f702f94e11"
        },
        "name" : "L-Thyroxin_Request_MV_2",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/0435e19e-ed9a-4b5b-a9e9-70924c5922a0"
        },
        "name" : "L-Thyroxin_Request_MV_3",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/3ffb5c34-81e7-45ec-842c-82a2422cb8c8"
        },
        "name" : "L-Thyroxin_Request_MV_4",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/medication-plan-log-op"
        },
        "name" : "Medication Plan Chronology Log",
        "description" : "Diese Operation liefert die chronologische Historie aller gespeicherten Versionen des elektronischen Medikationsplans (eMP) in Form von Provenance-Ressourcen. Jede Provenance-Instanz beschreibt dabei einen dokumentierten Zustand des eMP zu einem bestimmten Zeitpunkt. Die Operation ermöglicht es, gezielt die Versionshistorie des Medikationsplans abzufragen - etwa um Änderungen nachzuvollziehen oder frühere Zustände einzusehen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-type-extension"
        },
        "name" : "Medication Type",
        "description" : "Extension for EPAMedication types",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/epa-medication-unique-identifier"
        },
        "name" : "Medication Unique Identifier",
        "description" : "This unique identifier is generated within the Medication Service. It is either a hash derived from a specific set of data elements of the Medication resource or a direct repetition of a single data element. This identifier ensures the distinct identification of Medication resources across the ePA system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-formulation-packaging-extension"
        },
        "name" : "MedicationFormulationPackagingExtension",
        "description" : "Information on the packaging of a formulation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-ingredient-amount-extension"
        },
        "name" : "MedicationIngredientAmountExtensions",
        "description" : "Free-text amount of the ingredient for classical Latin notations such as \"ad 100.0\" or \"quantum satis,\" including the unit.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-ingredient-darreichungsform-extension"
        },
        "name" : "MedicationIngredientDarreichungsformExtension",
        "description" : "Dosage form of an ingredient in a formulation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-id-vaccine-extension"
        },
        "name" : "MedicationIsVaccineExtension",
        "description" : "Indicator of whether this is a vaccine.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-manufacturing-instructions-extension"
        },
        "name" : "MedicationManufacturingInstructionsExtension",
        "description" : "Manufacturing instructions regarding the preparation of a formulation (Subscriptio).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-packaging-size-extension"
        },
        "name" : "MedicationPackagingSizeExtension",
        "description" : "Specification of the package size according to divided quantity (e.g., 100, 2x25), only appears in conjunction with \"unit\" (e.g., 100 Stück).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/medication-plan-chronology-log-bundle"
        },
        "name" : "MedicationPlanChronologyLogBundle",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/medication-statement-activity-sp"
        },
        "name" : "MedicationRequestActivitySP",
        "description" : "Liefert alle referenzierten eML MedicationStatement Aktivitäten",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/medicationrequest-effective-dose-period-sp"
        },
        "name" : "MedicationRequestEffectiveDosePeriodSP",
        "description" : "Ermöglicht die Suche  anhand des Zeitraums, in dem die Medikation eingenommen werden soll",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-total-quantity-formulation-extension"
        },
        "name" : "MedicationTotalQuantityFormulationExtension",
        "description" : "Total quantity of the formulation (without the unit).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/multiple-prescription-extension"
        },
        "name" : "MultiplePrescription",
        "description" : "This FHIR Extension for multiple prescriptions adds details such as repetition count and time intervals for repeated medication orders to FHIR resources.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/narcotics-extension"
        },
        "name" : "NarcoticsExtension",
        "description" : "Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/98ca7dff-aa8d-47d0-a074-4055f55cb4dc"
        },
        "name" : "OperationOutcomeEMPNoExist",
        "description" : "eMP does not exist",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/a4da96e5-84d6-4883-8789-5df2e1363c40"
        },
        "name" : "OperationOutcomeEmptyList",
        "description" : "Empty list",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/446e77ff-9fcb-4232-8de3-74986f78d85f"
        },
        "name" : "OperationOutcomeInvalidQueryParameter",
        "description" : "Invalid query parameter",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/52c59e99-eba0-4488-b829-39983b9169f5"
        },
        "name" : "OperationOutcomeInvalidRequest",
        "description" : "InvalidRequest",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/98ca7dff-aa8d-47d0-a074-4055f55cb4db"
        },
        "name" : "OperationOutcomeResourceIsNotKnown",
        "description" : "Resource is not known",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/b29880f0-6c99-4fe2-aae2-007e8cb4d9cf"
        },
        "name" : "OperationOutcomeUnknownResourceType",
        "description" : "Unknown resource type",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationOutcome"
          }
        ],
        "reference" : {
          "reference" : "OperationOutcome/dc558008-4fbd-4e51-a16a-0cbc382a529f"
        },
        "name" : "OperationOutcomeUnknownSearchParameter",
        "description" : "Unknown search parameter",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-ms-operation-outcome"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/emp-origin-medication-extension"
        },
        "name" : "Origin Medication Reference (eMP)",
        "description" : "Erlaubt einem eMP MedicationRequest, auf die ursprünglich verwendete Medication-Instanz zu referenzieren (Ursprung des eMP-Eintrags).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-id-extension"
        },
        "name" : "PatientIDExtension",
        "description" : "Patienten-ID, welche bei der Verordnung bestimmter Arzneimittel angegeben werden kann.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-note-extension"
        },
        "name" : "PatientNoteExtension",
        "description" : "Extension für einen Hinweis für den Patienten",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/b9eb9668-b61e-43b5-b3ea-485234836d59"
        },
        "name" : "PraxisTI PractitionerRole",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/450a9511-53e5-4af7-be36-a18444bb8dd2"
        },
        "name" : "PraxisTIOrganization",
        "description" : "Example of a family doctor's office",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/prescriber-id-extension"
        },
        "name" : "PrescriberIDExtension",
        "description" : "Verschreiber-ID, welche bei der Verordnung bestimmter Präparate anzugeben ist, damit die Apotheke das Rezept beliefern darf.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e"
        },
        "name" : "Prospan",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/3c10c1ad-1d7a-47e8-abab-00b8299b49b8"
        },
        "name" : "Prospan_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/1b88713c-64cc-40ad-9665-70ca5f7dfb08"
        },
        "name" : "Prospan_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/168ec791-45ca-434c-8ba8-cbc855a3ca90"
        },
        "name" : "Prospan_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/40df19aa-40e2-4ebc-a11d-9d232dcb0f67"
        },
        "name" : "Prospan_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/provenance-agent-identifier-sp"
        },
        "name" : "ProvenanceAgentIdentifierSP",
        "description" : "Suche anhand der logischen Referenz (identifier) im Element Provenance.agent.who",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/provide-dispensation-erp-OP"
        },
        "name" : "Provide Dispensation eRP",
        "description" : "The Provide Dispensation eRP operation in the ePA Medication Service is used to record information about the dispensing of medications based on an electronic prescription in the patient's record. This operation comes into play when a patient receives their medication from a pharmacy. It documents that the medication has been dispensed as per the prescription, including details like the quantity, date of dispensing, and pharmacy information. This helps maintain a comprehensive overview of the patient's medication history.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "OperationDefinition"
          }
        ],
        "reference" : {
          "reference" : "OperationDefinition/provide-prescription-erp-OP"
        },
        "name" : "Provide Prescription eRP",
        "description" : "The Provide Prescription eRP operation in the ePA MedicationService is used to add electronic prescriptions to a patient's record. These prescriptions are already made by the E-Rezept-Fachdienst. This operation does not create new patient prescriptions; it just puts the ones made by the E-Rezept-Fachdienst into the patient's ePA, making sure they are stored safely and can be easily accessed.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b"
        },
        "name" : "Ramipril",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad"
        },
        "name" : "Ramipril_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/0fc1f006-5793-4501-81b6-fe3918fcfa2d"
        },
        "name" : "Ramipril_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/a99c2849-de82-4a43-98f4-8d6a4caa6038"
        },
        "name" : "Ramipril_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/0e7f16e4-d879-4a2c-8292-41c55201bbdd"
        },
        "name" : "Ramipril_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/reason-patient-instruction-extension"
        },
        "name" : "ReasonPatientInstructionExtension",
        "description" : "Patientenverständliche Beschreibung des Grundes",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/rx-originator-process-identifier"
        },
        "name" : "RxOriginatorProcessIdentifier",
        "description" : "The RxOriginatorProcessIdentifier, generated within the Medication Service, links the prescriptionID from the E-Rezept-Fachdienst with the original input FHIR resource ID, facilitating accurate tracking and utilization of medication data in operational processes within digital healthcare systems.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/rx-prescription-process-identifier"
        },
        "name" : "RxPrescriptionProcessIdentifier",
        "description" : "This transaction identifier is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. It is generated by the ePA Medication Service, ensuring a consistent and unique identification of each transaction. The identifier is composed of the PrescriptionId and the authoredOn-date of the operations parameters request, providing a robust mechanism for referencing and managing medication-related resources across systems.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/rx-prescription-process-identifier-extension"
        },
        "name" : "RxPrescriptionProcessIdentifierExtension",
        "description" : "This extension is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. The RxPrescriptionProcessIdentifier is generated by the ePA Medication Service and consists of the PrescriptionId and the authoredOn date of the operation parameters request. It ensures consistent referencing and management of medication-related resources across different systems.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/rx-prescription-process-sp"
        },
        "name" : "RxPrescriptionProcessSP",
        "description" : "Returns Medications, MedicationDispenses or MedicationStatement with the Rx Prescription Process Identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e"
        },
        "name" : "Sumatriptan",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c"
        },
        "name" : "Sumatriptan_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c"
        },
        "name" : "Sumatriptan_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/176eec9c-8d5a-46a7-96e3-7af3f68c49ed"
        },
        "name" : "Sumatriptan_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8"
        },
        "name" : "Sumatriptan_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/Technical-Exp-EPAMedicationMax"
        },
        "name" : "Technical-Exp-EPAMedicationMax",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Technical-Exp-NachtragEmlLEI"
        },
        "name" : "Technical-Exp-NachtragEmlLEI",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/Technical-Exp-NachtragEmlMedication"
        },
        "name" : "Technical-Exp-NachtragEmlMedication",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/4B5557E5-4900-47FE-A8D9-407611E05BD2"
        },
        "name" : "Technical-Exp-NachtragEmlMedicationIBU",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/Technical-Exp-NachtragEmlMedicationStatement"
        },
        "name" : "Technical-Exp-NachtragEmlMedicationStatement",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Technical-Exp-NachtragEmlPatient"
        },
        "name" : "Technical-Exp-NachtragEmlPatient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/Technical-Exp-NachtragEmlProvenance"
        },
        "name" : "Technical-Exp-NachtragEmlProvenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/Technical-Exp-NachtragEmpLEI"
        },
        "name" : "Technical-Exp-NachtragEmpLEI",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/Technical-Exp-NachtragEmpMedicationEml"
        },
        "name" : "Technical-Exp-NachtragEmpMedicationEml",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/Technical-Exp-NachtragEmpMedicationEmp"
        },
        "name" : "Technical-Exp-NachtragEmpMedicationEmp",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Technical-Exp-NachtragEmpMedicationRequestEmp"
        },
        "name" : "Technical-Exp-NachtragEmpMedicationRequestEmp",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/Technical-Exp-NachtragEmpMedicationStatementEml"
        },
        "name" : "Technical-Exp-NachtragEmpMedicationStatementEml",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Technical-Exp-NachtragEmpPatient"
        },
        "name" : "Technical-Exp-NachtragEmpPatient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/Technical-Exp-NachtragEmpProvenanceEml"
        },
        "name" : "Technical-Exp-NachtragEmpProvenanceEml",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/Technical-Exp-NachtragEmpProvenanceEmp"
        },
        "name" : "Technical-Exp-NachtragEmpProvenanceEmp",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/teratogenic-extension"
        },
        "name" : "TeratogenicExtension",
        "description" : "Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd"
        },
        "name" : "Teratogenic_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031"
        },
        "name" : "Venlafaxin",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/c0b553bd-2542-49d7-b5e1-0a770185e39f"
        },
        "name" : "Venlafaxin_Dispense",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/b87b0908-7765-4ec0-8662-7d3daff08f6e"
        },
        "name" : "Venlafaxin_Information",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/1a93c378-435e-437e-8c7c-6e84b788a3eb"
        },
        "name" : "Venlafaxin_Information_Provenance",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/7efae80a-a4d9-4e26-a1b9-92c72e79cfaa"
        },
        "name" : "Venlafaxin_Request",
        "exampleCanonical" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dgmp-overview.html"
            }
          ],
          "nameUrl" : "dgmp-overview.html",
          "title" : "Überblick zum digital gestützten Medikationsprozess",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dgmp-scenarios.html"
            }
          ],
          "nameUrl" : "dgmp-scenarios.html",
          "title" : "dgMP-Szenarien",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dgmp-use-cases.html"
            }
          ],
          "nameUrl" : "dgmp-use-cases.html",
          "title" : "dgMP-Anwendungsfälle",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "technical-use-cases.html"
            }
          ],
          "nameUrl" : "technical-use-cases.html",
          "title" : "Technische Anwendungsfälle",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "processing-rules.html"
            }
          ],
          "nameUrl" : "processing-rules.html",
          "title" : "Verarbeitungsregeln",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "migration.html"
            }
          ],
          "nameUrl" : "migration.html",
          "title" : "Migrationsvorgaben",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosage-examples.html"
            }
          ],
          "nameUrl" : "dosage-examples.html",
          "title" : "Darstellung von Dosierungsinformationen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "general-principles.html"
            }
          ],
          "nameUrl" : "general-principles.html",
          "title" : "Generelle Prinzipien",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "privacy-security.html"
            }
          ],
          "nameUrl" : "privacy-security.html",
          "title" : "Datenschutz und Sicherheit",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "query-api.html"
            }
          ],
          "nameUrl" : "query-api.html",
          "title" : "Query API",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-medication.html"
                }
              ],
              "nameUrl" : "query-api-medication.html",
              "title" : "Query API: Medication (Medikation, eMP-Medikation)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-medicationdispense.html"
                }
              ],
              "nameUrl" : "query-api-medicationdispense.html",
              "title" : "Query API: MedicationDispense (Abgabe)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-medicationrequest.html"
                }
              ],
              "nameUrl" : "query-api-medicationrequest.html",
              "title" : "Query API: MedicationRequest (Verschreibung, eMP-Eintrag)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-medicationstatement.html"
                }
              ],
              "nameUrl" : "query-api-medicationstatement.html",
              "title" : "Query API: MedicationStatement (Medikationsinformation)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-organization.html"
                }
              ],
              "nameUrl" : "query-api-organization.html",
              "title" : "Query API: Organization (Leistungserbringerinstitution)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-practitioner.html"
                }
              ],
              "nameUrl" : "query-api-practitioner.html",
              "title" : "Query API: Practitioner (Leistungserbringer)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-practitioner-role.html"
                }
              ],
              "nameUrl" : "query-api-practitioner-role.html",
              "title" : "Query API: PractitionerRole",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "query-api-provenance.html"
                }
              ],
              "nameUrl" : "query-api-provenance.html",
              "title" : "Query API: Provenance (Änderungseintrag, eMP-Chronologieeintrag)",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "operation-api.html"
            }
          ],
          "nameUrl" : "operation-api.html",
          "title" : "Operation API",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-provide-prescription-erp.html"
                }
              ],
              "nameUrl" : "op-provide-prescription-erp.html",
              "title" : "Operation API: Verschreibungsdaten einstellen",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-cancel-prescription-erp.html"
                }
              ],
              "nameUrl" : "op-cancel-prescription-erp.html",
              "title" : "Operation API: Verschreibungsdaten stornieren",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-provide-dispensation-erp.html"
                }
              ],
              "nameUrl" : "op-provide-dispensation-erp.html",
              "title" : "Operation API: Dispensierinformationen einstellen",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-cancel-dispensation-erp.html"
                }
              ],
              "nameUrl" : "op-cancel-dispensation-erp.html",
              "title" : "Operation API: Dispensierung stornieren",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-get-medication-list.html"
                }
              ],
              "nameUrl" : "op-get-medication-list.html",
              "title" : "Operation API: Medikationsliste abrufen (eML)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-add-eml-entry.html"
                }
              ],
              "nameUrl" : "op-add-eml-entry.html",
              "title" : "Operation API: eML-Eintrag hinzufügen",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-cancel-eml-entry.html"
                }
              ],
              "nameUrl" : "op-cancel-eml-entry.html",
              "title" : "Operation API: eML-Eintrag stornieren",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-get-medication-plan.html"
                }
              ],
              "nameUrl" : "op-get-medication-plan.html",
              "title" : "Operation API: Medikationsplan abrufen (eMP)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-medication-plan-log.html"
                }
              ],
              "nameUrl" : "op-medication-plan-log.html",
              "title" : "Operation API: eMP Chronologie abrufen",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-add-emp-entry.html"
                }
              ],
              "nameUrl" : "op-add-emp-entry.html",
              "title" : "Operation API: eMP-Eintrag hinzufügen",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-update-emp-entry.html"
                }
              ],
              "nameUrl" : "op-update-emp-entry.html",
              "title" : "Operation API: eMP-Eintrag aktualisieren",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-link-emp.html"
                }
              ],
              "nameUrl" : "op-link-emp.html",
              "title" : "Operation API: Hinzufügen einer eML-eMP-Verknüpfung",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-unlink-emp.html"
                }
              ],
              "nameUrl" : "op-unlink-emp.html",
              "title" : "Operation API: Entfernen einer eML-eMP-Verknüpfung",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-emp-commit.html"
                }
              ],
              "nameUrl" : "op-emp-commit.html",
              "title" : "Operation API: eMP commit",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "op-batch-emp.html"
                }
              ],
              "nameUrl" : "op-batch-emp.html",
              "title" : "Operation API: Batch eMP-Einträge",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "render-api.html"
            }
          ],
          "nameUrl" : "render-api.html",
          "title" : "Render API",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "render-api-eml.html"
                }
              ],
              "nameUrl" : "render-api-eml.html",
              "title" : "Render API: Medikationsliste abrufen (eML)",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "render-api-emp.html"
                }
              ],
              "nameUrl" : "render-api-emp.html",
              "title" : "Render API: Medikationsplan abrufen (eMP)",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "FHIR-Artefakte",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "referenced.html"
            }
          ],
          "nameUrl" : "referenced.html",
          "title" : "Referenzen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "medication-openapi.html"
            }
          ],
          "nameUrl" : "medication-openapi.html",
          "title" : "OpenAPI: Medication Service",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "release-notes.html"
            }
          ],
          "nameUrl" : "release-notes.html",
          "title" : "Release Notes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "spec-sheet.html"
            }
          ],
          "nameUrl" : "spec-sheet.html",
          "title" : "Steckbriefe",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actor-medication.html"
                }
              ],
              "nameUrl" : "actor-medication.html",
              "title" : "Steckbrief: ePA Medication Service",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actor-client.html"
                }
              ],
              "nameUrl" : "actor-client.html",
              "title" : "Steckbrief: ePA PS / ePA-Client-Systeme / ePA-FdV",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actor-erp-fd.html"
                }
              ],
              "nameUrl" : "actor-erp-fd.html",
              "title" : "Steckbrief: E-Rezept-Fachdienst",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actor-erp-ps.html"
                }
              ],
              "nameUrl" : "actor-erp-ps.html",
              "title" : "Steckbrief: E-Rezept PS",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "comparisons.html"
            }
          ],
          "nameUrl" : "comparisons.html",
          "title" : "Versionsvergleiche",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "license.html"
            }
          ],
          "nameUrl" : "license.html",
          "title" : "Apache License",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-resource",
        "value" : "extracted/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "input/content"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
