# FHIR-Artefakte - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **FHIR-Artefakte**

## FHIR-Artefakte

Diese Seite enthält eine Übersicht aller FHIR-Artefakte, die im Rahmen dieses Implementation Guide für den Medication Service definiert werden. Sie bilden die Grundlage für die strukturierte Abbildung und Verarbeitung von Medikationsdaten innerhalb des Medication Service. Dazu gehören Profile zur Spezifizierung von Ressourcen, ein **Capability Statement** zur Beschreibung der unterstützten Funktionen sowie **Operation Definitions**, die spezielle FHIR-Operationen für den Abruf und die Verwaltung von Medikationsdaten festlegen.

### Terminologien: Value Sets

Die folgenden Value Sets sind für die FHIR-Data-Service-Funktionalitäten festgelegt.

| | |
| :--- | :--- |
| [Context Codes](ValueSet-context-code.md) | Codes that define the context of a resource instance in the ePA context |
| [eMP MedicationRequest Status Value Set](ValueSet-emp-medicationrequest-status-vs.md) | eMP MedicationRequest Status Value Set |
| [ePA MedicationStatement Status Value Set](ValueSet-epa-medication-statement-status-vs.md) | ePA MedicationStatement Status Value Set |
| [EPA MedicationStatement Processing Codes](ValueSet-epa-medicationstatement-processing-event-code.md) | Codes that define events that occur during processing of an EMPMedicationStatement |
| [EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst)](ValueSet-epa-provide-dispensation-status-vs.md) | Dieses ValueSet definiert die möglichen ePA Statuswerte für die FHIR-Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst). Es bestimmt, ob eine vorläufige oder abgeschlossene Dispensierung vorliegt. |

**Tabelle:**Value Sets

### Terminologien: Code Systems

| | |
| :--- | :--- |
| [Context Codes](CodeSystem-context-code.md) | Codes that define the context of a resource instance in the ePA context |
| [EPA MedicationStatement Processing Codes](CodeSystem-epa-medicationstatement-processing-event-code.md) | Codes that define events that occur during processing of an EMPMedicationStatement |

**Tabelle:**Code Systems

### Systemverhalten

#### Capability Statements

Das **Capability** **Statement** beschreibt die Anforderungen und Fähigkeiten, die ein Server für die konforme Implementierung des Medication Service umsetzen muss. Es handelt sich um eine Konformitätserklärung, die spezifiziert, welche Ressourcen, Interaktionen und Suchparameter das ePA-Aktensystem für den Medication Service unterstützen muss.

| | |
| :--- | :--- |
| [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) | Dieses Capability Statement legt die Anforderungen an ePA Clients fest, die den Medication Service der verwenden. Es definiert die unterstützten Interaktionen, erforderliche HTTP Header sowie erwartete Status Codes. |
| [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md) | EPA CapabilityStatement für den Medication Service |

**Tabelle:**Capability Statements

#### Operation Definitions

| | |
| :--- | :--- |
| [Add Medication List Entry](OperationDefinition-add-eml-entry-op.md) | Diese Operation ermöglicht das gezielte Hinzufügen einer neuen Medikation zur elektronischen Medikationsliste (eML). |
| [eMP-Eintrag hinzufügen](OperationDefinition-add-emp-entry-op.md) | Diese Operation ermöglicht das Hinzufügen eines neuen Medikations-Eintrags zum elektronischen Medikationsplan (eMP). Der Eintrag wird als EMPMedicationRequest erzeugt, wobei die angegebene Medication sowohl in medicationReference als auch in extension[originMedication] referenziert wird. |
| [Batch eMP Einträge](OperationDefinition-batch-emp-entries-op.md) | Mit der Batch Operation $batch-emp können Primärsysteme mehrere fachliche Änderungen am eMP in einem Aufruf an den Medication Service übergeben. Innerhalb des Request-Bundles werden ausschließlich FHIR-Operationen ausgeführt (keine direkten Resource-CRUDs). Als letzte Operation ein $emp-commit ausgeführt, der eine neue Plan-Version (Provenance) erzeugt. Die Operation antwortet mit einem Bundle vom Typ transaction-response. |
| [Cancel Dispensation eRP](OperationDefinition-cancel-dispensation-erp-OP.md) | The Cancel Dispensation eRP operation, used by the E-Rezept-Fachdienst, in the context of the ePA Medication Service, is applied to cancel or reverse information regarding the dispensation of a medication. This operation is necessary when a medication dispensation is cancelled by a pharmacist or when there is a return of the medication by the insurant. After the E-Rezept-Fachdienst performs this operation, the corresponding dispensation entry for the medication in the patient's ePA is marked as cancelled, which the goal in ensuring an accurate and up-to-date record of the patient's medication data. |
| [Cancel Medication List Entry](OperationDefinition-cancel-eml-entry-op.md) | Diese Operation dient dem gezielten Widerruf/Abbruch eines bestehenden Eintrags der elektronischen Medikationsliste (eML) auf Instanzebene. |
| [Cancel Prescription eRP](OperationDefinition-cancel-prescription-erp-OP.md) | The $cancel-prescription-erp operation is used by the E-Rezept-Fachdienst to cancel an already issued electronic prescription. This function is applied when a prescription is no longer needed for various reasons, such as changes in medication or errors in the initial issuance. After cancellation by the E-Rezept-Fachdienst, this information is transmitted to the ePA Medication Service, where the prescription is calculations. It can then no longer be used for dispensing medication. This process ensures accuracy and safety in the management of medications. |
| [eMP Commit Operation](OperationDefinition-emp-commit-op.md) | Die eMP Commit Operation dient zum Abschluss einer Batch-Verarbeitung von eMP-Einträgen. Sie erzeugt eine neue Version des elektronischen Medikationsplans (eMP), indem eine aktualisierte Instanz von EMPChronologyProvenance erstellt wird, die auf alle relevanten EMPMedicationRequest verweist. Diese Operation wird in der Regel nur einmal am Ende eines Batch-Kontextes aufgerufen. |
| [Get Medication List](OperationDefinition-get-medication-list-op.md) | Die Operation liefert die elektronische Medikationsliste (eML) in Form eines FHIR searchSet-Bundles. In der eML werden ausschließlich nicht stornierte Instanzen von Verschreibungsdaten, Dispensierdaten, nachgetragenen Medikamenten sowie die zugehörige Versicherteninformation aus dem Patient Service angezeigt. |
| [Get Medication Plan (eMP)](OperationDefinition-get-medication-plan-op.md) | Diese Operation ermöglicht den gezielten Abruf eines elektronischen Medikationsplans (eMP) aus dem Datenraum des Medication Service. Der zurückgegebene Medikationsplan besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (Patient) aus dem Patient Service. Die Operation akzeptiert optional eine Provenance-Referenz.id als Eingabeparameter. Wird diese übergeben, liefert die Operation exakt den Zustand des Medikationsplans, wie er durch diese Provenance-Version beschrieben ist. So kann auch ein vergangener Stand des eMP nachvollziehbar wiedergegeben werden. Wird keine Provenance angegeben, gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält. |
| [eMP-Eintrag verknüpfen](OperationDefinition-link-emp-op.md) | Diese Instanz-Operation dient der Verknüpfung eines bestehenden eML-Eintrags (MedicationStatement) mit einem bereits dokumentierten Eintrag im elektronischen Medikationsplan (eMP). |
| [Medication Plan Chronology Log](OperationDefinition-medication-plan-log-op.md) | Diese Operation liefert die chronologische Historie aller gespeicherten Versionen des elektronischen Medikationsplans (eMP) in Form von Provenance-Ressourcen. Jede Provenance-Instanz beschreibt dabei einen dokumentierten Zustand des eMP zu einem bestimmten Zeitpunkt. Die Operation ermöglicht es, gezielt die Versionshistorie des Medikationsplans abzufragen - etwa um Änderungen nachzuvollziehen oder frühere Zustände einzusehen. |
| [Provide Dispensation eRP](OperationDefinition-provide-dispensation-erp-OP.md) | The Provide Dispensation eRP operation in the ePA Medication Service is used to record information about the dispensing of medications based on an electronic prescription in the patient's record. This operation comes into play when a patient receives their medication from a pharmacy. It documents that the medication has been dispensed as per the prescription, including details like the quantity, date of dispensing, and pharmacy information. This helps maintain a comprehensive overview of the patient's medication history. |
| [Provide Prescription eRP](OperationDefinition-provide-prescription-erp-OP.md) | The Provide Prescription eRP operation in the ePA MedicationService is used to add electronic prescriptions to a patient's record. These prescriptions are already made by the E-Rezept-Fachdienst. This operation does not create new patient prescriptions; it just puts the ones made by the E-Rezept-Fachdienst into the patient's ePA, making sure they are stored safely and can be easily accessed. |
| [eMP-Verknüpfung entfernen](OperationDefinition-unlink-emp-op.md) | Diese Operation des Medication Service dient dazu, eine Verknüpfung zwischen einem bestehenden eML-Eintrag und einem dokumentierten eMP-Eintrag aufzuheben. |
| [eMP-Eintrag aktualisieren](OperationDefinition-update-emp-entry-op.md) | Diese Operation dient der gezielten Aktualisierung eines bestehenden Medikations-Eintrags im elektronischen Medikationsplan (eMP). |

**Tabelle:**Operation Definitions

#### Suchparameter

| | |
| :--- | :--- |
| [IsEMPSP](SearchParameter-based-on-emp-sp.md) | Liefert alle Referencen, die einen eMP bezug haben |
| [ContextSP](SearchParameter-context-sp.md) | Liefert alle Resourcen mit diesem Context Code |
| [DerivedFromSP](SearchParameter-derived-from-sp.md) | Search by resources from which the medication statement is derived |
| [IsEMPChronologySP](SearchParameter-is-emp-chronology-sp.md) | Liefert alle Resourcen die eMP bezug haben (oder nicht) |
| [MedicationRequestActivitySP](SearchParameter-medication-statement-activity-sp.md) | Liefert alle referenzierten eML MedicationStatement Aktivitäten |
| [MedicationRequestEffectiveDosePeriodSP](SearchParameter-medicationrequest-effective-dose-period-sp.md) | Ermöglicht die Suche anhand des Zeitraums, in dem die Medikation eingenommen werden soll |
| [ProvenanceAgentIdentifierSP](SearchParameter-provenance-agent-identifier-sp.md) | Suche anhand der logischen Referenz (identifier) im Element Provenance.agent.who |
| [RxPrescriptionProcessParameter](SearchParameter-rx-prescription-process-sp.md) | Returns Medications, MedicationDispenses or MedicationStatement with the Rx Prescription Process Identifier. |

**Tabelle:**Suchparameter

#### Operation Outcomes

| | |
| :--- | :--- |
| [EPA Medication Service OperationOutcome Code System](CodeSystem-epa-ms-operation-outcome-details.md) | EPA Medication Service Operation Outcome Code System |
| [EPA Medication Service Operation Outcome](StructureDefinition-epa-ms-operation-outcome.md) | Das Operation Outcome-Profil für den Medication Service der ePA. |
| [EPA Medication Service Operation Outcome ValueSet](ValueSet-epa-ms-operation-outcome-details.md) | Enthält alle Codes für das Operation Outcome des Medication Service. |

**Tabelle:**Operation Outcomes

### Parameterprofile für Operationen

| | |
| :--- | :--- |
| [EPA Operation addEMLEntry Input-Parameters](StructureDefinition-epa-op-add-eml-entry-input-parameters.md) | EPA Operation addEMLEntry Input-Parameters |
| [EPA Operation addEMPEntry Input-Parameters](StructureDefinition-epa-op-add-emp-entry-input-parameters.md) | EPA Operation addEMPEntry Input-Parameters |
| [EPA Operation CancelDispensation ERP Input-Parameters](StructureDefinition-epa-op-cancel-dispensation-erp-input-parameters.md) | EPA Operation CancelDispensation ERP Input-Parameters |
| [EPA Operation CancelPrescription ERP Input-Parameters](StructureDefinition-epa-op-cancel-prescription-erp-input-parameters.md) | EPA Operation CancelPrescription ERP Input-Parameters |
| [EPA Operation EMLEntry Output-Parameters](StructureDefinition-epa-op-eml-entry-output-parameters.md) | EPA Operation EMLEntry Output-Parameters |
| [EPA Operation EMPEntry Output-Parameters](StructureDefinition-epa-op-emp-entry-output-parameters.md) | EPA Operation EMPEntry Output-Parameters |
| [EPA Operation Link eMP Output Parameters](StructureDefinition-epa-op-link-emp-entry-output-parameters.md) | EPA Operation Link eMP Output Parameters |
| [EPA Operation Link eMP Parameters](StructureDefinition-epa-op-link-emp-entry-parameters.md) | EPA Operation Link eMP Parameters |
| [EPA Operation ProvideDispensation ERP Input-Parameters](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.md) | EPA Operation ProvideDispensation ERP Input-Parameters |
| [EPA Operation ProvidePrescription ERP Input-Parameters](StructureDefinition-epa-op-provide-prescription-erp-input-parameters.md) | EPA Operation ProvidePrescription ERP Input-Parameters |
| [EPA eMP Commit Operation Input-Parameters](StructureDefinition-epa-op-rmp-commit-input-parameters.md) | EPA eMP Commit Operation Input-Parameters |
| [EPA Operation RxDispensation ERP Output-Parameters](StructureDefinition-epa-op-rx-dispensation-erp-output-parameters.md) | EPA Operation RxDispensation ERP Output-Parameters |
| [EPA Operation RxPrescription ERP Output-Parameters](StructureDefinition-epa-op-rx-prescription-erp-output-parameters.md) | EPA Operation RxPrescription ERP Output-Parameters |
| [EPA Operation UpdateEMPEntry Input-Parameters](StructureDefinition-epa-op-update-emp-entry-input-parameters.md) | EPA Operation UpdateEMPEntry Input-Parameters |

**Tabelle:**Parameterprofile

### Ressourcenprofile

| | |
| :--- | :--- |
| [eMP Chronology Provenance](StructureDefinition-emp-chronology-provenance.md) | Dieses Profil beschreibt die Verwendung der FHIR-Resource Provenance zur Abbildung eines eMP-Chronologieeintrags. Die Provenance-Instanz dokumentiert, welche eMP-Einträge (MedicationRequest-Instanzen) zu einem bestimmten Zeitpunkt als Teil des elektronischen Medikationsplans (eMP) gültig waren. Ein eMP-Chronologieeintrag wird immer dann erzeugt, wenn sich die eMP-relevanten Instanzen geändert haben oder neue eMP-Einträge hinzugekommen sind. Er referenziert sämtliche zum Erstellungszeitpunkt aktiven eMP-MedicationRequest-Instanzen, d.h. alle Ressourcen mit dem Status active oder on-hold. Dadurch wird der Zustand des Medikationsplans zu diesem Zeitpunkt nachvollziehbar. Der eMP-Chronologieeintrag ermöglicht somit eine eindeutige und versionssichere Rückverfolgung der Zusammensetzung des eMP über verschiedene Zeitpunkte hinweg. |
| [eMP MedicationRequest](StructureDefinition-emp-medication-request.md) | eMP-Eintrag: Hält die Medikationsinformationen eines Eintrags für den elektronischen MedikationsPlan (eMP) vor und stellt das zentrale Element dar. Es stellt die Verbindung zwischen der Planung und einem oder mehrerer Verschreibungsprozesse oder Nachträge. |
| [eMP Medication](StructureDefinition-emp-medication.md) | Defines the medication resource for the Medication Service in the ePA system in the eMP context. |
| [Batch API eMP-Einträge - Request-Bundle](StructureDefinition-epa-batch-emp-request-bundle.md) | Request-Bundle für die Batch-Operation zur Verarbeitung von eMP-Einträgen. Erlaubt sind ausschließlich FHIR-Operationen (POST) für den eMP. $emp-commit MUSS genau einmal vorkommen. Es sind keine direkten Ressourcen-CRUDs zulässig. |
| [EPA MedicationDispense](StructureDefinition-epa-medication-dispense.md) | Defines the medication dispense resource for the Medication Service in the ePA system. |
| [EPA Pharmaceutical Product Medication](StructureDefinition-epa-medication-pharmaceutical-product.md) | Defines the medication resource for a component of a 'Kombipackung' for the Medication Service in the ePA system. These profiles are intended to inherit from EPAMedication, but due to tooling issues, this inheritance cannot currently be implemented. |
| [EPA Medication PZN Ingredient](StructureDefinition-epa-medication-pzn-ingredient.md) | Defines the medication resource for a PZN ingredient of a compounding medication for the Medication Service in the ePA system. These profiles are intended to inherit from EPAMedication, but due to tooling issues, this inheritance cannot currently be implemented. |
| [EPA MedicationRequest](StructureDefinition-epa-medication-request.md) | Defines the medication request resource for the Medication Service in the ePA system. |
| [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md) | Hält die Medikationsinformationen eines Eintrags in der elektronischen Medikationsliste (eML) vor und stellt das zentrale Element dar. Es wird zu Verschreibungs- und Dispensierinformationen als auch Nachträgen in der eML genutzt. |
| [EPA Medication](StructureDefinition-epa-medication.md) | Defines the medication resource for the Medication Service in the ePA system. |

**Tabelle:**Ressourcenprofile

### Datentypen

| | |
| :--- | :--- |
| [Medication Unique Identifier](StructureDefinition-epa-medication-unique-identifier.md) | This unique identifier is generated within the Medication Service. It is either a hash derived from a specific set of data elements of the Medication resource or a direct repetition of a single data element. This identifier ensures the distinct identification of Medication resources across the ePA system. |
| [RxOriginatorProcessIdentifier](StructureDefinition-rx-originator-process-identifier.md) | The RxOriginatorProcessIdentifier, generated within the Medication Service, links the prescriptionID from the E-Rezept-Fachdienst with the original input FHIR resource ID, facilitating accurate tracking and utilization of medication data in operational processes within digital healthcare systems. |
| [RxPrescriptionProcessIdentifier](StructureDefinition-rx-prescription-process-identifier.md) | This transaction identifier is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. It is generated by the ePA Medication Service, ensuring a consistent and unique identification of each transaction. The identifier is composed of the PrescriptionId and the authoredOn-date of the operations parameters request, providing a robust mechanism for referencing and managing medication-related resources across systems. |

**Tabelle:**Datentypen

### Erweiterungen (Extension) Definitions

| | |
| :--- | :--- |
| [ContextExtension](StructureDefinition-context-extension.md) | Extension for indicating the context. |
| [DrugCategoryExtension](StructureDefinition-drug-category-extension.md) | Extension for indicating the medication category. |
| [EMPMedicationRequestActitvityExtension](StructureDefinition-emp-medicationrequest-activity-extension.md) | Bildet eine Aktivität in bezug auf ein EMPMedicationRequest ab |
| [Origin Medication Reference (eMP)](StructureDefinition-emp-origin-medication-extension.md) | Erlaubt einem eMP MedicationRequest, auf die ursprünglich verwendete Medication-Instanz zu referenzieren (Ursprung des eMP-Eintrags). |
| [Medication Type](StructureDefinition-epa-medication-type-extension.md) | Extension for EPAMedication types |
| [EPAMedicationStatementProcessingEventExtension](StructureDefinition-epa-medicationstatement-processing-event-extension.md) | Bildet ein Ereignis ab, das wärend der Verarbeitung auftritt. |
| [IndicatorBVGExtension](StructureDefinition-indicator-bvg-extension.md) | Indicator of whether this regulation is made in reference to the 'Bundesentschädigungsgesetz' or the 'Bundesversorgungsgesetz'. |
| [IndicatorSERExtension](StructureDefinition-indicator-ser-extension.md) | Kennzeichnung, ob diese Verordnung mit Bezug zum Sozialen Entschädigungsrecht nach SGB XIV (SER) erfolgt |
| [IsEMPChronologyExtension](StructureDefinition-is-emp-chronology-extension.md) | Definiert, ob die Provenance ein eMP-Chronologieeintrag ist. |
| [IsEMPExtension](StructureDefinition-is-emp-extension.md) | Definiert ob etwas einen Bezug zum eMP hat |
| [MedicationFormulationPackagingExtension](StructureDefinition-medication-formulation-packaging-extension.md) | Information on the packaging of a formulation. |
| [MedicationIsVaccineExtension](StructureDefinition-medication-id-vaccine-extension.md) | Indicator of whether this is a vaccine. |
| [MedicationIngredientAmountExtensions](StructureDefinition-medication-ingredient-amount-extension.md) | Free-text amount of the ingredient for classical Latin notations such as "ad 100.0" or "quantum satis," including the unit. |
| [MedicationIngredientDarreichungsformExtension](StructureDefinition-medication-ingredient-darreichungsform-extension.md) | Dosage form of an ingredient in a formulation. |
| [MedicationManufacturingInstructionsExtension](StructureDefinition-medication-manufacturing-instructions-extension.md) | Manufacturing instructions regarding the preparation of a formulation (Subscriptio). |
| [MedicationPackagingSizeExtension](StructureDefinition-medication-packaging-size-extension.md) | Specification of the package size according to divided quantity (e.g., 100, 2x25), only appears in conjunction with "unit" (e.g., 100 Stück). |
| [MedicationTotalQuantityFormulationExtension](StructureDefinition-medication-total-quantity-formulation-extension.md) | Total quantity of the formulation (without the unit). |
| [MultiplePrescription](StructureDefinition-multiple-prescription-extension.md) | This FHIR Extension for multiple prescriptions adds details such as repetition count and time intervals for repeated medication orders to FHIR resources. |
| [NarcoticsExtension](StructureDefinition-narcotics-extension.md) | Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG) |
| [PatientIDExtension](StructureDefinition-patient-id-extension.md) | Patienten-ID, welche bei der Verordnung bestimmter Arzneimittel angegeben werden kann. |
| [PatientNoteExtension](StructureDefinition-patient-note-extension.md) | Extension für einen Hinweis für den Patienten |
| [PrescriberIDExtension](StructureDefinition-prescriber-id-extension.md) | Verschreiber-ID, welche bei der Verordnung bestimmter Präparate anzugeben ist, damit die Apotheke das Rezept beliefern darf. |
| [ReasonPatientInstructionExtension](StructureDefinition-reason-patient-instruction-extension.md) | Patientenverständliche Beschreibung des Grundes |
| [RxPrescriptionProcessIdentifierExtension](StructureDefinition-rx-prescription-process-identifier-extension.md) | This extension is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. The RxPrescriptionProcessIdentifier is generated by the ePA Medication Service and consists of the PrescriptionId and the authoredOn date of the operation parameters request. It ensures consistent referencing and management of medication-related resources across different systems. |
| [TeratogenicExtension](StructureDefinition-teratogenic-extension.md) | Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept) |

**Tabelle:**Extension Definitions

### Nutzung von Cross-Version-Extensions

Für die Profile der Ressourcen *MedicationRequest*, *MedicationDispense* und *MedicationStatement* werden die Backport-FHIR-Extensions `.renderedDosageInstruction` und `.effectiveDosePeriod` verwendet. Diese Elemente stammen aus FHIR R5 und wurden über den von der [FHIR-Spezifikation definierten Cross-Version-Mechanismus](https://hl7.org/fhir/versions.html#extensions) nach R4 zurückportiert. Dieser Mechanismus wird u. a. bereits vom [HL7 Java FHIR Validator](https://confluence.hl7.org/spaces/FHIR/pages/35718580/Using+the+FHIR+Validator) unterstützt; andere Validatoren müssen gegebenenfalls das entsprechende Cross-Version-Paket nachladen.

Das offizielle Cross-Version-Paket war zum Releasezeitpunkt dieses Implementation Guides noch nicht final in der FHIR-Registry verfügbar. Die Package-ID lautet: `hl7.fhir.uv.xver-r5.r4`. Bis zur offiziellen Veröffentlichung kann der Inhalt des folgenden Snapshot-Releases verwendet werden: [https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/)

Im Paket sind die benötigten cross-version Extensions enthalten:

* [MedicationDispense.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationDispense.renderedDosageInstruction.html)
* [MedicationRequest.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationRequest.renderedDosageInstruction.html)
* [MedicationStatement.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationStatement.renderedDosageInstruction.html)
* [MedicationRequest.effectiveDosePeriod](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationRequest.effectiveDosePeriod.html)

### Beispielinstanzen

**Bundle**

* [ExampleEPABatchEmpRequestBundle](Bundle-example-epa-batch-emp-request-bundle.md)

* [ExampleEPABatchEmpResponseBundle](Bundle-example-epa-batch-emp-response-bundle.md)

* [ExampleEpaGetMedicationListBundle](Bundle-example-get-medication-list-bundle1.md)

* [ExampleEpaGetMedicationPlanBundle](Bundle-example-get-medication-plan-bundle-1.md)

* [ExampleSearchsetBundleEPAMedication](Bundle-example-searchset-medication.md)

* [ExampleSearchsetBundleEPAMedicationDispense](Bundle-example-searchset-medicationdispense.md)

* [ExampleSearchsetBundleEPAMedicationRequest](Bundle-example-searchset-medicationrequest.md)

* [ExampleSearchsetBundleEPAMedicationStatement](Bundle-example-searchset-medicationstatement.md)

* [MedicationPlanChronologyLogBundle](Bundle-medication-plan-chronology-log-bundle.md)

**Medication**

* [COTRIM](Medication-1254591a-dd2d-4d17-b8f8-ee3155da0699.md)

* [eMP_Benazepril](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md)

* [1412aa4f-a9ed-45f2-8916-063fee7eb025](Medication-1412aa4f-a9ed-45f2-8916-063fee7eb025.md)

* [Doxycyclin](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md)

* [Diclo](Medication-2571d29b-e213-40ec-b817-a1490718f491.md)

* [Aciclovir](Medication-312d581c-f5e7-4faa-9de5-c4e1568c6db2.md)

* [Ramipril](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md)

* [Technical-Exp-NachtragEmlMedicationIBU](Medication-4B5557E5-4900-47FE-A8D9-407611E05BD2.md)

* [Venlafaxin](Medication-56ca34f1-a3f3-42f7-95a2-f5a6423c2031.md)

* [L-Thyroxin_MV_4](Medication-659c0be1-2ec8-4137-9698-dcffee811934.md)

* [L-Thyroxin_MV_3](Medication-83d7ad1c-47d1-4524-829a-5b86ce333bbc.md)

* [eMP_Sumatriptan](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md)

* [Cortison Dexpantenol Medication](Medication-CortisonDexpantenol.md)

* [Technical-Exp-EPAMedicationMax](Medication-Technical-Exp-EPAMedicationMax.md)

* [Technical-Exp-NachtragEmlMedication](Medication-Technical-Exp-NachtragEmlMedication.md)

* [Technical-Exp-NachtragEmpMedicationEml](Medication-Technical-Exp-NachtragEmpMedicationEml.md)

* [Technical-Exp-NachtragEmpMedicationEmp](Medication-Technical-Exp-NachtragEmpMedicationEmp.md)

* [L-Thyroxin_MV_2](Medication-a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3.md)

* [Prospan](Medication-ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e.md)

* [JanuviaFilmtabletten](Medication-bb91cde8-0426-4f4b-a766-5d818d0605bd.md)

* [L-Thyroxin_MV_1](Medication-deecd514-235d-41df-a664-e3672208f410.md)

* [IBU](Medication-ef5d5baf-0c42-4240-9604-7fba9cea926d.md)

* [Sumatriptan](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md)

**MedicationDispense**

* [Prospan_Dispense](MedicationDispense-3c10c1ad-1d7a-47e8-abab-00b8299b49b8.md)

* [JanuviaFilmtabletten_Dispense](MedicationDispense-4e6e1623-778e-44a3-b208-8479f5339e43.md)

* [Ramipril_Dispense](MedicationDispense-5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad.md)

* [COTRIM_Dispense](MedicationDispense-6250569a-3505-4db7-aebc-45dba1f98acc.md)

* [Aciclovir_Dispense](MedicationDispense-b2911d1e-fc63-47bb-8887-63b701bc49c4.md)

* [Venlafaxin_Dispense](MedicationDispense-c0b553bd-2542-49d7-b5e1-0a770185e39f.md)

* [Doxycyclin_Dispense](MedicationDispense-c3a353f0-c61a-4d6b-affa-daf8c0f6e77c.md)

* [L-Thyroxin_Dispense_MV_1](MedicationDispense-f7240e05-01a1-4ce6-a8bb-edb71b6b5104.md)

* [Sumatriptan_Dispense](MedicationDispense-fa0c29e1-c4e7-4f08-91ab-598a2233867c.md)

**MedicationRequest**

* [L-Thyroxin_Request_MV_3](MedicationRequest-0435e19e-ed9a-4b5b-a9e9-70924c5922a0.md)

* [Doxycyclin_Request](MedicationRequest-08cb8487-2758-406c-999a-e23a05e63c0b.md)

* [Ramipril_Request](MedicationRequest-0e7f16e4-d879-4a2c-8292-41c55201bbdd.md)

* [eMP_Sumatriptan_Request](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md)

* [L-Thyroxin_Request_MV_2](MedicationRequest-2a794a78-8a72-46ca-bb81-09f702f94e11.md)

* [JanuviaFilmtabletten_Request](MedicationRequest-3191d752-3adf-4c7f-848d-8d43766fed72.md)

* [L-Thyroxin_Request_MV_4](MedicationRequest-3ffb5c34-81e7-45ec-842c-82a2422cb8c8.md)

* [Prospan_Request](MedicationRequest-40df19aa-40e2-4ebc-a11d-9d232dcb0f67.md)

* [Sumatriptan_Request](MedicationRequest-4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8.md)

* [Aciclovir_Request](MedicationRequest-6461edff-13ec-4dc7-b9f3-aea66bcb0643.md)

* [eMP_Benazepril_Request](MedicationRequest-71b66f1b-8032-4886-b7bf-e775daee22fb.md)

* [Venlafaxin_Request](MedicationRequest-7efae80a-a4d9-4e26-a1b9-92c72e79cfaa.md)

* [Technical-Exp-NachtragEmpMedicationRequestEmp](MedicationRequest-Technical-Exp-NachtragEmpMedicationRequestEmp.md)

* [L-Thyroxin_Request_MV_1](MedicationRequest-ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e.md)

* [COTRIM_Request](MedicationRequest-f14498f0-4932-490a-91a2-9de8616e133b.md)

* [Teratogenic_Request](MedicationRequest-f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd.md)

**MedicationStatement**

* [Ramipril_Information](MedicationStatement-0fc1f006-5793-4501-81b6-fe3918fcfa2d.md)

* [L-Thyroxin_Information_MV_1](MedicationStatement-133c8159-6398-4937-984a-d741e24556ad.md)

* [Prospan_Information](MedicationStatement-1b88713c-64cc-40ad-9665-70ca5f7dfb08.md)

* [IBU_Information](MedicationStatement-1cb0f018-178d-4488-a6b4-2be32dbda784.md)

* [Doxycyclin_Information](MedicationStatement-405ff43e-bc8e-4109-b370-3e31431c5fe0.md)

* [Diclo_Information](MedicationStatement-71601cdb-8a53-4f26-b5d5-e5457b498e76.md)

* [Technical-Exp-NachtragEmlMedicationStatement](MedicationStatement-Technical-Exp-NachtragEmlMedicationStatement.md)

* [Technical-Exp-NachtragEmpMedicationStatementEml](MedicationStatement-Technical-Exp-NachtragEmpMedicationStatementEml.md)

* [COTRIM_LINKING_NOT_SUCCESSFUL_Information](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md)

* [Venlafaxin_Information](MedicationStatement-b87b0908-7765-4ec0-8662-7d3daff08f6e.md)

* [Aciclovir_Information](MedicationStatement-cfb84928-15d6-468c-8e17-e77f1ed44904.md)

* [Sumatriptan_Information](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md)

* [JanuviaFilmtabletten_Information](MedicationStatement-f3988023-2313-4645-bd6b-f9e37cfb6fc7.md)

**OperationOutcome**

* [ExpOperationOutcomeNoValidStructureWithDiagnostics](OperationOutcome-0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8.md)

* [ExpOperationOutcomeEMPChronologyIdMismatch](OperationOutcome-0b476e35-02d5-4fb0-ad60-79f5eb05e2b4.md)

* [ExpOperationOutcomeDeleted](OperationOutcome-0b967346-00bf-412c-8e05-077ed13e873e.md)

* [ExpOperationOutcomeAlreadyLinked](OperationOutcome-12f5513f-3eef-41ad-baca-826627c890f2.md)

* [ExpOperationOutcomeDosageInvalid](OperationOutcome-1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5.md)

* [ExpOperationOutcomeEMPAlreadyExists](OperationOutcome-1e5838dd-ec29-4f68-9739-dfa717db515d.md)

* [ExpOperationOutcomeEMPLinkingNotSuccessful](OperationOutcome-24b64018-89f4-4a52-8e9c-c0af279c4e86.md)

* [ExpOperationOutcomeSuccess](OperationOutcome-255002c7-aa1b-4163-bdd4-ede482453cca.md)

* [ExpOperationOutcomeNoValidStructure](OperationOutcome-2b34898e-a9d1-4fa6-9959-5ff6033cfcb0.md)

* [ExpOperationOutcomeOrgHeaderProfileMismatch](OperationOutcome-41d25882-4a02-47e3-a367-f5b5fe8c8015.md)

* [OperationOutcomeInvalidQueryParameter](OperationOutcome-446e77ff-9fcb-4232-8de3-74986f78d85f.md)

* [OperationOutcomeInvalidRequest](OperationOutcome-52c59e99-eba0-4488-b829-39983b9169f5.md)

* [ExpOperationOutcomeOperationOutsideBatch](OperationOutcome-912a5e81-6274-439e-9d79-5172c4855a70.md)

* [OperationOutcomeResourceIsNotKnown](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4db.md)

* [OperationOutcomeEMPNoExist](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4dc.md)

* [ExpEPAOperationOutcomeOrgHeaderToLarge](OperationOutcome-a1dc2bb2-1776-4ccd-929f-355472077cf6.md)

* [OperationOutcomeEmptyList](OperationOutcome-a4da96e5-84d6-4883-8789-5df2e1363c40.md)

* [ExpOperationOutcomeNotPermittedonCurrentDispensationStatus](OperationOutcome-a94b020a-2f34-4013-83ea-cf1bd0a92cdd.md)

* [OperationOutcomeUnknownResourceType](OperationOutcome-b29880f0-6c99-4fe2-aae2-007e8cb4d9cf.md)

* [ExpOperationOutcomeNotPermittedCurrentPrescriptionStatus](OperationOutcome-bef62761-7eea-4daa-a992-36c532232679.md)

* [ExpOperationOutcomeOperationDispensationNotFound](OperationOutcome-c03670fe-eaf2-4a38-a333-4dc1470072a2.md)

* [ExpOperationOutcomeEMPUnlinkingNotSuccessful](OperationOutcome-c146f801-8f50-4ca4-8578-514d5938e3c3.md)

* [OperationOutcomeUnknownSearchParameter](OperationOutcome-dc558008-4fbd-4e51-a16a-0cbc382a529f.md)

* [ExpOperationOutcomeVersionAwareConflict](OperationOutcome-e4f1ed42-7741-40f5-a84e-fd688ac74d3e.md)

* [ExpOperationOutcomeOpNotAllowed](OperationOutcome-e69228bf-6f07-4055-8190-e832d2c670dc.md)

* [ExpOperationOutcomeUnresolvedReferenceinParameters](OperationOutcome-e730e451-3a44-4842-a8ed-1517a3334465.md)

* [ExpOperationOutcomeDuplicatePrescriptionDetected](OperationOutcome-ee1e0518-02f2-4d3a-99ae-bae8e91c382d.md)

* [ExpOperationOutcomePrescriptionNotFound](OperationOutcome-fc3e8ea4-41ec-4de2-906e-97871b34adcb.md)

**Organization**

* [GematikApotheke](Organization-151f1697-7512-4e21-9466-1b75207475d8.md)

* [PraxisTIOrganization](Organization-450a9511-53e5-4af7-be36-a18444bb8dd2.md)

* [ApothekeTIOrganization](Organization-8B421590-9F7F-46BE-BD1E-C987063AC4F5.md)

* [Technical-Exp-NachtragEmlLEI](Organization-Technical-Exp-NachtragEmlLEI.md)

* [Technical-Exp-NachtragEmpLEI](Organization-Technical-Exp-NachtragEmpLEI.md)

* [BetriebsstaetteArzt](Organization-ad7dc0e7-cb44-4740-ba67-cb573e29d596.md)

* [GematikOrganization](Organization-be51e0d2-783d-4e21-b16b-1a4cd7403515.md)

**Parameters**

* [ExpEPAOpUpdateEMPEntryInputParameters_Batch](Parameters-7ccb2670-7178-4f82-912a-de70f68ecd51.md)

* [ExpEPAOpAddEmlEntryInputParameters](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md)

* [ExpEPAOpAddEMPEntryInputParameters](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md)

* [ExpEPAOpAddEMPEntryWithReferenceInputParameters](Parameters-example-epa-op-add-emp-entry-with-reference-input-parameters-1.md)

* [ExampleEpaOpCancelDispensationERPInputParameters1](Parameters-example-epa-op-cancel-dispensation-erp-input-parameters-1.md)

* [ExampleEpaOpCancelPrescriptionERPInputParameters1](Parameters-example-epa-op-cancel-prescription-erp-input-parameters-1.md)

* [ExpEPAOpEmlEntryCancelledOutputParameters](Parameters-example-epa-op-eml-entry-cancelled-output-parameters-1.md)

* [ExpEPAOpEmlEntryOutputParameters](Parameters-example-epa-op-eml-entry-output-parameters-1.md)

* [ExpEPAOpEMPEntryOutputParameters](Parameters-example-epa-op-emp-entry-output-parameters-1.md)

* [ExpEPAOpEMPEntryOutputParametersUpdate](Parameters-example-epa-op-emp-entry-output-parameters-2.md)

* [ExpEPAOpLinkEMPEntryOutputParameters](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md)

* [ExpEPAOpLinkEMPEntryParameters](Parameters-example-epa-op-link-emp-entry-parameters-1.md)

* [ExampleEpaOpProvideDispensationERPInputParameters1](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-1.md)

* [ExampleEpaOpProvideDispensationERPInputParameters2](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-2.md)

* [ExampleEpaOpProvideDispensationERPInputParametersInProgress](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-3.md)

* [ExampleEpaOpProvidePrescriptionERPInputParameters1](Parameters-example-epa-op-provide-prescription-erp-input-parameters-1.md)

* [ExampleEpaOpProvidePrescriptionERPInputParameters2](Parameters-example-epa-op-provide-prescription-erp-input-parameters-2.md)

* [ExpEPAOpEMPCommitInputParameters](Parameters-example-epa-op-rmp-commit-input-parameters-1.md)

* [ExampleEpaOpRxDispensationOutputParameters1](Parameters-example-epa-op-rx-dispensation-erp-output-parameters-1.md)

* [ExampleEpaOpRxPrescriptionERPOutputParameters1](Parameters-example-epa-op-rx-prescription-erp-output-parameters-1.md)

* [ExpEPAOpUnlinkEMPEntryOutputParameters](Parameters-example-epa-op-unlink-emp-entry-output-parameters-1.md)

* [ExpEPAOpUnlinkEMPEntryParameters](Parameters-example-epa-op-unlink-emp-entry-parameters-1.md)

* [ExpEPAOpUpdateEMPEntryInputParameters](Parameters-example-epa-op-update-emp-entry-input-parameters-1.md)

**Patient**

* [Technical-Exp-NachtragEmlPatient](Patient-Technical-Exp-NachtragEmlPatient.md)

* [Technical-Exp-NachtragEmpPatient](Patient-Technical-Exp-NachtragEmpPatient.md)

**Practitioner**

* [Arzt](Practitioner-498c345f-31f5-4da6-9f04-00fa2bc8af7c.md)

**PractitionerRole**

* [Arzt PractitionerRole](PractitionerRole-73a551f8-d8cd-4b44-823d-ab5f8aeab1aa.md)

* [PraxisTI PractitionerRole](PractitionerRole-b9eb9668-b61e-43b5-b3ea-485234836d59.md)

**Provenance**

* [eMP_Benazepril_Chronology_Provenance_1](Provenance-0b383501-f078-464b-b984-9fdb6751601b.md)

* [Prospan_Information_Provenance](Provenance-168ec791-45ca-434c-8ba8-cbc855a3ca90.md)

* [Sumatriptan_Information_Provenance](Provenance-176eec9c-8d5a-46a7-96e3-7af3f68c49ed.md)

* [Venlafaxin_Information_Provenance](Provenance-1a93c378-435e-437e-8c7c-6e84b788a3eb.md)

* [eMP_Sumatriptan_Activity_Provenance_Batch_Response](Provenance-20335453-d103-4957-a370-03c9007db2f6.md)

* [eMP_Sumatripta_Chronology_Provenance](Provenance-2e112cb5-3b9f-4434-848e-26e27756cd30.md)

* [eMP_Chronology_Provenance](Provenance-2e1ba746-1aef-4eef-b741-2dfc771c7001.md)

* [eMP_Chronology_Provenance_Batch](Provenance-319fcc6e-049d-4eb1-9a5c-82c33438cf94.md)

* [Cancelled_Diclo_Information_Provenance](Provenance-39475183-3444-4b63-bfed-ae0741f4496b.md)

* [L-Thyroxin_Information_Provenance](Provenance-850ef590-34ff-469a-8c0d-13b6751a029b.md)

* [eMP_Benazepril_Activity_Provenance](Provenance-8faa45dd-b2dc-4a80-8956-94aeab1db04b.md)

* [eMP_Sumatripta_Activity_Provenance](Provenance-9090b28c-e165-4823-b82b-15bb63012123.md)

* [Technical-Exp-NachtragEmlProvenance](Provenance-Technical-Exp-NachtragEmlProvenance.md)

* [Technical-Exp-NachtragEmpProvenanceEml](Provenance-Technical-Exp-NachtragEmpProvenanceEml.md)

* [Technical-Exp-NachtragEmpProvenanceEmp](Provenance-Technical-Exp-NachtragEmpProvenanceEmp.md)

* [Diclo_Information_Provenance](Provenance-a36b3ae8-1c1d-4dbb-b209-ee2ee9fc31e6.md)

* [Ramipril_Information_Provenance](Provenance-a99c2849-de82-4a43-98f4-8d6a4caa6038.md)

* [eMP_Benazepril_Chronology_Provenance_2](Provenance-b467ce05-e0e5-4d71-9a0b-d824dbb492ef.md)

* [COTRIM_Information_Provenance](Provenance-b5ad3b05-1174-415f-8f43-555160862b25.md)

* [Doxycyclin_Information_Provenance](Provenance-cf988182-fd13-4f1f-a35c-d045c57c28d0.md)

* [JanuviaFilmtabletten_Information_Provenance](Provenance-de42aa65-f84e-4e96-acfb-b9fd5e104b2d.md)

* [Aciclovir_Information_Provenance](Provenance-f2e5c91f-4aed-484f-b313-7332ac2677c8.md)

* [IBU_Information_Provenance](Provenance-f35a13e2-d82c-4826-97d7-b7e32721c4af.md)

