# EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst)**

## ValueSet: EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst) 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/ValueSet/epa-provide-dispensation-status-vs | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAProvideDispensationStatusVS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses ValueSet definiert die möglichen ePA Statuswerte für die FHIR-Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst). Es bestimmt, ob eine vorläufige oder abgeschlossene Dispensierung vorliegt. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "epa-provide-dispensation-status-vs",
  "url" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-provide-dispensation-status-vs",
  "version" : "1.3.0",
  "name" : "EPAProvideDispensationStatusVS",
  "title" : "EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses ValueSet definiert die möglichen ePA Statuswerte für die FHIR-Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst). Es bestimmt, ob eine vorläufige oder abgeschlossene Dispensierung vorliegt.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medicationdispense-status",
        "concept" : [
          {
            "code" : "in-progress",
            "display" : "In Progress",
            "designation" : [
              {
                "language" : "de",
                "value" : "In Bearbeitung"
              },
              {
                "language" : "de",
                "value" : "Abgabe ist erfolgt, Bearbeitung noch nicht final abgeschlossen."
              }
            ]
          },
          {
            "code" : "completed",
            "display" : "Completed",
            "designation" : [
              {
                "language" : "de",
                "value" : "Abgeschlossen"
              },
              {
                "language" : "de",
                "value" : "Abgabe ist final abgeschlossen und quittiert."
              }
            ]
          }
        ]
      }
    ]
  }
}

```
