# EPA MedicationStatement Processing Codes - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MedicationStatement Processing Codes**

## ValueSet: EPA MedicationStatement Processing Codes 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/ValueSet/epa-medicationstatement-processing-event-code | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationStatementProcessingEventCodeVS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Codes that define events that occur during processing of an EMPMedicationStatement 

 **References** 

* [EPAMedicationStatementProcessingEventExtension](StructureDefinition-epa-medicationstatement-processing-event-extension.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "epa-medicationstatement-processing-event-code",
  "url" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-medicationstatement-processing-event-code",
  "version" : "1.3.0",
  "name" : "EPAMedicationStatementProcessingEventCodeVS",
  "title" : "EPA MedicationStatement Processing Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "Codes that define events that occur during processing of an EMPMedicationStatement",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "compose" : {
    "include" : [
      {
        "system" : "https://gematik.de/fhir/epa-medication/CodeSystem/epa-medicationstatement-processing-event-code"
      }
    ]
  }
}

```
