# RxPrescriptionProcessIdentifier - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **RxPrescriptionProcessIdentifier**

## Data Type Profile: RxPrescriptionProcessIdentifier 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier | *Version*:1.0.6-2 |
| Active as of 2025-05-12 | *Computable Name*:RxPrescriptionProcessIdentifier |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
This transaction identifier is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. It is generated by the ePA Medication Service, ensuring a consistent and unique identification of each transaction. The identifier is composed of the PrescriptionId and the authoredOn-date of the operations parameters request, providing a robust mechanism for referencing and managing medication-related resources across systems. 

**Usages:**

* Use this DataType Profile: [EPA MedicationRequest](StructureDefinition-epa-medication-request.md) and [RxPrescriptionProcessIdentifierExtension](StructureDefinition-rx-prescription-process-identifier-extension.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/rx-prescription-process-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-rx-prescription-process-identifier.csv), [Excel](StructureDefinition-rx-prescription-process-identifier.xlsx), [Schematron](StructureDefinition-rx-prescription-process-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rx-prescription-process-identifier",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier",
  "version" : "1.0.6-2",
  "name" : "RxPrescriptionProcessIdentifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-05-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "This transaction identifier is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. It is generated by the ePA Medication Service, ensuring a consistent and unique identification of each transaction. The identifier is composed of the PrescriptionId and the authoredOn-date of the operations parameters request, providing a robust mechanism for referencing and managing medication-related resources across systems.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "patternUri" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "mustSupport" : true
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
