# PatientNoteExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **PatientNoteExtension**

## Extension: PatientNoteExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:PatientNoteExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Extension für einen Hinweis für den Patienten

**Context of Use**

This extension may be used on the following element(s):

* Element ID MedicationRequest

**Usage info**

**Usages:**

* Use this Extension: [eMP MedicationRequest](StructureDefinition-emp-medication-request.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md), [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md)...Show 9 more,[MedicationRequest/71b66f1b-8032-4886-b7bf-e775daee22fb](MedicationRequest-71b66f1b-8032-4886-b7bf-e775daee22fb.md),[Parameters/7ccb2670-7178-4f82-912a-de70f68ecd51](Parameters-7ccb2670-7178-4f82-912a-de70f68ecd51.md),[Parameters/example-epa-op-add-emp-entry-input-parameters-1](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md),[Parameters/example-epa-op-add-emp-entry-with-reference-input-parameters-1](Parameters-example-epa-op-add-emp-entry-with-reference-input-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-1](Parameters-example-epa-op-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-2](Parameters-example-epa-op-emp-entry-output-parameters-2.md),[Parameters/example-epa-op-link-emp-entry-output-parameters-1](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-unlink-emp-entry-output-parameters-1](Parameters-example-epa-op-unlink-emp-entry-output-parameters-1.md)and[Parameters/example-epa-op-update-emp-entry-input-parameters-1](Parameters-example-epa-op-update-emp-entry-input-parameters-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/patient-note-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-note-extension.csv), [Excel](StructureDefinition-patient-note-extension.xlsx), [Schematron](StructureDefinition-patient-note-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-note-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension",
  "version" : "1.3.0",
  "name" : "PatientNoteExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Extension für einen Hinweis für den Patienten",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Extension für einen Hinweis für den Patienten"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/patient-note-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Hinweis für den Patienten",
        "min" : 1,
        "type" : [
          {
            "code" : "Annotation"
          }
        ]
      }
    ]
  }
}

```
