# IsEMPExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **IsEMPExtension**

## Extension: IsEMPExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:IsEMPExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Definiert ob etwas einen Bezug zum eMP hat

**Context of Use**

This extension may be used on the following element(s):

* Element ID MedicationStatement.basedOn

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* Examples for this Extension: [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [MedicationStatement/Technical-Exp-NachtragEmpMedicationStatementEml](MedicationStatement-Technical-Exp-NachtragEmpMedicationStatementEml.md), [MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md) and [Parameters/example-epa-op-link-emp-entry-output-parameters-1](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md)
* Search Parameters using this Extension: [IsEMPSP](SearchParameter-based-on-emp-sp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/is-emp-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-is-emp-extension.csv), [Excel](StructureDefinition-is-emp-extension.xlsx), [Schematron](StructureDefinition-is-emp-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "is-emp-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension",
  "version" : "1.3.0",
  "name" : "IsEMPExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Definiert ob etwas einen Bezug zum eMP hat",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement.basedOn"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Definiert ob etwas einen Bezug zum eMP hat"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Hat es einen eMP Bezug?",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
