# EPA Operation Link eMP Parameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Operation Link eMP Parameters**

## Resource Profile: EPA Operation Link eMP Parameters 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-parameters | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAOpLinkEMPEntryParameters |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
EPA Operation Link eMP Parameters 

**Usages:**

* Examples for this Profile: [Parameters/example-epa-op-link-emp-entry-parameters-1](Parameters-example-epa-op-link-emp-entry-parameters-1.md) and [Parameters/example-epa-op-unlink-emp-entry-parameters-1](Parameters-example-epa-op-unlink-emp-entry-parameters-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-op-link-emp-entry-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-op-link-emp-entry-parameters.csv), [Excel](StructureDefinition-epa-op-link-emp-entry-parameters.xlsx), [Schematron](StructureDefinition-epa-op-link-emp-entry-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-op-link-emp-entry-parameters",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-link-emp-entry-parameters",
  "version" : "1.3.0",
  "name" : "EPAOpLinkEMPEntryParameters",
  "title" : "EPA Operation Link eMP Parameters",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "EPA Operation Link eMP Parameters",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationPlanIdentifier",
        "path" : "Parameters.parameter",
        "sliceName" : "medicationPlanIdentifier",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationPlanIdentifier.name",
        "path" : "Parameters.parameter.name",
        "patternString" : "medicationPlanIdentifier",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationPlanIdentifier.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/medication-plan-identifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationPlanIdentifier.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:medicationPlanIdentifier.part",
        "path" : "Parameters.parameter.part",
        "max" : "0"
      }
    ]
  }
}

```
