# EPA Operation addEMLEntry Input-Parameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Operation addEMLEntry Input-Parameters**

## Resource Profile: EPA Operation addEMLEntry Input-Parameters 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-eml-entry-input-parameters | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAOpAddEmlEntryInputParameters |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
EPA Operation addEMLEntry Input-Parameters 

**Usages:**

* Examples for this Profile: [Parameters/example-epa-op-add-eml-entry-input-parameters-1](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-op-add-eml-entry-input-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-op-add-eml-entry-input-parameters.csv), [Excel](StructureDefinition-epa-op-add-eml-entry-input-parameters.xlsx), [Schematron](StructureDefinition-epa-op-add-eml-entry-input-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-op-add-eml-entry-input-parameters",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-eml-entry-input-parameters",
  "version" : "1.3.0",
  "name" : "EPAOpAddEmlEntryInputParameters",
  "title" : "EPA Operation addEMLEntry Input-Parameters",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "EPA Operation addEMLEntry Input-Parameters",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "closed"
        },
        "min" : 2,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationStatement",
        "path" : "Parameters.parameter",
        "sliceName" : "medicationStatement",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationStatement.name",
        "path" : "Parameters.parameter.name",
        "patternString" : "medicationStatement",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationStatement.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:medicationStatement.resource",
        "path" : "Parameters.parameter.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medicationStatement.part",
        "path" : "Parameters.parameter.part",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:medication",
        "path" : "Parameters.parameter",
        "sliceName" : "medication",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medication.name",
        "path" : "Parameters.parameter.name",
        "patternString" : "medication",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medication.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:medication.resource",
        "path" : "Parameters.parameter.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Medication",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:medication.part",
        "path" : "Parameters.parameter.part",
        "max" : "0"
      }
    ]
  }
}

```
