# EPAMedicationStatementProcessingEventExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPAMedicationStatementProcessingEventExtension**

## Extension: EPAMedicationStatementProcessingEventExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medicationstatement-processing-event-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationStatementProcessingEventExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Bildet ein Ereignis ab, das wärend der Verarbeitung auftritt.

**Context of Use**

This extension may be used on the following element(s):

* Element ID MedicationStatement

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* Examples for this Extension: [MedicationStatement/ab495b80-c9d2-4ed6-a076-b44b8dfae75a](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-medicationstatement-processing-event-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-medicationstatement-processing-event-extension.csv), [Excel](StructureDefinition-epa-medicationstatement-processing-event-extension.xlsx), [Schematron](StructureDefinition-epa-medicationstatement-processing-event-extension.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-medicationstatement-processing-event-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medicationstatement-processing-event-extension",
  "version" : "1.3.0",
  "name" : "EPAMedicationStatementProcessingEventExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Bildet ein Ereignis ab, das wärend der Verarbeitung auftritt.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Bildet ein Ereignis ab, das wärend der Verarbeitung auftritt."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:event",
        "path" : "Extension.extension",
        "sliceName" : "event",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:event.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:event.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "event"
      },
      {
        "id" : "Extension.extension:event.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Verarbeitungsereignis",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-medicationstatement-processing-event-code"
        }
      },
      {
        "id" : "Extension.extension:dateTime",
        "path" : "Extension.extension",
        "sliceName" : "dateTime",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:dateTime.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:dateTime.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "dateTime"
      },
      {
        "id" : "Extension.extension:dateTime.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Zeitpunkt",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medicationstatement-processing-event-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
