# EPA MedicationStatement - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MedicationStatement**

## Resource Profile: EPA MedicationStatement 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMedicationStatement |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Hält die Medikationsinformationen eines Eintrags in der elektronischen Medikationsliste (eML) vor und stellt das zentrale Element dar. Es wird zu Verschreibungs- und Dispensierinformationen als auch Nachträgen in der eML genutzt. 

**Hinweis**: Bitte die [Ausführungen des Medication IG DE bezüglich des defekten Constraints tim-9](https://build.fhir.org/ig/hl7germany/medication-ig-de-r4/branches/main/StructureDefinition-TimingDgMP.html#hinweise-zur-verwendung) beachten!

**Usages:**

* Use this Profile: [EPA Operation addEMLEntry Input-Parameters](StructureDefinition-epa-op-add-eml-entry-input-parameters.md), [EPA Operation EMLEntry Output-Parameters](StructureDefinition-epa-op-eml-entry-output-parameters.md) and [EPA Operation Link eMP Output Parameters](StructureDefinition-epa-op-link-emp-entry-output-parameters.md)
* Refer to this Profile: [EMPMedicationRequestActitvityExtension](StructureDefinition-emp-medicationrequest-activity-extension.md)
* Examples for this Profile: [MedicationStatement/0fc1f006-5793-4501-81b6-fe3918fcfa2d](MedicationStatement-0fc1f006-5793-4501-81b6-fe3918fcfa2d.md), [MedicationStatement/133c8159-6398-4937-984a-d741e24556ad](MedicationStatement-133c8159-6398-4937-984a-d741e24556ad.md), [MedicationStatement/1b88713c-64cc-40ad-9665-70ca5f7dfb08](MedicationStatement-1b88713c-64cc-40ad-9665-70ca5f7dfb08.md), [MedicationStatement/1cb0f018-178d-4488-a6b4-2be32dbda784](MedicationStatement-1cb0f018-178d-4488-a6b4-2be32dbda784.md)...Show 9 more,[MedicationStatement/405ff43e-bc8e-4109-b370-3e31431c5fe0](MedicationStatement-405ff43e-bc8e-4109-b370-3e31431c5fe0.md),[MedicationStatement/71601cdb-8a53-4f26-b5d5-e5457b498e76](MedicationStatement-71601cdb-8a53-4f26-b5d5-e5457b498e76.md),[MedicationStatement/Technical-Exp-NachtragEmlMedicationStatement](MedicationStatement-Technical-Exp-NachtragEmlMedicationStatement.md),[MedicationStatement/Technical-Exp-NachtragEmpMedicationStatementEml](MedicationStatement-Technical-Exp-NachtragEmpMedicationStatementEml.md),[MedicationStatement/ab495b80-c9d2-4ed6-a076-b44b8dfae75a](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md),[MedicationStatement/b87b0908-7765-4ec0-8662-7d3daff08f6e](MedicationStatement-b87b0908-7765-4ec0-8662-7d3daff08f6e.md),[MedicationStatement/cfb84928-15d6-468c-8e17-e77f1ed44904](MedicationStatement-cfb84928-15d6-468c-8e17-e77f1ed44904.md),[MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md)and[MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7](MedicationStatement-f3988023-2313-4645-bd6b-f9e37cfb6fc7.md)
* CapabilityStatements using this Profile: [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) and [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-medication-statement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-medication-statement.csv), [Excel](StructureDefinition-epa-medication-statement.xlsx), [Schematron](StructureDefinition-epa-medication-statement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-medication-statement",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement",
  "version" : "1.3.0",
  "name" : "EPAMedicationStatement",
  "title" : "EPA MedicationStatement",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Hält die Medikationsinformationen eines Eintrags in der elektronischen Medikationsliste (eML) vor und stellt das zentrale Element dar. Es wird zu Verschreibungs- und Dispensierinformationen als auch Nachträgen in der eML genutzt.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement",
        "constraint" : [
          {
            "key" : "epa-med-statement-status",
            "severity" : "error",
            "human" : "Ein MedicationStatement im Kontext 'Nachtrag' darf nicht den Status 'intended' haben",
            "expression" : "extension('https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension').exists(value != 'MANUAL') or status != 'intended'",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
          }
        ]
      },
      {
        "id" : "MedicationStatement.meta",
        "path" : "MedicationStatement.meta",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.meta.versionId",
        "path" : "MedicationStatement.meta.versionId",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.meta.lastUpdated",
        "path" : "MedicationStatement.meta.lastUpdated",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.extension",
        "path" : "MedicationStatement.extension",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.extension:context",
        "path" : "MedicationStatement.extension",
        "sliceName" : "context",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.extension:context.value[x]",
        "path" : "MedicationStatement.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-medicationstatement-context-code"
        }
      },
      {
        "id" : "MedicationStatement.extension:rxPrescriptionProcessIdentifier",
        "path" : "MedicationStatement.extension",
        "sliceName" : "rxPrescriptionProcessIdentifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:processingEvent",
        "path" : "MedicationStatement.extension",
        "sliceName" : "processingEvent",
        "short" : "Ein Ereignis, welches während eines Prozessschritts auftritt.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medicationstatement-processing-event-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.extension:renderedDosageInstruction",
        "path" : "MedicationStatement.extension",
        "sliceName" : "renderedDosageInstruction",
        "short" : "Vollständige Darstellung der Dosierungsanweisungen (generiert aus den Dosage-Elementen).",
        "definition" : "Ein menschenlesbarer, vollständiger Text der Dosierungsanweisungen. Der Text wird aus den strukturierten Dosage-Elementen generiert und dient der patientensicheren Darstellung der Dosierung. Er soll die maschinenlesbaren Angaben konsistent wiedergeben und in einer für Patient:innen verständlichen Form bereitstellen.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.extension:generatedDosageInstructionsMeta",
        "path" : "MedicationStatement.extension",
        "sliceName" : "generatedDosageInstructionsMeta",
        "short" : "Metadaten zu den generierten Dosierungsanweisungen",
        "definition" : "Diese Extension enthält zusätzliche Metadaten zu den automatisch generierten Dosierungsanweisungen, wie z.B. Informationen zur Generierung oder zum Ursprung der Daten.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.basedOn",
        "path" : "MedicationStatement.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request",
              "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.basedOn.extension:isEMP",
        "path" : "MedicationStatement.basedOn.extension",
        "sliceName" : "isEMP",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "short" : "unknown | entered-in-error | intended",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa-medication/ValueSet/epa-medication-statement-status-vs"
        }
      },
      {
        "id" : "MedicationStatement.medication[x]",
        "path" : "MedicationStatement.medication[x]",
        "short" : "Arzneimittel, welches diese Medikationsinformation bzw. dieses MedicationStatement näher beschreibt",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.subject.identifier",
        "path" : "MedicationStatement.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kvid-10"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effective[x]",
        "path" : "MedicationStatement.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "effective[x] gibt den Zeitpunkt oder Zeitraum der Gültigkeit der Medikation an",
        "definition" : "Das Element effective[x] gibt den Zeitraum an, in dem die Angaben zur Medikation gültig sind. Je nach Situation kann hierfür ein einzelner Zeitpunkt (effectiveDateTime) oder ein Zeitraum (effectivePeriod mit Start und ggf. Enddatum) angegeben werden",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effective[x]:effectiveDateTime",
        "path" : "MedicationStatement.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "constraint" : [
          {
            "key" : "epa-datetime",
            "severity" : "error",
            "human" : "dateTime muss mindestens aus Tag, Monat und Jahr bestehen",
            "expression" : "toString().matches('^([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\\\.[0-9]+)?(Z|(\\\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?$')",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effective[x]:effectivePeriod",
        "path" : "MedicationStatement.effective[x]",
        "sliceName" : "effectivePeriod",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effective[x]:effectivePeriod.start",
        "path" : "MedicationStatement.effective[x].start",
        "constraint" : [
          {
            "key" : "epa-datetime",
            "severity" : "error",
            "human" : "dateTime muss mindestens aus Tag, Monat und Jahr bestehen",
            "expression" : "toString().matches('^([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\\\.[0-9]+)?(Z|(\\\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?$')",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.effective[x]:effectivePeriod.end",
        "path" : "MedicationStatement.effective[x].end",
        "constraint" : [
          {
            "key" : "epa-datetime",
            "severity" : "error",
            "human" : "dateTime muss mindestens aus Tag, Monat und Jahr bestehen",
            "expression" : "toString().matches('^([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\\\.[0-9]+)?(Z|(\\\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?$')",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dateAsserted",
        "path" : "MedicationStatement.dateAsserted",
        "constraint" : [
          {
            "key" : "epa-datetime",
            "severity" : "error",
            "human" : "dateTime muss mindestens aus Tag, Monat und Jahr bestehen",
            "expression" : "toString().matches('^([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\\\.[0-9]+)?(Z|(\\\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?$')",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.derivedFrom",
        "path" : "MedicationStatement.derivedFrom",
        "short" : "Information des Verschreibungs- und Dispensierprozesses",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request",
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "short" : "Strukturierte Dosierung/Gebrauchsanweisung",
        "definition" : "Hier werden strukturierte Informationen zur Dosierung/Gebrauchsanweisung zur Arzneimitteleinnahme gemäß Vorgabe von HL7 Deutschland e.V. angegeben.",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : [
              "http://ig.fhir.de/igs/medication/StructureDefinition/DosageDgMP"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
