# Batch API eMP-Einträge - Request-Bundle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Batch API eMP-Einträge - Request-Bundle**

## Resource Profile: Batch API eMP-Einträge - Request-Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-batch-emp-request-bundle | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPABatchEmpRequestBundle |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Request-Bundle für die Batch-Operation zur Verarbeitung von eMP-Einträgen. Erlaubt sind ausschließlich FHIR-Operationen (POST) für den eMP. $emp-commit MUSS genau einmal vorkommen. Es sind keine direkten Ressourcen-CRUDs zulässig. 

**Usages:**

* Examples for this Profile: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-batch-emp-request-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-batch-emp-request-bundle.csv), [Excel](StructureDefinition-epa-batch-emp-request-bundle.xlsx), [Schematron](StructureDefinition-epa-batch-emp-request-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-batch-emp-request-bundle",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-batch-emp-request-bundle",
  "version" : "1.3.0",
  "name" : "EPABatchEmpRequestBundle",
  "title" : "Batch API eMP-Einträge - Request-Bundle",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Request-Bundle für die Batch-Operation zur Verarbeitung von eMP-Einträgen.\nErlaubt sind ausschließlich FHIR-Operationen (POST) für den eMP. $emp-commit MUSS genau einmal\nvorkommen. Es sind keine direkten Ressourcen-CRUDs zulässig.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "transaction",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "request.url"
            }
          ],
          "rules" : "closed"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:addEmp",
        "path" : "Bundle.entry",
        "sliceName" : "addEmp",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:addEmp.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:addEmp.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Parameters",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-add-emp-entry-input-parameters"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:addEmp.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:addEmp.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:addEmp.request.method",
        "path" : "Bundle.entry.request.method",
        "patternCode" : "POST"
      },
      {
        "id" : "Bundle.entry:addEmp.request.url",
        "path" : "Bundle.entry.request.url",
        "patternUri" : "$add-emp-entry"
      },
      {
        "id" : "Bundle.entry:addEmp.request.ifNoneMatch",
        "path" : "Bundle.entry.request.ifNoneMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:addEmp.request.ifModifiedSince",
        "path" : "Bundle.entry.request.ifModifiedSince",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:addEmp.request.ifMatch",
        "path" : "Bundle.entry.request.ifMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:addEmp.request.ifNoneExist",
        "path" : "Bundle.entry.request.ifNoneExist",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:addEmp.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp",
        "path" : "Bundle.entry",
        "sliceName" : "updateEmp",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:updateEmp.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:updateEmp.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Parameters",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-update-emp-entry-input-parameters"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:updateEmp.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:updateEmp.request.method",
        "path" : "Bundle.entry.request.method",
        "patternCode" : "POST"
      },
      {
        "id" : "Bundle.entry:updateEmp.request.url",
        "path" : "Bundle.entry.request.url",
        "patternUri" : "$update-emp-entry"
      },
      {
        "id" : "Bundle.entry:updateEmp.request.ifNoneMatch",
        "path" : "Bundle.entry.request.ifNoneMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp.request.ifModifiedSince",
        "path" : "Bundle.entry.request.ifModifiedSince",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp.request.ifMatch",
        "path" : "Bundle.entry.request.ifMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp.request.ifNoneExist",
        "path" : "Bundle.entry.request.ifNoneExist",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:updateEmp.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit",
        "path" : "Bundle.entry",
        "sliceName" : "commit",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:commit.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:commit.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Parameters",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rmp-commit-input-parameters"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:commit.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit.request",
        "path" : "Bundle.entry.request",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:commit.request.method",
        "path" : "Bundle.entry.request.method",
        "patternCode" : "POST"
      },
      {
        "id" : "Bundle.entry:commit.request.url",
        "path" : "Bundle.entry.request.url",
        "patternUri" : "$emp-commit"
      },
      {
        "id" : "Bundle.entry:commit.request.ifNoneMatch",
        "path" : "Bundle.entry.request.ifNoneMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit.request.ifModifiedSince",
        "path" : "Bundle.entry.request.ifModifiedSince",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit.request.ifMatch",
        "path" : "Bundle.entry.request.ifMatch",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit.request.ifNoneExist",
        "path" : "Bundle.entry.request.ifNoneExist",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:commit.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      }
    ]
  }
}

```
