# EMPMedicationRequestActitvityExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EMPMedicationRequestActitvityExtension**

## Extension: EMPMedicationRequestActitvityExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EMPMedicationRequestActitvityExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Bildet eine Aktivität in bezug auf ein EMPMedicationRequest ab

**Context of Use**

This extension may be used on the following element(s):

* Element ID MedicationRequest

**Usage info**

**Usages:**

* Use this Extension: [eMP MedicationRequest](StructureDefinition-emp-medication-request.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md), [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [MedicationRequest/266620a9-2c26-41c1-b0cb-a10947b867f5](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md)...Show 3 more,[MedicationRequest/Technical-Exp-NachtragEmpMedicationRequestEmp](MedicationRequest-Technical-Exp-NachtragEmpMedicationRequestEmp.md),[Parameters/7ccb2670-7178-4f82-912a-de70f68ecd51](Parameters-7ccb2670-7178-4f82-912a-de70f68ecd51.md)and[Parameters/example-epa-op-link-emp-entry-output-parameters-1](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md)
* Search Parameters using this Extension: [MedicationRequestActivitySP](SearchParameter-medication-statement-activity-sp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/emp-medicationrequest-activity-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-emp-medicationrequest-activity-extension.csv), [Excel](StructureDefinition-emp-medicationrequest-activity-extension.xlsx), [Schematron](StructureDefinition-emp-medicationrequest-activity-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "emp-medicationrequest-activity-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension",
  "version" : "1.3.0",
  "name" : "EMPMedicationRequestActitvityExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Bildet eine Aktivität in bezug auf ein EMPMedicationRequest ab",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Bildet eine Aktivität in bezug auf ein EMPMedicationRequest ab"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "closed"
        },
        "min" : 2
      },
      {
        "id" : "Extension.extension:reference",
        "path" : "Extension.extension",
        "sliceName" : "reference",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:reference.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:reference.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "reference"
      },
      {
        "id" : "Extension.extension:reference.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Referenz zu der Resource, die aus der Aktivität resultiert",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:addedOn",
        "path" : "Extension.extension",
        "sliceName" : "addedOn",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:addedOn.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:addedOn.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "addedOn"
      },
      {
        "id" : "Extension.extension:addedOn.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Zeitpunkt, zu dem diese Referenz in den eMP-Eintrag aufgenommen wurde",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medicationrequest-activity-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
