# eMP Medication - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **eMP Medication**

## Resource Profile: eMP Medication 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EMPMedication |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Defines the medication resource for the Medication Service in the ePA system in the eMP context. 

**Usages:**

* Use this Profile: [EPA Operation addEMPEntry Input-Parameters](StructureDefinition-epa-op-add-emp-entry-input-parameters.md) and [EPA Operation EMPEntry Output-Parameters](StructureDefinition-epa-op-emp-entry-output-parameters.md)
* Examples for this Profile: [Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md), [Medication/87f08ba2-da7e-467e-86aa-404d9035297c](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md) and [Medication/Technical-Exp-NachtragEmpMedicationEmp](Medication-Technical-Exp-NachtragEmpMedicationEmp.md)
* CapabilityStatements using this Profile: [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) and [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/emp-medication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-emp-medication.csv), [Excel](StructureDefinition-emp-medication.xlsx), [Schematron](StructureDefinition-emp-medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "emp-medication",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication",
  "version" : "1.3.0",
  "name" : "EMPMedication",
  "title" : "eMP Medication",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Defines the medication resource for the Medication Service in the ePA system in the eMP context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "min" : 1
      },
      {
        "id" : "Medication.extension:context",
        "path" : "Medication.extension",
        "sliceName" : "context",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Medication.extension:context.value[x]",
        "path" : "Medication.extension.value[x]",
        "patternCode" : "EMP"
      }
    ]
  }
}

```
