# eMP Chronology Provenance - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **eMP Chronology Provenance**

## Resource Profile: eMP Chronology Provenance 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EMPChronologyProvenance |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses Profil beschreibt die Verwendung der FHIR-Resource Provenance zur Abbildung eines eMP-Chronologieeintrags. Die Provenance-Instanz dokumentiert, welche eMP-Einträge (MedicationRequest-Instanzen) zu einem bestimmten Zeitpunkt als Teil des elektronischen Medikationsplans (eMP) gültig waren. Ein eMP-Chronologieeintrag wird immer dann erzeugt, wenn sich die eMP-relevanten Instanzen geändert haben oder neue eMP-Einträge hinzugekommen sind. Er referenziert sämtliche zum Erstellungszeitpunkt aktiven eMP-MedicationRequest-Instanzen, d.h. alle Ressourcen mit dem Status active oder on-hold. Dadurch wird der Zustand des Medikationsplans zu diesem Zeitpunkt nachvollziehbar. Der eMP-Chronologieeintrag ermöglicht somit eine eindeutige und versionssichere Rückverfolgung der Zusammensetzung des eMP über verschiedene Zeitpunkte hinweg. 

**Usages:**

* Use this Profile: [EPA Operation EMPEntry Output-Parameters](StructureDefinition-epa-op-emp-entry-output-parameters.md) and [EPA Operation Link eMP Output Parameters](StructureDefinition-epa-op-link-emp-entry-output-parameters.md)
* Examples for this Profile: [Provenance/0b383501-f078-464b-b984-9fdb6751601b](Provenance-0b383501-f078-464b-b984-9fdb6751601b.md), [Provenance/2e112cb5-3b9f-4434-848e-26e27756cd30](Provenance-2e112cb5-3b9f-4434-848e-26e27756cd30.md), [Provenance/2e1ba746-1aef-4eef-b741-2dfc771c7001](Provenance-2e1ba746-1aef-4eef-b741-2dfc771c7001.md), [Provenance/319fcc6e-049d-4eb1-9a5c-82c33438cf94](Provenance-319fcc6e-049d-4eb1-9a5c-82c33438cf94.md) and [Provenance/b467ce05-e0e5-4d71-9a0b-d824dbb492ef](Provenance-b467ce05-e0e5-4d71-9a0b-d824dbb492ef.md)
* CapabilityStatements using this Profile: [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md) and [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/emp-chronology-provenance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-emp-chronology-provenance.csv), [Excel](StructureDefinition-emp-chronology-provenance.xlsx), [Schematron](StructureDefinition-emp-chronology-provenance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "emp-chronology-provenance",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance",
  "version" : "1.3.0",
  "name" : "EMPChronologyProvenance",
  "title" : "eMP Chronology Provenance",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil beschreibt die Verwendung der FHIR-Resource Provenance zur Abbildung eines eMP-Chronologieeintrags. Die Provenance-Instanz dokumentiert, welche eMP-Einträge (MedicationRequest-Instanzen) zu einem bestimmten Zeitpunkt als Teil des elektronischen Medikationsplans (eMP) gültig waren. Ein eMP-Chronologieeintrag wird immer dann erzeugt, wenn sich die eMP-relevanten Instanzen geändert haben oder neue eMP-Einträge hinzugekommen sind. Er referenziert sämtliche zum Erstellungszeitpunkt aktiven eMP-MedicationRequest-Instanzen, d.h. alle Ressourcen mit dem Status active oder on-hold. Dadurch wird der Zustand des Medikationsplans zu diesem Zeitpunkt nachvollziehbar. Der eMP-Chronologieeintrag ermöglicht somit eine eindeutige und versionssichere Rückverfolgung der Zusammensetzung des eMP über verschiedene Zeitpunkte hinweg.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhirauditevent",
      "uri" : "http://hl7.org/fhir/auditevent",
      "name" : "FHIR AuditEvent Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Provenance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Provenance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Provenance",
        "path" : "Provenance",
        "short" : "Dieses Profil beschreibt einen eMP-Chronologieeintrag, der alle zum Erstellungszeitpunkt aktiven eMP-Einträge (active, on-hold) referenziert. Er entsteht bei Änderungen oder neuen Einträgen im eMP."
      },
      {
        "id" : "Provenance.extension",
        "path" : "Provenance.extension",
        "min" : 1
      },
      {
        "id" : "Provenance.extension:isEMPChronology",
        "path" : "Provenance.extension",
        "sliceName" : "isEMPChronology",
        "short" : "Gibt an, ob diese Provenance-Instanz ein eMP-Chronologieeintrag ist.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.extension:isEMPChronology.value[x]",
        "path" : "Provenance.extension.value[x]",
        "patternBoolean" : true
      },
      {
        "id" : "Provenance.target",
        "path" : "Provenance.target",
        "short" : "Gibt die MedicationRequest-Instanzen an, die dem Profil EMPMedicationRequest entsprechen und im Rahmen der Änderung innerhalb des Medication Service erstellt oder aktualisiert wurden. Es muss eine versionierte Referenz (MedicationRequest/id/_history/vid) verwendet werden.",
        "definition" : "Gibt die MedicationRequest-Instanzen an, die dem Profil EMPMedicationRequest entsprechen und im Rahmen der Änderung innerhalb der ePA erstellt oder aktualisiert wurden.\nEs werden ausschließlich MedicationRequest-Instanzen berücksichtigt, die den Status active oder on-hold haben.\nEs muss eine versionierte Referenz (MedicationRequest/id/_history/vid) verwendet werden, um eindeutig die durch diese Änderung entstandene Version der betroffenen Ressource anzugeben.\nDadurch wird eine eindeutige, nachvollziehbare Zuordnung zwischen einer fachlichen Änderung im elektronischen Medikationsplan (eMP) und dem resultierenden Ressourcenzustand gewährleistet.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.target.reference",
        "path" : "Provenance.target.reference",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.occurred[x]",
        "path" : "Provenance.occurred[x]",
        "short" : "Gibt den Zeitraum oder Zeitpunkt an, in dem die  Änderung tatsächlich stattgefunden hat - also wann die Aktion inhaltlich durchgeführt wurde, z.B. das Erfassen oder Bearbeiten von Daten.",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.recorded",
        "path" : "Provenance.recorded",
        "short" : "Gibt den technischen Zeitpunkt an, zu dem dieser eMP-Chronologieeintrag im Medication Service erstellt und persistiert wurde.",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.activity",
        "path" : "Provenance.activity",
        "short" : "Beschreibt die Art der Aktivität, die zur Erstellung des eMP-Chronologieeintrags im FHIR Data Service der ePA geführt hat. Verwendet wird UPDATE, da der Chronologieeintrag eine neue Zusammenstellung des aktuellen Stands der relevanten eMP-Instanzen darstellt.",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent",
        "path" : "Provenance.agent",
        "short" : "Beschreibt die Art der Aktivität, die zur Erstellung des eMP-Chronologieeintrags geführt hat. Verwendet wird UPDATE, da der Chronologieeintrag den aktuellen Stand der eMP-relevanten Instanzen zusammenfasst, nachdem sich diese geändert haben oder neue Instanzen hinzugekommen sind.",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type",
        "path" : "Provenance.agent.type",
        "short" : "Gibt die Rolle oder Funktion an, die der Agent im Rahmen der dokumentierten Änderung eingenommen hat. Im Kontext dieses Profils ist ausschließlich die Rolle author zulässig, da jede Änderung im Medication Service fachlich verantwortet sein muss.",
        "definition" : "Gibt die Rolle oder Funktion an, die der Agent im Rahmen der dokumentierten Änderung eingenommen hat.\nWährend agent.who beschreibt, wer die Änderung durchgeführt hat (z.B. ein System oder eine Institution), legt agent.type fest, in welcher Eigenschaft oder mit welcher funktionalen Verantwortung diese Aktion erfolgt ist. Im Kontext dieses Profils ist ausschließlich die Rolle author zulässig, da jede Änderung im Medication Service fachlich verantwortet sein muss.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/epa/ValueSet/epa-provenance-participant-type-vs"
        }
      },
      {
        "id" : "Provenance.agent.type.coding",
        "path" : "Provenance.agent.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type.coding.system",
        "path" : "Provenance.agent.type.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type.coding.code",
        "path" : "Provenance.agent.type.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type.coding.display",
        "path" : "Provenance.agent.type.coding.display",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/ti-organization",
              "https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.who.reference",
        "path" : "Provenance.agent.who.reference",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.who.identifier",
        "path" : "Provenance.agent.who.identifier",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://fhir.de/StructureDefinition/identifier-kvid-10",
              "http://fhir.de/StructureDefinition/identifier-telematik-id",
              "https://gematik.de/fhir/epa/StructureDefinition/identifier-epa-fhir-data-service"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.who.display",
        "path" : "Provenance.agent.who.display",
        "mustSupport" : true
      }
    ]
  }
}

```
